/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.Icon;
import softcore.print.PreviewFrame;
import softcore.print.PreviewView;
import softcore.print.PrintablePages;
import softcore.tac.Tac;
import softcore.util.IconJAI;
import softcore.util.Message;

public class ImageBrowser
implements PrintablePages,
ImageObserver {
    final String[] imageUrls;
    final Object[] images;
    PreviewView previewView;
    private boolean paintLock;

    public ImageBrowser(String[] as) {
        this.imageUrls = as;
        this.images = new Object[as.length];
    }

    public int printPage(Graphics g, int i, boolean flag, int j) {
        return this.printPage(g, i);
    }

    public int printPage(Graphics g, int i) {
        if (i < 0 || i >= this.images.length) {
            return 1;
        }
        this.loadImage(i);
        if (this.images[i] != null) {
            if (this.images[i] instanceof Image) {
                g.drawImage((Image)this.images[i], 0, 0, this);
            } else if (this.images[i] instanceof Icon) {
                ((Icon)this.images[i]).paintIcon(this.previewView, g, 0, 0);
            }
        }
        return 0;
    }

    public synchronized boolean imageUpdate(Image image, int i, int j, int k, int l, int i1) {
        if ((i & 0xA0) != 0) {
            this.paintLock = false;
            if (this.previewView != null) {
                this.previewView.repaintView();
            }
        }
        return (i & 0xA0) == 0;
    }

    public Dimension getPageSize(int i) {
        this.loadImage(i);
        int j = 0;
        int k = 0;
        if (this.images[i] instanceof Image) {
            j = ((Image)this.images[i]).getHeight(null);
            k = ((Image)this.images[i]).getWidth(null);
        } else if (this.images[i] instanceof Icon) {
            j = ((Icon)this.images[i]).getIconHeight();
            k = ((Icon)this.images[i]).getIconWidth();
        }
        if (j > 0 && k > 0) {
            return new Dimension(k, j);
        }
        return null;
    }

    public void print() throws PrinterException {
        PrinterJob printerjob = PrinterJob.getPrinterJob();
        printerjob.setPrintable(this);
        printerjob.setPageable(this);
        if (printerjob.printDialog()) {
            printerjob.print();
        }
    }

    public boolean printLandScape() {
        return false;
    }

    public int getNumberOfPages() {
        return this.images.length;
    }

    public PageFormat getPageFormat(int i) throws IndexOutOfBoundsException {
        PageFormat pageformat = new PageFormat();
        Dimension dimension = this.getPageSize(i);
        if (dimension != null) {
            Paper paper = pageformat.getPaper();
            paper.setSize(dimension.width, dimension.height);
            pageformat.setPaper(paper);
        }
        return pageformat;
    }

    public Printable getPrintable(int i) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics g, PageFormat pageformat, int i) throws PrinterException {
        return this.printPage(g, i);
    }

    void loadImage(int i) {
        if (i < 0 || i >= this.images.length || this.images[i] != null || this.imageUrls[i] == null) {
            return;
        }
        try {
            RenderedOp renderedop = JAI.create((String)"fileload", (Object)this.imageUrls[i]);
            this.images[i] = new IconJAI((RenderedImage)renderedop);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Message.out.println(exception);
        }
    }

    public static void imageBrowser(String s, String[] as) {
        ImageBrowser imagebrowser = new ImageBrowser(as);
        PreviewFrame previewframe = PreviewFrame.preview(s, imagebrowser);
        imagebrowser.previewView = previewframe.getPreviewView();
        imagebrowser.previewView.repaintView();
    }

    public String[] getEMailAccountInfo() {
        return null;
    }

    public Tac getInterposeTac() {
        return null;
    }
}

