/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.Database;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import softcore.util.Filter;
import softcore.util.IProgressPrompt;
import softcore.util.Message;
import softcore.util.PreprocessedTextReader;
import softcore.util.ProgressBar;
import softcore.util.Utilities;
import softcore.yacc.Yacc;
import softface.MainApp;

public final class JDBC {
    public static Connection defaultJdbcConnection;
    public static final String[] supportedDatabaseTypeName;
    public static int currentDatabaseType;
    static Hashtable connections;
    static boolean dataCacheable;
    static /* synthetic */ Class class$0;

    static {
        supportedDatabaseTypeName = new String[]{"SqlServer"};
        connections = new Hashtable();
        dataCacheable = "true".equalsIgnoreCase(System.getProperty("DataCacheable"));
    }

    private JDBC() {
    }

    public static String sqlModFunction(int i, String s, int j) {
        return JDBC.sqlModFunction(i, s, "" + j);
    }

    public static String sqlModFunction(int i, String s, String s1) {
        if (i == 1) {
            return "(" + s + "-(" + s + '\\' + s1 + ")*" + s1 + ")";
        }
        if (i == 4 || i == 6) {
            return "mod(" + s + ',' + s1 + ')';
        }
        return "(" + s + "%" + s1 + ")";
    }

    public static String sqlDivFunction(int i, String s, int j) {
        if (i == 1) {
            return "(" + s + '\\' + j + ")";
        }
        if (i == 4 || i == 6) {
            return "div(" + s + ',' + j + ')';
        }
        return "(" + s + '/' + j + ")";
    }

    public static String sqlModFunction(String s, int i) {
        return JDBC.sqlModFunction(currentDatabaseType, s, i);
    }

    public static String sqlModFunction(String s, String s1) {
        return JDBC.sqlModFunction(currentDatabaseType, s, s1);
    }

    public static String sqlDivFunction(String s, int i) {
        return JDBC.sqlDivFunction(currentDatabaseType, s, i);
    }

    public static String sql01Function(int i, String s, int j) {
        if (i == 1) {
            return "(" + s + '\\' + j + ")";
        }
        if (i == 4) {
            return "round(" + s + '/' + j + "-0.49999)";
        }
        if (i == 6) {
            return "floor(" + s + '/' + j + ")";
        }
        return "(" + s + '/' + j + ")";
    }

    public static String sql01Function(int i, int j, String s) {
        if (i == 1) {
            return "(" + j + '\\' + s + ")";
        }
        if (i == 4) {
            return "round(" + j + '/' + s + "-0.49999)";
        }
        if (i == 6) {
            return "floor(" + j + '/' + s + ")";
        }
        return "(" + j + '/' + s + ")";
    }

    public static String sqlLeftFunction(int i, String s, int j) {
        if (i == 4) {
            return "substr(" + s + ",1," + j + ")";
        }
        if (i == 3) {
            return "substring(" + s + ",1," + j + ")";
        }
        return "left(" + s + "," + j + ")";
    }

    public static String sqlLeftFunction(int i, String s, String s1) {
        if (i == 4) {
            return "substr(" + s + ",1," + s1 + ")";
        }
        if (i == 3) {
            return "substring(" + s + ",1," + s1 + ")";
        }
        return "left(" + s + "," + s1 + ")";
    }

    public static String sqlLeftFunction(String s, int i) {
        return JDBC.sqlLeftFunction(currentDatabaseType, s, i);
    }

    public static String sql01Function(String s, int i) {
        return JDBC.sql01Function(currentDatabaseType, s, i);
    }

    public static String sql01Function(int i, String s) {
        return JDBC.sql01Function(currentDatabaseType, i, s);
    }

    public static String sqlNameLengthFunction() {
        if (currentDatabaseType == 3) {
            return "char_length";
        }
        return currentDatabaseType != 4 && currentDatabaseType != 6 ? "len" : "length";
    }

    private static final String int2String(int i) {
        return i >= 10 ? "" + i : "0" + i;
    }

    public static String sqlDateConstant(int i, int j, int k, int l) {
        if (i == 4) {
            return "TO_DATE('" + JDBC.int2String(k) + '/' + JDBC.int2String(l) + '/' + j + "','mm/dd/yyyy')";
        }
        if (i == 6) {
            return "'" + j + '-' + JDBC.int2String(k) + '-' + JDBC.int2String(l) + " 00:00:00'";
        }
        char c = '\'';
        if (i == 1) {
            c = '#';
        }
        return "" + c + j + '-' + k + '-' + l + c;
    }

    public static String sqlDateConstant(int i, int j, int k) {
        return JDBC.sqlDateConstant(currentDatabaseType, i, j, k);
    }

    public static String sqlDateConstant(String s) {
        int[] ai;
        if (s != null && (s = s.trim()).length() > 0 && Utilities.parseDate(s, ai = new int[3])) {
            return JDBC.sqlDateConstant(currentDatabaseType, ai[0], ai[1], ai[2]);
        }
        return null;
    }

    public static String sqlDateConstant(java.util.Date date) {
        return JDBC.sqlDateConstant(Utilities.getDateYear(date), Utilities.getDateMonth(date), Utilities.getDateDay(date));
    }

    public static Connection getDefaultJdbcConnection() {
        return defaultJdbcConnection;
    }

    public static String urlDefaultJdbcConnection() {
        Enumeration enumeration = connections.keys();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (connections.get(s) != defaultJdbcConnection) continue;
            return s;
        }
        return null;
    }

    public static String urlDefaultJdbcConnectionNH() {
        int i;
        String s = JDBC.urlDefaultJdbcConnection();
        if (s != null && s.startsWith("jdbc:http://") && (i = s.indexOf("/snsoft/jdbc?", 12)) > 0) {
            s = s.substring(i + 13);
        }
        return s;
    }

    public static String splitUrlProperties(String s, Properties properties) {
        int i = s.lastIndexOf(63);
        if (i > 0) {
            String[] as = Utilities.splitString(s, i + 1, '&');
            s = s.substring(0, i);
            int k = 0;
            while (k < as.length) {
                int j = as[k].indexOf(61);
                if (j > 0) {
                    String s1 = as[k].substring(0, j);
                    String s2 = as[k].substring(j + 1);
                    if (s2.length() > 0 && s1.length() > 0) {
                        properties.put(s1, s2);
                    }
                }
                ++k;
            }
        }
        return s;
    }

    public static Connection getConnection(String s) throws SQLException {
        return JDBC.getConnection(s, true);
    }

    public static Connection getConnection(String s, boolean flag) throws SQLException {
        Connection connection;
        if (s == null) {
            return null;
        }
        String s1 = s;
        Connection connection2 = connection = flag ? (Connection)connections.get(s) : null;
        if (connection == null || connection.isClosed()) {
            Properties properties = new Properties();
            connection = DriverManager.getConnection(s = JDBC.splitUrlProperties(s, properties), properties);
            if (connection != null) {
                if (flag) {
                    connections.put(s1, connection);
                }
            } else {
                Message.out.println("Error on DriverManager.getConnection:" + s);
            }
        }
        return connection;
    }

    public static void closeConnection(String s) {
        Connection connection = (Connection)connections.get(s);
        if (connection != null) {
            try {
                connection.close();
                connections.remove(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeAllConnection(boolean flag) {
        Object obj = null;
        Connection connection = null;
        try {
            Enumeration enumeration = connections.keys();
            while (enumeration.hasMoreElements()) {
                Object obj1 = enumeration.nextElement();
                Connection connection1 = (Connection)connections.get(obj1);
                if (connection1 != null && (flag || connection1 != JDBC.getDefaultJdbcConnection())) {
                    connection1.close();
                    continue;
                }
                obj = obj1;
                connection = connection1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connections.clear();
        if (obj != null && connection != null) {
            connections.put(obj, connection);
        }
    }

    public static boolean isTableExists(Connection connection, String s) throws SQLException {
        Object[] as = JDBC.listAllTables(connection, null, null);
        int i = 0;
        while (i < as.length) {
            int j = ((String)as[i]).lastIndexOf(46);
            if (j >= 0) {
                as[i] = ((String)as[i]).substring(j + 1);
            }
            as[i] = ((String)as[i]).toLowerCase();
            ++i;
        }
        Arrays.sort(as);
        return Arrays.binarySearch(as, s.toLowerCase()) >= 0;
    }

    public static void closeAllConnection() {
        JDBC.closeAllConnection(true);
    }

    public static String[] listAllTables(Connection connection, String s, String s1) throws SQLException {
        String[] stringArray;
        String[] as = new String[]{"TABLE"};
        DatabaseMetaData databasemetadata = connection.getMetaData();
        if (s == null && databasemetadata.getDatabaseProductName().indexOf("Oracle") >= 0) {
            s = databasemetadata.getUserName().toUpperCase();
        }
        ResultSet resultset = databasemetadata.getTables(null, s, s1, as);
        try {
            String[] as2;
            Vector<String> vector = new Vector<String>();
            while (resultset.next()) {
                Object obj = resultset.getObject(2);
                Object obj1 = resultset.getObject(3);
                String s2 = obj == null ? obj1.toString() : String.valueOf(obj.toString()) + '.' + obj1.toString();
                vector.addElement(s2);
            }
            String[] as1 = new String[vector.size()];
            vector.toArray(as1);
            stringArray = as2 = as1;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                resultset.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            resultset.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public static int executeSqlUpdate(String s) throws SQLException {
        return JDBC.executeSqlUpdate(null, s);
    }

    public static int executeSqlUpdate(Connection connection, String s) throws SQLException {
        int n;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        Statement statement = connection.createStatement();
        try {
            int i;
            n = i = statement.executeUpdate(s);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return n;
    }

    public static int executeSqls(Connection connection, String s, IProgressPrompt iprogressprompt, StringBuffer stringbuffer) throws SQLException {
        int n;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null || s == null) {
            return 0;
        }
        Statement statement = connection.createStatement();
        try {
            int i1;
            int i = s.length();
            String s1 = new String();
            int j = 0;
            int k = 0;
            while (k < i) {
                String s2;
                int j1;
                int l = s.indexOf(10, k);
                if (l < 0) {
                    l = i;
                }
                if ((j1 = (s2 = s.substring(k, l).trim()).length()) > 0) {
                    char c = s2.charAt(j1 - 1);
                    if (c == ';' || l >= i) {
                        s1 = String.valueOf(s1) + (c != ';' ? s2 : s2.substring(0, j1 - 1));
                        if (iprogressprompt != null) {
                            iprogressprompt.setProgressText(String.valueOf(Integer.toString(j + 1)) + ':' + s1);
                        }
                        try {
                            statement.executeUpdate(s1);
                        }
                        catch (SQLException sqlexception) {
                            Message.out.println(s1);
                            Message.out.println(sqlexception);
                        }
                        if (stringbuffer != null) {
                            stringbuffer.append(s1);
                            stringbuffer.append(';');
                            stringbuffer.append('\n');
                        }
                        ++j;
                        s1 = new String();
                    } else {
                        s1 = String.valueOf(s1) + s2 + ' ';
                    }
                }
                k = l + 1;
            }
            n = i1 = j;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return n;
    }

    public static int executeSqlsFromFile(Connection connection, String s, IProgressPrompt iprogressprompt, StringBuffer stringbuffer) throws SQLException, FileNotFoundException, IOException, Yacc.YaccErrorException {
        int i;
        StringBuffer stringbuffer1 = new StringBuffer();
        PreprocessedTextReader preprocessedtextreader = new PreprocessedTextReader(new FileReader(s));
        char[] ac = new char[1024];
        while ((i = preprocessedtextreader.read(ac, 0, 1024)) > 0) {
            stringbuffer1.append(ac, 0, i);
        }
        return JDBC.executeSqls(connection, stringbuffer1.toString(), iprogressprompt, stringbuffer);
    }

    public static int addSqlTypesId(Dictionary dictionary, boolean flag) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> class1 = clazz;
            Field[] afield = class1.getFields();
            int i = 0;
            while (i < afield.length) {
                if (flag) {
                    dictionary.put(afield[i].getName(), afield[i].get(null));
                } else {
                    dictionary.put(afield[i].get(null), afield[i].getName());
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        return 0;
    }

    public static int addSqlTypesId(Dictionary dictionary) {
        return JDBC.addSqlTypesId(dictionary, true);
    }

    public static void checkForSQLException(SQLException sqlexception) {
        while (sqlexception != null) {
            Message.out.println("SQLState: " + sqlexception.getSQLState());
            Message.out.println("Message:  " + sqlexception.getMessage());
            Message.out.println("Vendor:   " + sqlexception.getErrorCode());
            sqlexception = sqlexception.getNextException();
        }
    }

    public static final String[] getBitFieldNames(Statement statement, int i, int j) throws SQLException {
        String[] as = null;
        Object[][] aobj = JDBC.sqlSelect3(statement, "select fldid,fldflags,fldname from flddef where tblid=" + i + " order by fldid");
        int k = 1 << j;
        if (aobj != null && aobj.length > 0) {
            int l = 0;
            int i1 = 0;
            while (i1 < aobj.length) {
                if (aobj[i1][1] != null && (((Number)aobj[i1][1]).intValue() & k) > 0) {
                    ++l;
                }
                ++i1;
            }
            if (l > 0) {
                as = new String[l];
                int j1 = 0;
                int k1 = 0;
                while (k1 < aobj.length) {
                    if (aobj[k1][1] != null && (((Number)aobj[k1][1]).intValue() & k) > 0) {
                        as[j1++] = (String)aobj[k1][2];
                    }
                    ++k1;
                }
            }
        }
        return as;
    }

    public static final String[] getBitFieldNames(Connection connection, int i, int j) throws SQLException {
        String[] stringArray;
        block5: {
            Statement statement = null;
            try {
                String[] as;
                statement = connection.createStatement();
                stringArray = as = JDBC.getBitFieldNames(statement, i, j);
                Object var5_6 = null;
                if (statement == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_7 = null;
                    if (statement == null) break block6;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static final void emptyDatabase(Connection connection) {
        Object[][] aobj = null;
        try {
            aobj = JDBC.sqlSelect3(connection, "select tblid,tblname,tblexpl from tbldef order by tblid DESC");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aobj != null && aobj.length > 0) {
            ProgressBar progressbar = new ProgressBar("\u6e05\u7a7a\u6570\u636e");
            Statement statement = null;
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception1) {
                progressbar.dispose();
                return;
            }
            int i = 0;
            while (i < aobj.length) {
                try {
                    progressbar.setProgressText("\u6e05\u7a7a\u8868:" + (String)aobj[i][2]);
                    String s = "delete from " + (String)aobj[i][1];
                    statement.execute(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            progressbar.dispose();
        }
    }

    /*
     * Exception decompiling
     */
    public static Object sqlSelect1(Statement statement, String s) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 77->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object sqlSelect1(Connection connection, String s) throws SQLException {
        Object object;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null) {
            throw new NullPointerException();
        }
        Statement statement = connection.createStatement();
        try {
            Object obj;
            object = obj = JDBC.sqlSelect1(statement, s);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        return object;
    }

    public static Object sqlSelect1(String s) throws SQLException {
        return JDBC.sqlSelect1(null, s);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String sqlSelectLargeText(Connection connection, String s) throws SQLException, IOException {
        block19: {
            block18: {
                block16: {
                    if (connection == null) {
                        connection = JDBC.getDefaultJdbcConnection();
                    }
                    statement = null;
                    resultset = null;
                    try {
                        statement = connection.createStatement();
                        resultset = statement.executeQuery(s);
                        if (resultset.next()) {
                            var7_6 = s1 = Utilities.getTextFromInputStream(resultset.getBinaryStream(1));
                            var5_7 = null;
                            break block16;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var6_13) {
                        var5_8 = null;
                        try {
                            resultset.close();
                        }
                        catch (Exception var8_11) {
                            // empty catch block
                        }
                        try {
                            statement.close();
                            throw var6_13;
                        }
                        catch (Exception var8_11) {
                            // empty catch block
                        }
                        throw var6_13;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [4 : 73->82)] { 
lbl34:
                // 1 sources

                resultset.close();
                break block18;
lbl36:
                // 1 sources

                catch (Exception var8_10) {
                    // empty catch block
                }
            }
            try {}
            catch (Exception var8_10) {
                // empty catch block
                return var7_6;
            }
            statement.close();
            return var7_6;
lbl-1000:
            // 1 sources

            {
                var5_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 73->82)] { 
lbl47:
            // 1 sources

            resultset.close();
            break block19;
lbl49:
            // 1 sources

            catch (Exception var8_12) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var8_12) {
            return null;
        }
        statement.close();
        return null;
    }

    /*
     * Exception decompiling
     */
    public static int sqlSelectInt(Statement statement, String s) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 82->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int sqlSelectInt(Connection connection, String s) throws SQLException {
        int n;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null) {
            throw new NullPointerException();
        }
        Statement statement = connection.createStatement();
        try {
            int i;
            n = i = JDBC.sqlSelectInt(statement, s);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int sqlSelectInt(String s) throws SQLException {
        return JDBC.sqlSelectInt(null, s);
    }

    /*
     * Exception decompiling
     */
    public static String sqlSelectString(Statement statement, String s) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [3 : 123->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String sqlSelectString(Connection connection, String s) throws SQLException {
        String string;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null) {
            throw new NullPointerException();
        }
        Statement statement = connection.createStatement();
        try {
            String s1;
            string = s1 = JDBC.sqlSelectString(statement, s);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String sqlSelectString(String s) throws SQLException {
        return JDBC.sqlSelectString(null, s);
    }

    public static Object[] sqlSelect2(ResultSet resultset) throws SQLException {
        ResultSetMetaData resultsetmetadata = resultset.getMetaData();
        int i = resultsetmetadata.getColumnCount();
        if (i > 1) {
            if (resultset.next()) {
                Object[] aobj = new Object[i];
                int j = 0;
                while (j < i) {
                    try {
                        aobj[j] = resultset.getObject(j + 1);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ++j;
                }
                return aobj;
            }
        } else {
            Vector<Object> vector = new Vector<Object>();
            while (resultset.next()) {
                Object obj = null;
                try {
                    Object obj1 = resultset.getObject(1);
                    vector.addElement(obj1);
                }
                catch (SQLException obj1) {
                    // empty catch block
                }
            }
            if (vector.size() > 0) {
                Object[] aobj1 = new Object[vector.size()];
                int k = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    aobj1[k++] = enumeration.nextElement();
                }
                return aobj1;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] sqlSelect2(Statement statement, String s) throws SQLException {
        Object[] objectArray;
        ResultSet resultset = null;
        try {
            Object[] aobj;
            resultset = statement.executeQuery(s);
            objectArray = aobj = JDBC.sqlSelect2(resultset);
            Object var4_6 = null;
            if (resultset == null) return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (resultset == null) throw throwable;
            try {
                resultset.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return objectArray;
        }
        resultset.close();
        return objectArray;
    }

    public static Object[] sqlSelect2(Connection connection, String s) throws SQLException {
        Object[] objectArray;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null) {
            throw new NullPointerException();
        }
        Statement statement = connection.createStatement();
        try {
            Object[] aobj;
            objectArray = aobj = JDBC.sqlSelect2(statement, s);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectArray;
    }

    public static Object[] sqlSelect2(String s) throws SQLException {
        return JDBC.sqlSelect2(null, s);
    }

    public static Object[][] sqlSelect3(ResultSet resultset) throws SQLException {
        return JDBC.sqlSelect3(resultset, 0, null);
    }

    public static Object[][] sqlSelect3(ResultSet resultset, int i) throws SQLException {
        return JDBC.sqlSelect3(resultset, i, null);
    }

    public static Object[][] sqlSelect3Ex(ResultSet resultset) throws SQLException {
        ResultSetMetaData resultsetmetadata = resultset.getMetaData();
        int j = resultsetmetadata.getColumnCount();
        boolean count = false;
        return null;
    }

    public static Object[][] sqlSelect3(ResultSet resultset, int i, Object[] aobj) throws SQLException {
        ResultSetMetaData resultsetmetadata = resultset.getMetaData();
        int j = resultsetmetadata.getColumnCount();
        if (aobj != null) {
            if (aobj.length >= 1) {
                aobj[0] = new String[j];
            }
            int k = 0;
            while (k < j) {
                if (aobj.length >= 1) {
                    ((String[])aobj[0])[k] = resultsetmetadata.getColumnName(k + 1);
                }
                ++k;
            }
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        while (resultset.next()) {
            Object[] aobj1 = new Object[j + i];
            int i1 = 0;
            while (i1 < j) {
                try {
                    aobj1[i1] = resultset.getObject(i1 + 1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++i1;
            }
            vector.addElement(aobj1);
        }
        int l = vector.size();
        Object[][] aobj2 = new Object[l][];
        int j1 = 0;
        while (j1 < l) {
            aobj2[j1] = (Object[])vector.elementAt(j1);
            ++j1;
        }
        return aobj2;
    }

    public static Object[][] sqlSelect3(Statement statement, String s) throws SQLException {
        return JDBC.sqlSelect3(statement, s, 0, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[][] sqlSelect3(Statement statement, String s, int i, Object[] aobj) throws SQLException {
        Object[][] objectArray;
        ResultSet resultset = null;
        try {
            try {
                Object[][] aobj1;
                resultset = statement.executeQuery(s);
                objectArray = aobj1 = JDBC.sqlSelect3(resultset, i, aobj);
                Object var6_8 = null;
                if (resultset == null) return objectArray;
            }
            catch (SQLException sqlexception) {
                if (!MainApp.isDebug) throw sqlexception;
                Message.out.println(String.valueOf(s) + ":" + sqlexception);
                throw sqlexception;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (resultset == null) throw throwable;
            try {
                resultset.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return objectArray;
        }
        resultset.close();
        return objectArray;
    }

    public static Object[][] sqlSelect3(Connection connection, String s, int i, Object[] aobj) throws SQLException {
        Object[][] objectArray;
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection == null) {
            throw new NullPointerException();
        }
        Statement statement = connection.createStatement();
        try {
            Object[][] aobj1;
            objectArray = aobj1 = JDBC.sqlSelect3(statement, s, i, aobj);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectArray;
    }

    public static Statement openStatement() {
        try {
            Connection connection = JDBC.getDefaultJdbcConnection();
            Statement statement = connection.createStatement();
            return statement;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[][] sqlSelect3(Connection connection, String s) throws SQLException {
        return JDBC.sqlSelect3(connection, s, 0, null);
    }

    public static Object[][] sqlSelect3(String s, int i) throws SQLException {
        return JDBC.sqlSelect3(null, s, i, null);
    }

    public static Object[][] sqlSelect3(String s) throws SQLException {
        return JDBC.sqlSelect3(null, s);
    }

    public static Object[][] sqlSelect3(String s, Object[] aobj) throws SQLException {
        return JDBC.sqlSelect3(null, s, 0, aobj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[][] loadCacheableValues(String s) throws SQLException {
        if (!dataCacheable) {
            return JDBC.sqlSelect3(s);
        }
        if (s == null) {
            return null;
        }
        String s1 = JDBC.urlDefaultJdbcConnection();
        if (s1 == null) {
            return JDBC.sqlSelect3(s);
        }
        try {
            Object[][] objectArray;
            DataInputStream datainputstream;
            block16: {
                Object[][] objectArray2;
                block15: {
                    URLConnection urlconnection = Utilities.getSimpleServerURLConnection();
                    if (urlconnection == null) {
                        return JDBC.sqlSelect3(s);
                    }
                    DataOutputStream dataoutputstream = new DataOutputStream(urlconnection.getOutputStream());
                    dataoutputstream.writeByte(20);
                    dataoutputstream.writeUTF(s1);
                    dataoutputstream.writeInt(0);
                    dataoutputstream.writeUTF(s);
                    dataoutputstream.flush();
                    dataoutputstream.close();
                    datainputstream = new DataInputStream(urlconnection.getInputStream());
                    try {
                        int i = datainputstream.readInt();
                        long l = datainputstream.readLong();
                        if (i == -2) {
                            throw new SQLException(datainputstream.readUTF());
                        }
                        if (i <= 0) {
                            Object[][] aobj;
                            objectArray2 = aobj = new Object[0][];
                            Object var17_12 = null;
                            break block15;
                        }
                        Object[][] aobj1 = new Object[i][];
                        int j = datainputstream.readInt();
                        byte[] abyte0 = new byte[j];
                        datainputstream.readFully(abyte0);
                        ZipInputStream zipinputstream = new ZipInputStream(new ByteArrayInputStream(abyte0));
                        ZipEntry zipentry = zipinputstream.getNextEntry();
                        if (zipentry == null || !"DATA".equals(zipentry.getName())) {
                            throw new SQLException("inEntry=" + zipentry);
                        }
                        DataInputStream datainputstream1 = new DataInputStream(zipinputstream);
                        int k = 0;
                        block4: while (true) {
                            if (k >= i) {
                                Object[][] aobj2;
                                datainputstream1.close();
                                objectArray = aobj2 = aobj1;
                                break block16;
                            }
                            int i1 = datainputstream1.readInt();
                            aobj1[k] = i1 >= 0 ? new Object[i1] : null;
                            int j1 = 0;
                            while (true) {
                                if (j1 >= i1) {
                                    ++k;
                                    continue block4;
                                }
                                aobj1[k][j1] = JDBC.readDataObject(datainputstream1);
                                ++j1;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_14 = null;
                        datainputstream.close();
                        throw throwable;
                    }
                }
                datainputstream.close();
                return objectArray2;
            }
            Object var17_13 = null;
            datainputstream.close();
            return objectArray;
        }
        catch (IOException ioexception) {
            throw new SQLException(ioexception.getMessage());
        }
    }

    public static int loadCacheableInt(String s) throws SQLException {
        if (!dataCacheable) {
            return JDBC.sqlSelectInt(s);
        }
        Object obj = JDBC.loadCacheableValue1(s);
        return obj instanceof Number ? ((Number)obj).intValue() : 0;
    }

    public static String loadCacheableString(String s) throws SQLException {
        if (!dataCacheable) {
            return JDBC.sqlSelectString(s);
        }
        Object obj = JDBC.loadCacheableValue1(s);
        if (obj instanceof byte[]) {
            return new String((byte[])obj);
        }
        return obj == null ? null : obj.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object loadCacheableValue1(String s) throws SQLException {
        if (!dataCacheable) {
            return JDBC.sqlSelect1(s);
        }
        if (s == null) {
            return null;
        }
        String s1 = JDBC.urlDefaultJdbcConnection();
        if (s1 == null) {
            return JDBC.sqlSelect1(s);
        }
        try {
            Object var9_10;
            DataInputStream datainputstream;
            block11: {
                Object object;
                block10: {
                    URLConnection urlconnection = Utilities.getSimpleServerURLConnection();
                    if (urlconnection == null) {
                        return JDBC.sqlSelect1(s);
                    }
                    DataOutputStream dataoutputstream = new DataOutputStream(urlconnection.getOutputStream());
                    dataoutputstream.writeByte(22);
                    dataoutputstream.writeUTF(s1);
                    dataoutputstream.writeInt(0);
                    dataoutputstream.writeUTF(s);
                    dataoutputstream.flush();
                    dataoutputstream.close();
                    datainputstream = new DataInputStream(urlconnection.getInputStream());
                    try {
                        Object obj1;
                        int i = datainputstream.readInt();
                        if (i == -2) {
                            throw new SQLException(datainputstream.readUTF());
                        }
                        if (i == 1) {
                            Object obj;
                            object = obj = JDBC.readDataObject(datainputstream);
                            Object var7_11 = null;
                            break block10;
                        }
                        var9_10 = obj1 = null;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        datainputstream.close();
                        throw throwable;
                    }
                }
                datainputstream.close();
                return object;
            }
            Object var7_12 = null;
            datainputstream.close();
            return var9_10;
        }
        catch (IOException ioexception) {
            throw new SQLException(ioexception.getMessage());
        }
    }

    public static void notifyServerTableUpdated(String s) {
        if (!dataCacheable) {
            return;
        }
        System.err.println("notifyServerTableUpdated:" + s);
        if (s == null) {
            return;
        }
        try {
            URLConnection urlconnection = Utilities.getSimpleServerURLConnection();
            if (urlconnection == null) {
                return;
            }
            String s1 = JDBC.urlDefaultJdbcConnection();
            if (s1 == null) {
                return;
            }
            DataOutputStream dataoutputstream = new DataOutputStream(urlconnection.getOutputStream());
            dataoutputstream.writeByte(21);
            dataoutputstream.writeUTF(s1);
            dataoutputstream.writeUTF(s);
            dataoutputstream.close();
            urlconnection.getInputStream().close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Dictionary sqlSelectTo(Dictionary dictionary, Connection connection, String s, String s1, int i) throws SQLException {
        return JDBC.sqlSelectTo(dictionary, connection, s, s1, i, null, null);
    }

    public static Dictionary sqlSelectTo(Dictionary dictionary, Connection connection, String s, String s1) throws SQLException {
        return JDBC.sqlSelectTo(dictionary, connection, s, s1, -1, null, null);
    }

    public static Dictionary sqlSelectTo(String s, String s1) throws SQLException {
        return JDBC.sqlSelectTo(null, null, s, s1, -1, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dictionary sqlSelectTo(Dictionary dictionary, Connection connection, String s, String s1, int i, int[] ai, Filter filter) throws SQLException {
        block24: {
            if (connection == null) {
                connection = JDBC.getDefaultJdbcConnection();
            }
            statement = null;
            resultset = null;
            try {
                statement = connection.createStatement();
                resultset = statement.executeQuery(s);
                resultsetmetadata = resultset.getMetaData();
                j = resultsetmetadata.getColumnCount();
                if (dictionary == null) {
                    dictionary = new Hashtable<String, Object[]>();
                }
                if (i < 0 && ai == null) {
                    ai = new int[j];
                    k = 0;
                    while (k < j) {
                        ai[k] = k;
                        ++k;
                    }
                }
                aobj = new Object[j];
                while (resultset.next()) {
                    block22: {
                        aobj1 = null;
                        l = 0;
                        while (true) {
                            if (l >= j) {
                                if (ai != null) {
                                    break;
                                }
                                break block22;
                            }
                            obj = aobj[l] = resultset.getObject(l + 1);
                            if (l == i) {
                                aobj1 = (Object[])obj;
                            }
                            ++l;
                        }
                        aobj2 = new Object[ai.length];
                        i1 = 0;
                        while (true) {
                            if (i1 >= ai.length) {
                                aobj1 = aobj2;
                                break;
                            }
                            aobj2[i1] = aobj[ai[i1]];
                            ++i1;
                        }
                    }
                    s2 = Utilities.format(s1, aobj);
                    if (aobj1 == null || filter != null && !filter.filterAccept(s2)) continue;
                    dictionary.put(s2, aobj1);
                }
            }
            catch (Throwable var16_20) {
                var15_21 = null;
                try {
                    resultset.close();
                }
                catch (Exception var17_23) {
                    // empty catch block
                }
                try {
                    statement.close();
                    throw var16_20;
                }
                catch (Exception var17_23) {
                    // empty catch block
                }
                throw var16_20;
            }
            {
                var15_22 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 280->290)] { 
lbl69:
            // 1 sources

            resultset.close();
            break block24;
lbl71:
            // 1 sources

            catch (Exception var17_24) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var17_24) {
            return dictionary;
        }
        statement.close();
        return dictionary;
    }

    public static String getFullName(Connection connection, String s, String s1, String s2, String s3) {
        String s4 = null;
        try {
            if (connection == null) {
                connection = JDBC.getDefaultJdbcConnection();
            }
            Database database = new Database(connection);
            QueryDataSet querydataset = new QueryDataSet();
            querydataset.setQuery(new QueryDescriptor(database, s, null, true, 2));
            querydataset.open();
            if (querydataset.isOpen()) {
                s4 = JDBC.getFullName((DataSet)querydataset, s1, s2, s3);
                querydataset.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        return s4;
    }

    public static String getFullName(DataSet dataset, String s, String s1, String s2) {
        String s3 = null;
        if (s != null && s.length() > 0 && dataset != null && dataset.isOpen()) {
            boolean flag = false;
            try {
                DataRow datarow = new DataRow(dataset, s1);
                datarow.setString(s1, s);
                dataset.enableDataSetEvents(false);
                long l = dataset.getInternalRow();
                dataset.first();
                String s4 = dataset.getString(s1);
                int i = s4.length();
                if (dataset.locate((ReadRow)datarow, 32)) {
                    s3 = dataset.getString(s2);
                    s3 = s3.trim();
                    String s5 = s;
                    while (dataset.prior()) {
                        String s6 = dataset.getString(s1);
                        int j = s5.length();
                        int k = s6.length();
                        if (k == j && k <= i) break;
                        if (k >= j) continue;
                        String s7 = s5.substring(0, k);
                        if (!s7.equals(s6)) break;
                        String s8 = dataset.getString(s2);
                        s8 = s8.trim();
                        s3 = String.valueOf(s8) + "-" + s3;
                        s5 = s6;
                    }
                    if (s3 != null && s3.length() > 0 && s3.indexOf(45) == 0) {
                        s3 = s3.substring(1);
                    }
                    dataset.goToInternalRow(l);
                }
                dataset.enableDataSetEvents(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s3;
    }

    public static final String[] getTablePrimaryKey(Connection connection, String s) throws SQLException {
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        if (connection != null) {
            String[] stringArray;
            DatabaseMetaData databasemetadata = connection.getMetaData();
            String s1 = null;
            if (databasemetadata.getDatabaseProductName().indexOf("Oracle") >= 0) {
                s1 = databasemetadata.getUserName().toUpperCase();
                if (s != null) {
                    s = s.toUpperCase();
                }
            }
            ResultSet resultset = databasemetadata.getPrimaryKeys(null, s1, s);
            try {
                String[] as2;
                String[] as = new String[64];
                int i = 0;
                while (resultset.next()) {
                    as[i++] = resultset.getString(4);
                }
                String[] as1 = new String[i];
                System.arraycopy(as, 0, as1, 0, i);
                stringArray = as2 = as1;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    resultset.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultset.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return stringArray;
        }
        return null;
    }

    public static final String buildPrimaryOrderedSqlFromTablename(Connection connection, String s) {
        String s1 = "select * from " + s;
        try {
            String[] as = JDBC.getTablePrimaryKey(connection, s);
            if (as != null) {
                int i = 0;
                while (i < as.length) {
                    s1 = String.valueOf(s1) + (i != 0 ? "," : " order by ") + as[i];
                    ++i;
                }
            }
        }
        catch (SQLException sqlexception) {
            sqlexception.printStackTrace(Message.out);
        }
        return s1;
    }

    public static final DriverPropertyInfo[] getDriverPropertyInfo(String s, String s1, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Driver driver = (Driver)Class.forName(s).newInstance();
        return driver.getPropertyInfo(s1, properties);
    }

    public static final DriverPropertyInfo[] getDriverPropertyInfo(String s, String s1) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Properties properties = new Properties();
        s1 = JDBC.splitUrlProperties(s1, properties);
        return JDBC.getDriverPropertyInfo(s, s1, properties);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int updateRecord(Connection connection, String s, String[] as, Object[] aobj, String[] as1, Object[] aobj1, String[] as2, Object[] aobj2) throws SQLException {
        block26: {
            if (as2 == null) {
                as2 = as1;
                aobj2 = aobj1;
            }
            if (as.length != aobj.length) {
                throw new IllegalArgumentException();
            }
            if (connection == null) {
                connection = JDBC.getDefaultJdbcConnection();
            }
            s1 = "update " + s + Utilities.stringConnect(" set %0=?", ",%0=?", as1) + Utilities.stringConnect(" where %0=?", " and %0=?", as);
            preparedstatement = connection.prepareStatement(s1);
            try {
                i = 0;
                while (true) {
                    if (i >= as1.length) break;
                    preparedstatement.setObject(i + 1, aobj1[i]);
                    ++i;
                }
                j = 0;
                while (true) {
                    block25: {
                        if (j < as.length) break block25;
                        l = preparedstatement.executeUpdate();
                        if (l > 0) {
                            var14_14 = j1 = l;
                            var12_16 = null;
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    preparedstatement.setObject(as1.length + j + 1, aobj[j]);
                    ++j;
                }
            }
            catch (Throwable var13_24) {
                var12_17 = null;
                try {
                    preparedstatement.close();
                    throw var13_24;
                }
                catch (Exception var15_21) {
                    // empty catch block
                }
                throw var13_24;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 197->207)] { 
lbl42:
            // 1 sources

            preparedstatement.close();
            return var14_14;
lbl44:
            // 1 sources

            catch (Exception var15_20) {
                // empty catch block
            }
            return var14_14;
lbl-1000:
            // 1 sources

            {
                var12_18 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 197->207)] { 
lbl49:
            // 1 sources

            preparedstatement.close();
            break block26;
lbl51:
            // 1 sources

            catch (Exception var15_22) {
                // empty catch block
            }
        }
        s2 = "insert into " + s + Utilities.stringConnect("(%0", ",%0", as) + Utilities.stringConnect(",%0", ",%0", as2) + Utilities.stringConnect(") values (?", ",?", new Object[as.length + as2.length]) + ")";
        preparedstatement = connection.prepareStatement(s2);
        try {
            k = 0;
            while (true) {
                if (k >= as.length) break;
                preparedstatement.setObject(k + 1, aobj[k]);
                ++k;
            }
            i1 = 0;
            while (true) {
                block27: {
                    if (i1 < as2.length) break block27;
                    k1 = preparedstatement.executeUpdate();
                    if (k1 > 0) {
                        var15_23 = l1 = k1;
                        var13_25 = null;
                        break;
                    }
                    ** GOTO lbl-1000
                }
                preparedstatement.setObject(as.length + i1 + 1, aobj2[i1]);
                ++i1;
            }
        }
        catch (Throwable var14_15) {
            var13_26 = null;
            try {
                preparedstatement.close();
                throw var14_15;
            }
            catch (Exception var16_29) {
                // empty catch block
            }
            throw var14_15;
        }
        ** try [egrp 4[TRYBLOCK] [5 : 400->410)] { 
lbl88:
        // 1 sources

        preparedstatement.close();
        return var15_23;
lbl90:
        // 1 sources

        catch (Exception var16_28) {
            // empty catch block
        }
        return var15_23;
lbl-1000:
        // 1 sources

        {
            var13_27 = null;
        }
        try {}
        catch (Exception var16_30) {
            return 0;
        }
        preparedstatement.close();
        return 0;
    }

    public static boolean storesUpperCaseIdentifiers(Connection connection) {
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        try {
            return connection.getMetaData().storesUpperCaseIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countTables(Connection connection, String s) throws SQLException {
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        String[] as = new String[]{"TABLE"};
        DatabaseMetaData databasemetadata = connection.getMetaData();
        String s1 = null;
        String s2 = null;
        try {
            if (databasemetadata.storesUpperCaseIdentifiers()) {
                s = s.toUpperCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultset = databasemetadata.getTables(s1, s2, s, as);
        int i = 0;
        try {
            while (resultset.next()) {
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                resultset.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (Exception exception) {
            return i;
        }
        resultset.close();
        return i;
    }

    public static boolean hasTableColumn(String s, String s1) {
        return JDBC.hasTableColumn(null, s, s1);
    }

    /*
     * Exception decompiling
     */
    public static boolean hasTableColumn(Connection connection, String s, String s1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 129->132)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String[] hasTableColumns(Connection connection, String s, String[] as) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 167->170)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public static String sqlNormalize(String s) {
        if (s == null) {
            return null;
        }
        ac = s.toCharArray();
        i = 0;
        flag = false;
        flag1 = false;
        j = 0;
        while (j < ac.length) {
            block7: {
                c = ac[j];
                if (c != '\'') break block7;
                flag = flag == false;
                ** GOTO lbl-1000
            }
            if (c <= ' ' && !flag) {
                if (i > 0 && Character.isJavaIdentifierPart(ac[i - 1])) {
                    flag1 = true;
                }
            } else lbl-1000:
            // 2 sources

            {
                if (c >= 'A' && c <= 'Z' && !flag) {
                    c = (char)(c - 65 + 97);
                }
                if (flag1 && Character.isJavaIdentifierPart(c)) {
                    ac[i++] = 32;
                }
                flag1 = false;
                ac[i++] = c;
            }
            ++j;
        }
        return new String(ac, 0, i);
    }

    public static String addFilter(String s, String s1, String s2) {
        if (s2 == null) {
            return s;
        }
        if (s == null) {
            return s2;
        }
        return String.valueOf(s) + " " + s1 + " " + s2;
    }

    public static String addLikeFilter(String s, String s1, String s2, String s3) {
        if (s3 == null || (s3 = s3.trim()).length() == 0) {
            return s;
        }
        String[] as = Utilities.splitString(s3, '&');
        String s4 = null;
        boolean flag = false;
        int i = 0;
        while (i < as.length) {
            String s5 = Utilities.filterFormat("or", String.valueOf(s2) + " like '%0'", null, as[i], true);
            if (s4 == null) {
                s4 = s5;
            } else {
                s4 = String.valueOf(s4) + " and " + s5;
                flag = true;
            }
            ++i;
        }
        if (flag) {
            s4 = "(" + s4 + ")";
        }
        return s != null && s.trim().length() != 0 ? String.valueOf(s) + ' ' + s1 + ' ' + s4 : s4;
    }

    public static String addDateRangeFilter(String s, String s1, String s2, String s3) {
        if (s3 == null || (s3 = s3.trim()).length() == 0) {
            return s;
        }
        String[] as = Utilities.splitString(s3, ',');
        if (as == null || as.length == 0) {
            return s;
        }
        String s4 = null;
        String s5 = null;
        try {
            if (as[0].length() > 0) {
                s4 = JDBC.sqlDateConstant(as[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (as.length >= 2 && as[1].length() > 0) {
            try {
                s5 = JDBC.sqlDateConstant(as[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return JDBC.addDateRangeFilter(s, s1, s2, s4, s5, false);
    }

    public static String addDateRangeFilter(String s, String s1, String s2, String s3, String s4) {
        return JDBC.addDateRangeFilter(s, s1, s2, s3, s4, false);
    }

    public static String addDateRangeFilter(String s, String s1, String s2, String s3, String s4, boolean flag) {
        if (flag) {
            try {
                s3 = JDBC.sqlDateConstant(s3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s4 = JDBC.sqlDateConstant(s4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String s5 = null;
        if (s3 != null && s4 != null) {
            s5 = String.valueOf(s2) + " between " + s3 + " and " + s4;
        } else if (s3 != null) {
            s5 = String.valueOf(s2) + ">=" + s3;
        } else if (s4 != null) {
            s5 = String.valueOf(s2) + "<=" + s4;
        }
        if (s5 == null) {
            return s;
        }
        return s != null && s.trim().length() != 0 ? String.valueOf(s) + ' ' + s1 + ' ' + s5 : s5;
    }

    public static String buildLikeOneOf(String s, String s1, String s2) {
        int i;
        if (s2 == null || s2.length() == 0 || s2.equals("%")) {
            return "";
        }
        if (s == null) {
            s = "";
        }
        if ((i = s2.indexOf(44)) < 0) {
            return String.valueOf(s) + " " + s1 + (s2.indexOf(37) >= 0 || s2.indexOf(95) >= 0 ? " like " : "=") + "'" + s2 + "'";
        }
        return String.valueOf(s) + " " + s1 + " in (" + Utilities.filterFormat(",", "'%0'", null, s2, false) + ")";
    }

    static final Object readDataObject(DataInput datainput) throws IOException {
        Object obj = null;
        byte byte0 = datainput.readByte();
        switch (byte0) {
            case 0: {
                obj = null;
                break;
            }
            case 1: {
                obj = new Boolean(datainput.readBoolean());
                break;
            }
            case 2: {
                obj = new Byte(datainput.readByte());
                break;
            }
            case 3: {
                obj = new Short(datainput.readShort());
                break;
            }
            case 4: {
                obj = new Integer(datainput.readInt());
                break;
            }
            case 5: {
                obj = new Long(datainput.readLong());
                break;
            }
            case 6: {
                obj = BigInteger.valueOf(datainput.readLong());
                break;
            }
            case 7: {
                obj = datainput.readUTF();
                break;
            }
            case 8: {
                obj = new Float(datainput.readFloat());
                break;
            }
            case 9: {
                obj = new Double(datainput.readDouble());
                break;
            }
            case 10: {
                byte[] abyte0 = new byte[datainput.readUnsignedShort()];
                datainput.readFully(abyte0);
                obj = new BigDecimal(new BigInteger(abyte0), datainput.readUnsignedShort());
                break;
            }
            case 11: {
                obj = new java.util.Date(datainput.readLong());
                break;
            }
            case 12: {
                obj = new Date(datainput.readLong());
                break;
            }
            case 13: {
                obj = new Timestamp(datainput.readLong());
                break;
            }
            case 14: {
                byte[] abyte1 = new byte[datainput.readInt()];
                datainput.readFully(abyte1);
                obj = new String(abyte1);
                break;
            }
            case 15: {
                obj = new Character(datainput.readChar());
                break;
            }
            case 16: 
            case 100: {
                obj = new byte[datainput.readInt()];
                datainput.readFully((byte[])obj);
                break;
            }
            case 17: {
                obj = null;
                break;
            }
            default: {
                throw new RuntimeException("readDataObject:unknown type " + byte0);
            }
        }
        return obj;
    }

    public static final class SqlTypeInfo {
        public short type;
        public String name;
        public boolean autoInc;

        public static SqlTypeInfo[] getTypeInfo(DatabaseMetaData databasemetadata) throws SQLException {
            SqlTypeInfo[] sqlTypeInfoArray;
            ResultSet resultset = databasemetadata.getTypeInfo();
            try {
                SqlTypeInfo[] asqltypeinfo2;
                SqlTypeInfo[] asqltypeinfo = new SqlTypeInfo[256];
                int i = 0;
                while (resultset.next()) {
                    asqltypeinfo[i] = new SqlTypeInfo();
                    asqltypeinfo[i].name = resultset.getString(1);
                    asqltypeinfo[i].type = resultset.getShort(2);
                    asqltypeinfo[i].autoInc = resultset.getBoolean(12);
                    ++i;
                }
                SqlTypeInfo[] asqltypeinfo1 = new SqlTypeInfo[i];
                int j = 0;
                while (j < i) {
                    asqltypeinfo1[j] = asqltypeinfo[j];
                    ++j;
                }
                sqlTypeInfoArray = asqltypeinfo2 = asqltypeinfo1;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    resultset.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                resultset.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return sqlTypeInfoArray;
        }

        public static SqlTypeInfo findByName(SqlTypeInfo[] asqltypeinfo, String s) {
            int i = 0;
            while (i < asqltypeinfo.length) {
                if (asqltypeinfo[i].name.equalsIgnoreCase(s)) {
                    return asqltypeinfo[i];
                }
                ++i;
            }
            return null;
        }

        public static SqlTypeInfo findByType(SqlTypeInfo[] asqltypeinfo, int i) {
            int j = 0;
            while (j < asqltypeinfo.length) {
                if (asqltypeinfo[j].type == i) {
                    return asqltypeinfo[j];
                }
                ++j;
            }
            return null;
        }

        private SqlTypeInfo() {
        }
    }
}

