/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import softcore.awt.AwtUtil;
import softcore.awt.DialogPanel;
import softcore.awt.InsetsedJPanel;
import softcore.util.MessageEFrame;
import softcore.util.MessageIFrame;
import softcore.util.MessageOutputStream;
import softcore.util.MessageWriter;
import softcore.util.UnReportableException;
import softface.MainApp;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;

public final class Message {
    public static MessageEFrame messageEFrame;
    public static MessageIFrame messageIFrame;
    public static final PrintWriter out;
    private static PrintStream outStream;

    static {
        out = new PrintWriter(new MessageWriter());
    }

    private Message() {
    }

    public static final void clear() {
        JTextArea jtextarea = null;
        if (messageIFrame != null) {
            jtextarea = Message.messageIFrame.textArea;
        } else if (messageEFrame != null) {
            jtextarea = Message.messageEFrame.textArea;
        }
        if (jtextarea != null) {
            jtextarea.setText("");
        }
    }

    public static final void appendText(String s) {
        JMDIDesktopPane appdesktoppane2;
        JTextArea jtextarea = null;
        if (messageIFrame != null) {
            jtextarea = Message.messageIFrame.textArea;
        } else if (messageEFrame != null) {
            jtextarea = Message.messageEFrame.textArea;
        }
        if (jtextarea == null && (appdesktoppane2 = MainFrame.getDesktopPane()) != null) {
            if (messageIFrame == null) {
                messageIFrame = new MessageIFrame();
                messageIFrame.addInternalFrameListener(appdesktoppane2);
                messageIFrame.setSize(450, 400);
                AwtUtil.locateRandom(messageIFrame, appdesktoppane2);
                appdesktoppane2.add((Component)messageIFrame, JLayeredPane.PALETTE_LAYER);
                messageIFrame.setVisible(true);
            }
            jtextarea = Message.messageIFrame.textArea;
        }
        if (jtextarea == null && messageEFrame == null) {
            messageEFrame = new MessageEFrame();
            messageEFrame.setSize(450, 400);
            messageEFrame.show();
            jtextarea = Message.messageEFrame.textArea;
        }
        if (messageIFrame != null && messageIFrame.isClosed()) {
            try {
                messageIFrame.setClosed(false);
            }
            catch (PropertyVetoException appdesktoppane2) {
                // empty catch block
            }
            JMDIDesktopPane appdesktoppane1 = MainFrame.getDesktopPane();
            if (appdesktoppane1 != null && !appdesktoppane1.isAncestorOf(messageIFrame)) {
                appdesktoppane1.add((Component)messageIFrame, JLayeredPane.PALETTE_LAYER);
            }
            messageIFrame.setVisible(true);
        }
        if (jtextarea != null) {
            jtextarea.append(s);
        }
    }

    public static final void printException(Throwable throwable, boolean flag) {
        if (!(throwable instanceof UnReportableException)) {
            if (flag) {
                throwable.printStackTrace(out);
            } else {
                out.println(throwable);
            }
        }
    }

    public static final PrintStream getOutputStream() {
        if (outStream == null) {
            outStream = new PrintStream(new MessageOutputStream());
        }
        return outStream;
    }

    public static int showMessageDialog(String s, String s1, int i, String[] as) {
        return Message.showMessageDialog(null, s, s1, i, as);
    }

    public static int showMessageDialog(Component component, String s, String s1, int i, String[] as) {
        DialogPanel dialogpanel = Message.createMessageDialogPanel(s1, i);
        JButton[] ajbutton = new JButton[as.length];
        int j = 0;
        while (j < ajbutton.length) {
            ajbutton[j] = new JButton(as[j]);
            ++j;
        }
        String[] as1 = new String[]{"error", "information", "warning", "question"};
        if (s == null) {
            s = as1[i];
        }
        return dialogpanel.showDialog(component, s, ajbutton);
    }

    public static DialogPanel createMessageDialogPanel(String s, int i) {
        String[] as = new String[]{"error", "information", "warning", "question"};
        DialogPanel dialogpanel = new DialogPanel();
        InsetsedJPanel insetsedjpanel = new InsetsedJPanel(20, 20, 20, 20);
        insetsedjpanel.setLayout(new GridBagLayout());
        if (s == null) {
            s = "";
        }
        int j = 0;
        DialogPanel.initGBC();
        DialogPanel.gbc.gridx = 1;
        DialogPanel.gbc.insets = new Insets(0, 10, 0, 20);
        DialogPanel.gbc.anchor = 17;
        int k = 0;
        while (j >= 0) {
            int i1;
            String s1;
            int l = j;
            if ((j = s.indexOf(10, j)) >= 0) {
                s1 = s.substring(l, j);
                ++j;
            } else {
                s1 = s.substring(l);
                j = -1;
            }
            DialogPanel.gbc.gridy = k++;
            while ((i1 = s1.indexOf(9)) >= 0) {
                s1 = String.valueOf(s1.substring(0, i1)) + "    " + s1.substring(i1 + 1);
            }
            insetsedjpanel.add((Component)new JLabel(s1), DialogPanel.gbc);
        }
        DialogPanel.gbc.anchor = 10;
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.gridy = 0;
        DialogPanel.gbc.gridheight = k;
        JLabel jlabel = new JLabel(UIManager.getIcon("OptionPane." + as[i] + "Icon"));
        insetsedjpanel.add((Component)jlabel, DialogPanel.gbc);
        dialogpanel.add(insetsedjpanel);
        return dialogpanel;
    }

    public static int showInformationDialog(String s, String s1) {
        return Message.showMessageDialog(s, s1, 1, new String[]{"\u5173\u95ed"});
    }

    public static int showInformationDialog(String s) {
        return Message.showMessageDialog("\u4fe1\u606f", s, 1, new String[]{"\u5173\u95ed"});
    }

    public static int showErrorDialog(String s, String s1) {
        return Message.showMessageDialog(s, s1, 0, new String[]{"\u5173\u95ed"});
    }

    public static int showErrorDialog(String s) {
        return Message.showMessageDialog("\u9519\u8bef", s, 0, new String[]{"\u5173\u95ed"});
    }

    public static int showWarningDialog(String s, String s1) {
        return Message.showMessageDialog(s, s1, 2, new String[]{"\u5173\u95ed"});
    }

    public static int showQuestionDialog(String s, String s1) {
        return Message.showMessageDialog(s, s1, 3, new String[]{"\u662f", "\u5426", "\u653e\u5f03"});
    }

    public static void debugPrintln(String s) {
        if (MainApp.isDebug) {
            System.out.println(s);
        }
    }

    public static void debugPrint(String s) {
        if (MainApp.isDebug) {
            System.out.print(s);
        }
    }

    public static final void debugPrintException(Throwable throwable, boolean flag) {
        if (MainApp.isDebug) {
            if (flag) {
                throwable.printStackTrace();
            } else {
                System.out.println(throwable);
            }
        }
    }
}

