/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.math.BigDecimal;
import java.util.Date;
import softcore.util.Type;
import softcore.util.Utilities;

public class NumCapUtil {
    private static final String[] digEngCapitalWord = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};

    private static final String toChnCapitalWord(int i, String[] as) {
        int j = as.length;
        boolean flag = false;
        String s = "";
        int k = 0;
        while (k < j) {
            int l = i % 10;
            i /= 10;
            if (l == 0) {
                flag = s.length() > 0;
            } else {
                String s1 = String.valueOf("\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".charAt(l)) + as[k];
                s = flag ? String.valueOf(s1) + "\u96f6" + s : String.valueOf(s1) + s;
                flag = false;
            }
            ++k;
        }
        return s;
    }

    private static final String toEngCapitalWord2(int i) {
        if (i == 0) {
            return "";
        }
        if (i < 10) {
            return digEngCapitalWord[i];
        }
        if (i < 20) {
            String[] as = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
            return as[i - 10];
        }
        String[] as1 = new String[]{"TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
        return String.valueOf(as1[i / 10 - 2]) + (i % 10 != 0 ? " " + digEngCapitalWord[i % 10] : "");
    }

    private static final String toEngCapitalWord3(int i) {
        String s = NumCapUtil.toEngCapitalWord2(i % 100);
        int j = i / 100;
        String s1 = "";
        if (j > 0) {
            s1 = String.valueOf(digEngCapitalWord[j]) + " HUNDRED";
        }
        if (s1.length() > 0 && s.length() > 0) {
            return String.valueOf(s1) + " AND " + s;
        }
        return String.valueOf(s1) + s;
    }

    private static final String toCapitalWord(long l, boolean flag, String[] as, String[] as1) {
        int i = flag ? 3 : as.length;
        int j = as1.length;
        int k = 1;
        int i1 = 0;
        while (i1 < i) {
            k *= 10;
            ++i1;
        }
        boolean flag1 = false;
        String s = "";
        int k1 = 0;
        int l1 = 0;
        while (l1 < j && l != 0L) {
            int j1 = k1;
            k1 = (int)(l % (long)k);
            l /= (long)k;
            if (!flag1) {
                boolean bl = flag1 = s.length() > 0 && (j1 < k / 10 || k1 > 0 && k1 % 10 == 0);
            }
            if (k1 != 0) {
                String s2;
                String s1 = flag ? String.valueOf(NumCapUtil.toEngCapitalWord3(k1)) + as1[l1] : String.valueOf(NumCapUtil.toChnCapitalWord(k1, as)) + as1[l1];
                String string = s2 = flag1 ? "\u96f6" : "";
                if (flag && s.length() > 0) {
                    s2 = "";
                }
                s = String.valueOf(s1) + s2 + s;
                flag1 = false;
            }
            ++l1;
        }
        return s;
    }

    public static final String toChnCapitalWord(long l) {
        return NumCapUtil.toCapitalWord(l, false, new String[]{"", "\u62fe", "\u4f70", "\u4edf"}, new String[]{"", "\u4e07", "\u4ebf", "\u4e07\u4ebf", "\u4ebf\u4ebf"});
    }

    public static final String toEngCapitalWord(long l) {
        return NumCapUtil.toCapitalWord(l, true, null, new String[]{"", " THOUSAND ", " MILLION ", " BILLION "});
    }

    public static final String toCyChnCapitalWord(BigDecimal bigdecimal) {
        return NumCapUtil.toCyCapitalWord(bigdecimal, false);
    }

    public static final String toCyEngCapitalWord(BigDecimal bigdecimal) {
        return NumCapUtil.toCyCapitalWord(bigdecimal, true);
    }

    public static final String toCyCapitalWord(BigDecimal bigdecimal, boolean flag) {
        String s;
        if (bigdecimal == null) {
            return null;
        }
        int i = bigdecimal.signum();
        if (i < 0) {
            bigdecimal = bigdecimal.negate();
        }
        if (bigdecimal.scale() > 2) {
            bigdecimal = bigdecimal.setScale(2, 4);
        }
        long l = bigdecimal.movePointRight(2).longValue();
        long l1 = l / 100L;
        String string = s = flag ? NumCapUtil.toEngCapitalWord(l1) : NumCapUtil.toChnCapitalWord(l1);
        if (s.length() > 0 && !flag) {
            s = String.valueOf(s) + "\u5143";
        }
        int j = (int)(l % 100L);
        int k = j % 10;
        int i1 = j / 10;
        if (!flag) {
            if (j != 0 && l1 != 0L && (i1 == 0 || l1 % 10L == 0L)) {
                s = String.valueOf(s) + "\u96f6";
            }
            if (i1 != 0) {
                s = String.valueOf(s) + "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".charAt(i1) + "\u89d2";
            }
            if (k != 0) {
                s = String.valueOf(s) + "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".charAt(k) + "\u5206";
            }
            if (s.length() == 0) {
                s = "\u96f6\u5143";
            }
            if (k == 0) {
                s = String.valueOf(s) + "\u6574";
            }
        } else if (j != 0) {
            if (s.length() > 0) {
                s = String.valueOf(s) + " AND ";
            }
            s = String.valueOf(s) + NumCapUtil.toEngCapitalWord3(j) + " CENTS";
        } else {
            s = s.length() == 0 ? "ZERO ONLY" : String.valueOf(s) + " ONLY";
        }
        return s;
    }

    public static final String toCyChnCapitalWord(double d) {
        return NumCapUtil.toCyChnCapitalWord(new BigDecimal(d));
    }

    public static final String toCapitalWord(Number number, boolean flag) {
        return NumCapUtil.toCapitalWord(Type.toBigDecimal(number), flag);
    }

    public static final String toCapitalWord(BigDecimal bigdecimal, boolean flag) {
        if (bigdecimal == null) {
            return null;
        }
        int i = bigdecimal.signum();
        if (i < 0) {
            bigdecimal = bigdecimal.negate();
        }
        long l = bigdecimal.longValue();
        String s = flag ? NumCapUtil.toEngCapitalWord(l) : NumCapUtil.toChnCapitalWord(l);
        String s1 = bigdecimal.toString();
        int j = s1.indexOf(46);
        if (j < 0 || j >= s1.length() - 1) {
            return s;
        }
        s = String.valueOf(s) + (flag ? " POINT" : "\u70b9");
        while (j < s1.length() - 1) {
            int k = s1.charAt(++j) - 48;
            s = flag ? String.valueOf(s) + " " + digEngCapitalWord[k] : String.valueOf(s) + "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".charAt(k);
        }
        return s;
    }

    public static final String toChnCapitalWord(double d) {
        return NumCapUtil.toCapitalWord(new BigDecimal(d), false);
    }

    public static final String dateToChnCapital(Date date) {
        String s2;
        String s1;
        if (date == null) {
            return null;
        }
        int i = Utilities.getDateYear(date);
        int j = Utilities.getDateMonth(date);
        int k = Utilities.getDateDay(date);
        if (i < 1000 || i > 9999 || k < 1 || k > 31 || j < 1 || j > 12) {
            throw new IllegalArgumentException();
        }
        String s = "";
        int l = 0;
        while (l < 4) {
            s = String.valueOf("\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".charAt(i % 10)) + s;
            i /= 10;
            ++l;
        }
        String string = s1 = j < 10 ? "" : "\u5341";
        if (j != 10) {
            s1 = String.valueOf(s1) + "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".charAt(j % 10);
        }
        String string2 = s2 = k < 20 ? "" : "" + "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".charAt(k / 10);
        if (k >= 10) {
            s2 = String.valueOf(s2) + "\u5341";
        }
        if (k % 10 != 0) {
            s2 = String.valueOf(s2) + "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".charAt(k % 10);
        }
        return String.valueOf(s) + "\u5e74" + s1 + "\u6708" + s2 + "\u65e5";
    }
}

