/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import softcore.util.IntConstExprYacc;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softcore.yacc.Yacc;
import softface.MainApp;

public class PreprocessedTextReader
extends Reader {
    private int lineNumber = 1;
    private Dictionary macro;
    private Reader[] in;
    int topInReader;
    private short[] buffer_LineNumber;
    private String[] buffer_Text;
    private int buffer_Count;
    private int buffer_n;
    private int ibuffer;
    private int jbuffer;
    private char[] tmpId = new char[64];
    private static final String[] PSC = new String[]{"if", "elif", "else", "endif", "define", "undef", "include", "error", "listpreprocess", "definefromtable"};
    private byte[] ifStack = new byte[32];
    private int iStack;
    private final IntConstExprYacc intConstExprYacc = new IntConstExprYacc(null, this.macro);
    private StringBuffer stringBuffer = new StringBuffer();

    public void setMacro(Dictionary dictionary) {
        this.intConstExprYacc.macro = this.macro = dictionary;
    }

    private Dictionary _getMacro() {
        if (this.macro == null) {
            this.intConstExprYacc.macro = this.macro = new Hashtable();
        }
        return this.macro;
    }

    public void defineMacro(String s, String s1) {
        if (s1 == null) {
            if (this.macro != null) {
                this.macro.remove(s);
            }
        } else {
            this._getMacro().put(s, s1);
        }
    }

    public static void defineDefaultMacro(Dictionary dictionary) {
        if (dictionary == null) {
            return;
        }
        dictionary.put("__ISDEBUG__", MainApp.isDebug ? "1" : "0");
        dictionary.put("__CURDATE__", String.valueOf(Utilities.yearRightNow) + "-" + Utilities.monthRightNow + "-" + Utilities.dayRightNow);
        dictionary.put("__CURDATEYEAR__", "" + Utilities.yearRightNow);
        dictionary.put("__CURDATEMONTH__", "" + Utilities.monthRightNow);
        dictionary.put("__CURDATEDAY__", "" + Utilities.dayRightNow);
    }

    public Dictionary getMacro() {
        return this.macro;
    }

    public PreprocessedTextReader(Reader reader) throws IOException {
        this(reader, null);
    }

    public PreprocessedTextReader(Reader reader, Dictionary dictionary) throws IOException {
        this.in = new Reader[8];
        this.in[0] = reader;
        this.topInReader = 0;
        this.macro = dictionary;
    }

    private char nextInChar() throws IOException {
        int i;
        while ((i = this.in[this.topInReader].read()) <= 0) {
            if (this.topInReader <= 0) {
                return '\u0000';
            }
            this.in[this.topInReader].close();
            this.in[this.topInReader] = null;
            --this.topInReader;
        }
        return (char)i;
    }

    private void addReader(Reader reader) {
        if (reader != null) {
            this.in[++this.topInReader] = reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                int i = 0;
                while (i < this.in.length) {
                    if (this.in[i] != null) {
                        this.in[i].close();
                    }
                    ++i;
                }
                this.in = null;
            }
        }
    }

    public int getBuffer(Object[] aobj) {
        aobj[0] = this.buffer_LineNumber;
        aobj[1] = this.buffer_Text;
        return this.buffer_n;
    }

    protected void addBufferLine(int i, String s) {
        if (s == null) {
            return;
        }
        if (this.buffer_n >= this.buffer_Count) {
            short[] aword0 = new short[this.buffer_Count + 64];
            String[] as = new String[this.buffer_Count + 64];
            if (this.buffer_n > 0) {
                System.arraycopy(this.buffer_LineNumber, 0, aword0, 0, this.buffer_n);
                System.arraycopy(this.buffer_Text, 0, as, 0, this.buffer_n);
            }
            this.buffer_LineNumber = aword0;
            this.buffer_Text = as;
            this.buffer_Count += 64;
        }
        this.buffer_LineNumber[this.buffer_n] = (short)i;
        this.buffer_Text[this.buffer_n] = s;
        ++this.buffer_n;
    }

    private String getId(String s, int i) {
        int j = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!(j > 0 && Character.isJavaIdentifierPart(c) || j == 0 && Character.isJavaIdentifierStart(c))) break;
            this.tmpId[j++] = c;
            ++i;
        }
        return j != 0 ? new String(this.tmpId, 0, j) : null;
    }

    boolean ifTrue() {
        int i = 0;
        while (i < this.iStack && this.ifStack[i] == 1) {
            ++i;
        }
        return i == this.iStack;
    }

    boolean ifTrue(int i) {
        int j = 0;
        while (j < i && this.ifStack[j] == 1) {
            ++j;
        }
        return j == i;
    }

    private void throwErrorIf(boolean flag) throws Yacc.YaccErrorException {
        if (flag) {
            throw new Yacc.YaccErrorException("Error on line " + this.lineNumber);
        }
    }

    private String macroReplace(String s) {
        if (this.macro == null) {
            return s;
        }
        int i = 0;
        while (i < 16) {
            String s1 = Utilities.macroReplace(s, this.macro);
            if (s1 == s) {
                return s1;
            }
            s = s1;
            ++i;
        }
        Message.out.println("Error:Macro?" + s);
        return s;
    }

    private void parseInputLine(String s) throws IOException, Yacc.YaccErrorException {
        String s1;
        if (s == null) {
            return;
        }
        int i = s.length();
        int j = Utilities.countWhitespace(s, 0);
        if (j >= i) {
            return;
        }
        char c = s.charAt(j);
        int k = -1;
        if (c == '#' && (s1 = this.getId(s, j + 1)) != null) {
            int l = 0;
            while (l < PSC.length) {
                if (s1.equals(PSC[l])) {
                    k = l;
                    j += 1 + s1.length();
                    break;
                }
                ++l;
            }
        }
        if (k < 0) {
            if (this.ifTrue()) {
                this.addBufferLine(this.lineNumber, this.macroReplace(s));
            }
        } else {
            j += Utilities.countWhitespace(s, j);
            s = s.substring(j);
            j = 0;
            switch (k) {
                default: {
                    break;
                }
                case 0: {
                    this.throwErrorIf(this.iStack >= 32);
                    if (this.ifTrue()) {
                        this.ifStack[this.iStack++] = (byte)(this.intConstExprYacc.findExpr(this.macroReplace(s)) != 0 ? 1 : 0);
                        break;
                    }
                    this.ifStack[this.iStack++] = 0;
                    break;
                }
                case 1: {
                    this.throwErrorIf(this.iStack <= 0);
                    if (this.ifStack[this.iStack - 1] == 1) {
                        this.ifStack[this.iStack - 1] = 2;
                        break;
                    }
                    if (this.ifStack[this.iStack - 1] != 0 || !this.ifTrue(this.iStack - 1)) break;
                    this.ifStack[this.iStack - 1] = (byte)(this.intConstExprYacc.findExpr(this.macroReplace(s)) != 0 ? 1 : 0);
                    break;
                }
                case 2: {
                    this.throwErrorIf(this.iStack <= 0);
                    this.ifStack[this.iStack - 1] = (byte)(this.ifStack[this.iStack - 1] == 0 ? 1 : 0);
                    break;
                }
                case 3: {
                    this.throwErrorIf(this.iStack <= 0);
                    --this.iStack;
                    break;
                }
                case 4: {
                    String s2;
                    if (!this.ifTrue() || (s2 = this.getId(s, 0)) == null) break;
                    String s4 = s.substring(j += s2.length());
                    if (s4.startsWith("=java:")) {
                        try {
                            String s7 = (String)Utilities.invokeJavaX(s4.substring(6), null);
                            s4 = s7 != null ? s7.toString() : "";
                        }
                        catch (Exception exception1) {
                            exception1.printStackTrace(Message.out);
                        }
                    }
                    this._getMacro().put(s2, s4.trim());
                    break;
                }
                case 5: {
                    String s3;
                    if (!this.ifTrue() || (s3 = this.getId(s, 0)) == null) break;
                    this.macro.remove(s3);
                    break;
                }
                case 6: {
                    if (!this.ifTrue()) break;
                    if (s.startsWith("java:")) {
                        try {
                            String s5 = (String)Utilities.invokeJavaX(s.substring(5), null);
                            if (s5 == null) break;
                            this.addReader(new StringReader(String.valueOf(s5) + "\n"));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Message.out);
                        }
                        break;
                    }
                    if (s.startsWith("macro:")) {
                        Object obj = this.macro.get(s.substring(6).trim());
                        if (!(obj instanceof String)) break;
                        this.addReader(new StringReader(String.valueOf((String)obj) + "\n"));
                        break;
                    }
                    if (!s.startsWith("sql:")) break;
                    try {
                        String s6 = JDBC.sqlSelectString(s.substring(4).trim());
                        if (s6 == null) break;
                        this.addReader(new StringReader(String.valueOf(s6) + "\n"));
                    }
                    catch (SQLException sqlexception) {
                        sqlexception.printStackTrace(Message.out);
                    }
                    break;
                }
                case 7: {
                    if (!this.ifTrue()) break;
                    throw new Yacc.YaccErrorException("Error on line " + this.lineNumber + ":" + s);
                }
                case 8: {
                    if (!this.ifTrue()) break;
                    this.list(Message.out);
                    break;
                }
                case 9: {
                    if (!this.ifTrue()) break;
                }
            }
        }
    }

    private void parseInputLine() throws IOException, Yacc.YaccErrorException {
        this.parseInputLine(this.stringBuffer.toString());
        this.stringBuffer = new StringBuffer();
    }

    /*
     * Unable to fully structure code
     */
    public void parseInput() throws IOException, Yacc.YaccErrorException {
        c = '\u0000';
        i = '\u0000';
        j = 0;
        PreprocessedTextReader.defineDefaultMacro(this._getMacro());
        block0: while (true) {
            block17: {
                block18: {
                    if (c == '\u0000') {
                        c1 = this.nextInChar();
                    } else {
                        c1 = c;
                        c = '\u0000';
                    }
                    if (c1 <= '\u0000') {
                        this.parseInputLine();
                        c1 = this.nextInChar();
                        if (c1 == '\u0000') break;
                    }
                    if (c1 != '/' || i != '\u0000') break block17;
                    c2 = this.nextInChar();
                    if (c2 == '/') {
                        while ((c1 = this.nextInChar()) != '\u0000' && c1 != '\n') {
                        }
                        this.parseInputLine();
                        ++this.lineNumber;
                        continue;
                    }
                    if (c2 != '*') break block18;
                    while (true) {
                        if ((c1 = this.nextInChar()) == '\u0000') continue block0;
                        if (c1 == '*') ** GOTO lbl31
                        if (c1 != '\n') continue;
                        ++this.lineNumber;
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            c1 = this.nextInChar();
lbl31:
                            // 2 sources

                            ** while (c1 == '*')
                        }
lbl32:
                        // 1 sources

                        if (c1 == '/' || c1 == '\u0000') break;
                    }
                    continue;
                }
                this.stringBuffer.append(c1);
                c = c2;
                continue;
            }
            if (c1 == '\\' && i == '\u0000') {
                c3 = this.nextInChar();
                if (c3 == '\n' || c3 == '\r') {
                    ++this.lineNumber;
                    while ((c1 = this.nextInChar()) != '\u0000' && c1 <= ' ') {
                        if (c1 != '\n') continue;
                        ++this.lineNumber;
                    }
                    this.stringBuffer.append(c1);
                    continue;
                }
                this.stringBuffer.append(c1);
                c = c3;
                continue;
            }
            if (i == c1) {
                i = '\u0000';
            } else if (i == '\u0000' && (c1 == '\"' || c1 == '\'')) {
                i = c1;
            }
            if (c1 == '\n') {
                this.parseInputLine();
                ++this.lineNumber;
            }
            if (c1 == '\r' || c1 == '\n') continue;
            this.stringBuffer.append(c1);
        }
        this.parseInputLine();
        j = 0;
        while (j < this.in.length) {
            if (this.in[j] != null) {
                this.in[j].close();
            }
            ++j;
        }
        this.in = null;
    }

    public int read(char[] ac, int i, int j) throws IOException {
        if (this.in != null) {
            try {
                this.parseInput();
            }
            catch (Yacc.YaccErrorException yaccerrorexception) {
                Message.out.println(yaccerrorexception);
                return -1;
            }
        }
        int k = 0;
        while (k < j) {
            int l = 0;
            if (this.ibuffer < this.buffer_n) {
                if (this.jbuffer >= this.buffer_Text[this.ibuffer].length()) {
                    ++this.ibuffer;
                    this.jbuffer = 0;
                    l = 10;
                } else {
                    l = this.buffer_Text[this.ibuffer].charAt(this.jbuffer++);
                }
            }
            if (l <= 0) break;
            ac[i + k++] = (char)l;
        }
        return k <= 0 ? -1 : k;
    }

    public String readLine() throws IOException {
        if (this.in != null) {
            try {
                this.parseInput();
            }
            catch (Yacc.YaccErrorException yaccerrorexception) {
                Message.out.println(yaccerrorexception);
                return null;
            }
        }
        String s = null;
        if (this.ibuffer < this.buffer_n) {
            s = this.jbuffer != 0 ? this.buffer_Text[this.ibuffer].substring(this.jbuffer) : this.buffer_Text[this.ibuffer];
            ++this.ibuffer;
            this.jbuffer = 0;
        }
        return s;
    }

    public String getAsText() throws IOException {
        if (this.in != null) {
            try {
                this.parseInput();
            }
            catch (Yacc.YaccErrorException yaccerrorexception) {
                Message.out.println(yaccerrorexception);
                return null;
            }
        }
        String s = null;
        while (this.ibuffer < this.buffer_n) {
            String s1 = String.valueOf(this.jbuffer != 0 ? this.buffer_Text[this.ibuffer].substring(this.jbuffer) : this.buffer_Text[this.ibuffer]) + "\r\n";
            s = s == null ? s1 : String.valueOf(s) + s1;
            ++this.ibuffer;
            this.jbuffer = 0;
        }
        return s;
    }

    public int getLineNo() {
        return this.ibuffer >= this.buffer_n ? 0 : this.buffer_LineNumber[this.ibuffer];
    }

    public void list(PrintWriter printwriter) {
        if (this.in != null) {
            try {
                this.parseInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.buffer_n) {
            printwriter.println("" + this.buffer_LineNumber[i] + ':' + this.buffer_Text[i]);
            ++i;
        }
    }

    public void listMacro(PrintWriter printwriter) {
        if (this.macro == null) {
            return;
        }
        Enumeration enumeration = this.macro.keys();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object obj1 = this.macro.get(obj);
            printwriter.println(String.valueOf(obj.toString()) + "=" + obj1);
        }
    }
}

