/*
 * Decompiled with CFR 0.152.
 */
package softcore.util.wtool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import softcore.awt.AwtUtil;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.LabelAsAppMenuItem;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;

public final class CmdTreeFrame
extends JInternalFrame {
    CmdTreePanel panel;
    JScrollPane scrollPanel;

    public CmdTreeFrame(String s, LabelAsAppMenuItem labelasappmenuitem, Image[] aimage, boolean flag, int i) {
        super(s, true, true, true, true);
        this.panel = new CmdTreePanel(labelasappmenuitem, aimage, flag, i);
        if (labelasappmenuitem != null) {
            labelasappmenuitem.autoSetDisabled();
            this.setTitle(String.valueOf(s != null ? this.title : "\u83dc\u5355\u6811") + " (" + labelasappmenuitem.getText() + ")");
        }
        this.scrollPanel = new JScrollPane(this.panel);
        this.getContentPane().add((Component)this.scrollPanel, "Center");
        int j = this.panel.getSize().width;
        int k = this.panel.getSize().height;
        if (aimage != null && aimage[0] != null) {
            int i1;
            ImageIcon imageicon = new ImageIcon(aimage[0]);
            int l = imageicon.getIconWidth();
            if (l > j) {
                j = l;
            }
            if ((i1 = imageicon.getIconHeight()) > k) {
                k = i1;
            }
        }
        if (j > 800) {
            j = 800;
        }
        if (k > 560) {
            k = 560;
        }
        this.setSize(j + 12, k + 60);
        this.show();
        this.setVisible(true);
        JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
        if (appdesktoppane != null) {
            AwtUtil.locateRandom(this, appdesktoppane);
            appdesktoppane.add((Component)this, JLayeredPane.PALETTE_LAYER);
        }
        try {
            this.setSelected(true);
            this.setMaximum(true);
            this.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showFrame(String s, LabelAsAppMenuItem labelasappmenuitem, Image image, boolean flag, int i) {
        new CmdTreeFrame(s, labelasappmenuitem, new Image[]{image}, flag, i);
    }

    public static void showFrame(String s, LabelAsAppMenuItem labelasappmenuitem, Image[] aimage, boolean flag, int i) {
        new CmdTreeFrame(s, labelasappmenuitem, aimage, flag, i);
    }

    public static void showFrame(String s, String s1, String s2) {
        CmdTreeFrame.showFrame(s, s1, s2, true, 4);
    }

    public static void showFrame(String s, String s1) {
        CmdTreeFrame.showFrame(null, s, s1, true, 4);
    }

    public static CmdTreePanel createCmdTreePanel(String s, String s1, boolean flag, int i) {
        LabelAsAppMenuItem[] alabelasappmenuitem = CmdTreeFrame.getMenusByPrix(s);
        if (alabelasappmenuitem == null || alabelasappmenuitem.length == 0) {
            return null;
        }
        Image[] aimage = CmdTreeFrame.getImageByRes(s1);
        CmdTreePanel cmdtreepanel = new CmdTreePanel(alabelasappmenuitem[0], aimage, flag, i);
        return cmdtreepanel;
    }

    public static LabelAsAppMenuItem[] getMenusByPrix(String s) {
        LabelAsAppMenuItem[] alabelasappmenuitem = null;
        String s1 = "menuid like '" + s + "|%'";
        String s2 = "\u6ca1\u6709\u627e\u5230\u524d\u7f00\u4e3a'" + s + "'\u7684\u9644\u52a0\u83dc\u5355!";
        Object[][] aobj = null;
        try {
            String s3 = "select menuid,cmdid,name,icon,method,flags,null as menupos from menudef  where " + s1 + " order by menuid";
            aobj = JDBC.sqlSelect3(s3);
        }
        catch (Exception s3) {
            // empty catch block
        }
        if (aobj == null || aobj.length == 0) {
            Message.showErrorDialog("\u9519\u8bef", s2);
            return null;
        }
        int i = s.length() + 1;
        int j = 0;
        while (j < aobj.length) {
            aobj[j][0] = ((String)aobj[j][0]).substring(i);
            ++j;
        }
        Vector vector = new Vector();
        if (vector.size() == 0) {
            Message.showErrorDialog("\u9519\u8bef", s2);
            return null;
        }
        LabelAsAppMenuItem labelasappmenuitem = new LabelAsAppMenuItem("", null, 1);
        CmdTreeFrame.setDisablePopupSubmenu(labelasappmenuitem);
        alabelasappmenuitem = labelasappmenuitem.getSubMenuItem();
        if (alabelasappmenuitem == null || alabelasappmenuitem.length == 0) {
            Message.showErrorDialog("\u9519\u8bef", s2);
            return null;
        }
        return alabelasappmenuitem;
    }

    public static Image[] getImageByRes(String s) {
        if (s != null) {
            String[] as = Utilities.splitString(s, ',');
            if (as.length != 1 && as.length != 3) {
                return null;
            }
            Image[] aimage = new Image[as.length];
            int i = 0;
            while (i < aimage.length) {
                try {
                    aimage[i] = Utilities.createImageFromResource(as[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aimage[i] == null) {
                    try {
                        aimage[i] = Toolkit.getDefaultToolkit().getImage(as[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return aimage;
        }
        return null;
    }

    public static void showFrame(String s, String s1, String s2, boolean flag, int i) {
        LabelAsAppMenuItem[] alabelasappmenuitem = CmdTreeFrame.getMenusByPrix(s1);
        if (alabelasappmenuitem == null || alabelasappmenuitem.length == 0) {
            return;
        }
        Image[] aimage = CmdTreeFrame.getImageByRes(s2);
        CmdTreeFrame.showFrame(s, alabelasappmenuitem[0], aimage, flag, i);
    }

    public static void setDisablePopupSubmenu(LabelAsAppMenuItem labelasappmenuitem) {
        if (labelasappmenuitem == null) {
            return;
        }
        labelasappmenuitem.disablePopupSubmenu = true;
        LabelAsAppMenuItem[] alabelasappmenuitem = labelasappmenuitem.getSubMenuItem();
        if (alabelasappmenuitem == null) {
            return;
        }
        int i = 0;
        while (i < alabelasappmenuitem.length) {
            CmdTreeFrame.setDisablePopupSubmenu(alabelasappmenuitem[i]);
            ++i;
        }
    }

    public static void listMenuList(Vector vector, String s) {
        if (vector == null) {
            return;
        }
        int i = 0;
        while (i < vector.size()) {
            Object[] aobj = (Object[])vector.elementAt(i);
            System.out.println(String.valueOf(s) + aobj[1] + ":" + aobj[2]);
            CmdTreeFrame.listMenuList((Vector)aobj[0], String.valueOf(s) + "        ");
            ++i;
        }
    }

    public static class CmdTreePanel
    extends JPanel
    implements ActionListener,
    MouseListener {
        LabelAsAppMenuItem rootItem;
        int xOffset = 4;
        int yOffset = 4;
        int yGap = 40;
        int xGap = 12;
        int buttonWidth = 80;
        int buttonHeight = 26;
        boolean bShowRoot;
        ImageIcon[] backImg;
        int algment;
        JMenuItem horItem = new JMenuItem("\u6c34\u5e73\u6392\u5217");
        JMenuItem verItem = new JMenuItem("\u5782\u76f4\u6392\u5217");
        int preINCX;
        int preINCY;
        int wSize = 32;
        int hSize = 32;

        public void mouseClicked(MouseEvent mouseevent) {
        }

        public void mousePressed(MouseEvent mouseevent) {
            if (mouseevent.getSource() == this && (mouseevent.getModifiers() & 0x10) == 0) {
                JPopupMenu jpopupmenu = new JPopupMenu();
                jpopupmenu.add(this.horItem);
                jpopupmenu.add(this.verItem);
                if (1 == (this.algment & 1)) {
                    jpopupmenu.setSelected(this.horItem);
                } else {
                    jpopupmenu.setSelected(this.verItem);
                }
                jpopupmenu.show(this, mouseevent.getX(), mouseevent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseevent) {
        }

        public void mouseEntered(MouseEvent mouseevent) {
        }

        public void mouseExited(MouseEvent mouseevent) {
        }

        public void actionPerformed(ActionEvent actionevent) {
            Object obj = actionevent.getSource();
            if (obj == this.horItem || obj == this.verItem) {
                if (obj == this.verItem && 1 == (this.algment & 1)) {
                    this.setAlgment(this.algment >> 1 << 1, true);
                    this.getParent().doLayout();
                    this.getParent().validate();
                    if (this.getParent().getParent() != null) {
                        this.getParent().getParent().doLayout();
                    }
                }
                if (obj == this.horItem && (this.algment & 1) == 0) {
                    this.setAlgment((this.algment >> 1 << 1) + 1, true);
                    this.getParent().doLayout();
                    this.getParent().validate();
                    if (this.getParent().getParent() != null) {
                        this.getParent().getParent().doLayout();
                    }
                }
            }
        }

        public void setAlgment(int i, boolean flag) {
            this.algment = i;
            if (!this.bShowRoot) {
                if ((this.algment & 1) == 0) {
                    this.xOffset += this.preINCX;
                    this.preINCY = this.buttonHeight + this.yGap;
                    this.yOffset -= this.preINCY;
                } else {
                    this.yOffset += this.preINCY;
                    this.preINCX = this.buttonWidth + this.yGap;
                    this.xOffset -= this.preINCX;
                }
            }
            this.calcAllPos();
            if (flag) {
                this.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }

        public Dimension getSize() {
            return new Dimension(this.wSize + 10, this.hSize + 10);
        }

        void calcAllPos() {
            if (this.rootItem == null || this.rootItem.getSubMenuItem() == null) {
                return;
            }
            Dimension dimension = this.figurePos(this.rootItem, 0, 0);
            this.wSize = dimension.width + this.xOffset;
            this.hSize = dimension.height + this.yOffset;
        }

        Dimension figurePos(LabelAsAppMenuItem labelasappmenuitem, int i, int j) {
            int k = 0;
            int l = 0;
            if (labelasappmenuitem == null) {
                return new Dimension(k, l);
            }
            k = this.buttonWidth;
            l = this.buttonHeight;
            LabelAsAppMenuItem[] alabelasappmenuitem = labelasappmenuitem.getSubMenuItem();
            if (alabelasappmenuitem != null) {
                if ((this.algment & 1) == 0) {
                    k = 0;
                    l += this.yGap;
                    int i1 = 0;
                    int k1 = alabelasappmenuitem.length;
                    k += (k1 - 1) * this.xGap;
                    int i2 = i;
                    int k2 = j + this.yGap + this.buttonHeight;
                    int i3 = 0;
                    while (i3 < k1) {
                        Dimension dimension1 = this.figurePos(alabelasappmenuitem[i3], i2, k2);
                        k += dimension1.width;
                        if (i1 < dimension1.height) {
                            i1 = dimension1.height;
                        }
                        i2 += this.xGap + dimension1.width;
                        ++i3;
                    }
                    l += i1;
                } else {
                    l = 0;
                    k += this.yGap;
                    int j1 = 0;
                    int l1 = alabelasappmenuitem.length;
                    l += (l1 - 1) * this.xGap;
                    int j2 = i + this.yGap + this.buttonWidth;
                    int l2 = j;
                    int j3 = 0;
                    while (j3 < l1) {
                        Dimension dimension2 = this.figurePos(alabelasappmenuitem[j3], j2, l2);
                        l += dimension2.height;
                        if (j1 < dimension2.width) {
                            j1 = dimension2.width;
                        }
                        l2 += this.xGap + dimension2.height;
                        ++j3;
                    }
                    k += j1;
                }
            }
            if ((this.algment & 1) == 0) {
                labelasappmenuitem.xPos = this.xOffset + i + k / 2;
                labelasappmenuitem.yPos = this.yOffset + j;
            } else {
                labelasappmenuitem.xPos = i + this.xOffset;
                labelasappmenuitem.yPos = this.yOffset + j + l / 2;
            }
            if (this.bShowRoot || !labelasappmenuitem.equals(this.rootItem)) {
                Dimension dimension = LabelAsAppMenuItem.bNormalMode ? new Dimension(90, 86) : labelasappmenuitem.getSize();
                if ((this.algment & 1) == 0) {
                    labelasappmenuitem.setBounds(labelasappmenuitem.xPos - dimension.width / 2, labelasappmenuitem.yPos, dimension.width, dimension.height);
                } else {
                    labelasappmenuitem.setBounds(labelasappmenuitem.xPos, labelasappmenuitem.yPos - dimension.height / 2, dimension.width, dimension.height);
                }
                this.add((Component)labelasappmenuitem, null);
            }
            return new Dimension(k, l);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.backImg != null) {
                Dimension dimension = this.getSize();
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    int k;
                    int j = container.getHeight();
                    if (j > dimension.height) {
                        dimension.height = j;
                    }
                    if ((k = container.getWidth()) > dimension.width) {
                        dimension.width = k;
                    }
                }
                if (this.backImg != null) {
                    if (this.backImg.length == 1) {
                        AwtUtil.paintImage(g, this.backImg[0], 0, 0, dimension.width, dimension.height, this.algment >> 1);
                    } else {
                        AwtUtil.paintImage(g, this.backImg[0], 0, 0, dimension.width, dimension.height, 2);
                        if (this.backImg[1] != null) {
                            g.drawImage(this.backImg[1].getImage(), 0, dimension.height - this.backImg[1].getIconHeight(), this);
                        }
                        if (this.backImg[2] != null) {
                            g.drawImage(this.backImg[2].getImage(), dimension.width - this.backImg[1].getIconWidth(), dimension.height - this.backImg[1].getIconHeight(), this);
                        }
                    }
                }
            }
            if (this.rootItem != null) {
                if (this.bShowRoot) {
                    this.drawLines(g, this.rootItem);
                } else {
                    LabelAsAppMenuItem[] alabelasappmenuitem = this.rootItem.getSubMenuItem();
                    int i = 0;
                    while (i < alabelasappmenuitem.length) {
                        this.drawLines(g, alabelasappmenuitem[i]);
                        ++i;
                    }
                }
            }
        }

        void drawLines(Graphics g, LabelAsAppMenuItem labelasappmenuitem) {
            LabelAsAppMenuItem[] alabelasappmenuitem = labelasappmenuitem.getSubMenuItem();
            if (alabelasappmenuitem == null) {
                return;
            }
            int i = alabelasappmenuitem.length;
            g.setColor(Color.red);
            if (i == 1) {
                if ((this.algment & 1) == 0) {
                    g.drawLine(labelasappmenuitem.xPos, labelasappmenuitem.yPos + this.buttonHeight, labelasappmenuitem.xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap);
                } else {
                    g.drawLine(labelasappmenuitem.xPos + this.buttonWidth, labelasappmenuitem.yPos, labelasappmenuitem.xPos + this.buttonWidth + this.yGap, labelasappmenuitem.yPos);
                }
                this.drawLines(g, alabelasappmenuitem[0]);
            } else {
                if ((this.algment & 1) == 0) {
                    g.drawLine(labelasappmenuitem.xPos, labelasappmenuitem.yPos + this.buttonHeight, labelasappmenuitem.xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap / 2);
                    g.drawLine(alabelasappmenuitem[0].xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap / 2, alabelasappmenuitem[i - 1].xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap / 2);
                    int j = 0;
                    while (j < i) {
                        g.drawLine(alabelasappmenuitem[j].xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap / 2, alabelasappmenuitem[j].xPos, labelasappmenuitem.yPos + this.buttonHeight + this.yGap);
                        ++j;
                    }
                } else {
                    g.drawLine(labelasappmenuitem.xPos + this.buttonWidth, labelasappmenuitem.yPos, labelasappmenuitem.xPos + this.buttonWidth + this.yGap / 2, labelasappmenuitem.yPos);
                    g.drawLine(labelasappmenuitem.xPos + this.buttonWidth + this.yGap / 2, alabelasappmenuitem[0].yPos, labelasappmenuitem.xPos + this.buttonWidth + this.yGap / 2, alabelasappmenuitem[i - 1].yPos);
                    int k = 0;
                    while (k < i) {
                        g.drawLine(labelasappmenuitem.xPos + this.buttonWidth + this.yGap / 2, alabelasappmenuitem[k].yPos, labelasappmenuitem.xPos + this.buttonWidth + this.yGap, alabelasappmenuitem[k].yPos);
                        ++k;
                    }
                }
                int l = 0;
                while (l < i) {
                    this.drawLines(g, alabelasappmenuitem[l]);
                    ++l;
                }
            }
        }

        public CmdTreePanel(LabelAsAppMenuItem labelasappmenuitem) {
            this(labelasappmenuitem, null, false, 0);
        }

        public CmdTreePanel(LabelAsAppMenuItem labelasappmenuitem, Image[] aimage, boolean flag, int i) {
            this.horItem.addActionListener(this);
            this.verItem.addActionListener(this);
            this.bShowRoot = flag;
            if (aimage == null) {
                this.backImg = null;
            } else {
                this.backImg = new ImageIcon[aimage.length];
                int j = 0;
                while (j < aimage.length) {
                    this.backImg[j] = aimage[j] != null ? new ImageIcon(aimage[j]) : null;
                    ++j;
                }
            }
            this.algment = i;
            this.setLayout(null);
            this.rootItem = labelasappmenuitem;
            if (LabelAsAppMenuItem.bNormalMode) {
                this.buttonHeight = 88;
            } else if (this.rootItem != null) {
                this.buttonHeight = this.rootItem.getSize().height;
            }
            this.setAlgment(i, false);
            this.addMouseListener(this);
        }
    }
}

