/*
 * Decompiled with CFR 0.152.
 */
package softface;

import com.borland.dx.dataset.DataSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import softcore.table.DataSetAccess;
import softcore.util.Calculator;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainFrame;

public class AppToolBar
extends JToolBar
implements ActionListener {
    JButton saveButton;
    JButton findButton;
    JButton printButton;
    JButton firstButton;
    JButton priorButton;
    JButton nextButton;
    JButton lastButton;
    JButton lastaddButton;
    JButton insertButton;
    JButton deleteButton;
    JButton postButton;
    JButton cancelButton;
    JButton refreshButton;
    JButton dittoButton;
    JButton copyButton;
    JButton pasteButton;
    JButton cutButton;
    JButton calcButton;
    JButton[] allDatasetButton = new JButton[18];
    int nDatasetButton = 0;
    boolean bHideCmdButWhenDisabled;
    String[] extDatasetCmds;
    String fixedDatasetCmds;
    private static final Dimension Dimension_24X24 = new Dimension(24, 24);
    private static final Dimension ToobarButtonGroupGapDimension = new Dimension(6, 6);
    private DataSetAccess dataSetAccess;

    private void addDatasetButton(JButton jbutton) {
        if (jbutton != null) {
            this.allDatasetButton[this.nDatasetButton++] = jbutton;
            jbutton.addActionListener(this);
        }
    }

    public AppToolBar() {
        this(true, true);
    }

    public AppToolBar(boolean flag, boolean flag1) {
        this.bHideCmdButWhenDisabled = flag1;
        if (flag) {
            this.addToolBarIConButtons(0, Utilities.splitString(MainFrame.getAppProperty("ToolbarIconResource"), ','), Utilities.splitString(MainFrame.getAppProperty("ToolbarActionCommand"), ','), Utilities.splitString(MainFrame.getAppProperty("ToolbarTipText"), ','), null);
            this.addDatasetButtons();
        }
    }

    public void addOnlyDatasetBut(int i, boolean flag) {
        if (flag) {
            JButton[] ajbutton = this.addToolBarIConButtons(0, new String[]{"res/icon16_calculator.jpg"}, new String[]{"softcore.util.Calculator.showCalculatorDialog"}, new String[]{"\u8ba1\u7b97\u5668"}, null);
            this.calcButton = ajbutton[0];
            this.calcButton.addActionListener(this);
            this.calcButton.setActionCommand("calculator");
        }
        if (i < 0) {
            i = 4;
        }
        this.addToolBarIConButtons(i, Utilities.splitString(MainFrame.getAppProperty("ToolbarIconResource"), ','), Utilities.splitString(MainFrame.getAppProperty("ToolbarActionCommand"), ','), Utilities.splitString(MainFrame.getAppProperty("ToolbarTipText"), ','), null);
        this.addDatasetButtons();
    }

    public void addDatasetButtons() {
        this.saveButton = this.findButtonByActionCommand("save");
        this.addDatasetButton(this.saveButton);
        this.findButton = this.findButtonByActionCommand("find");
        this.addDatasetButton(this.findButton);
        this.firstButton = this.findButtonByActionCommand("first");
        this.addDatasetButton(this.firstButton);
        this.priorButton = this.findButtonByActionCommand("prev");
        this.addDatasetButton(this.priorButton);
        this.nextButton = this.findButtonByActionCommand("next");
        this.addDatasetButton(this.nextButton);
        this.lastButton = this.findButtonByActionCommand("last");
        this.addDatasetButton(this.lastButton);
        this.lastaddButton = this.findButtonByActionCommand("lastadd");
        this.addDatasetButton(this.lastaddButton);
        this.insertButton = this.findButtonByActionCommand("insert");
        this.addDatasetButton(this.insertButton);
        this.deleteButton = this.findButtonByActionCommand("delete");
        this.addDatasetButton(this.deleteButton);
        this.dittoButton = this.findButtonByActionCommand("ditto");
        this.addDatasetButton(this.dittoButton);
        this.postButton = this.findButtonByActionCommand("post");
        this.addDatasetButton(this.postButton);
        this.refreshButton = this.findButtonByActionCommand("refresh");
        this.addDatasetButton(this.refreshButton);
        this.cancelButton = this.findButtonByActionCommand("cancel");
        this.addDatasetButton(this.cancelButton);
        this.printButton = this.findButtonByActionCommand("print");
        this.addDatasetButton(this.printButton);
        this.copyButton = this.findButtonByActionCommand("copy");
        this.addDatasetButton(this.copyButton);
        this.cutButton = this.findButtonByActionCommand("cut");
        this.addDatasetButton(this.cutButton);
        this.pasteButton = this.findButtonByActionCommand("paste");
        this.addDatasetButton(this.pasteButton);
        this.updateToolbarButtonVisible();
    }

    public JButton findButtonByActionCommand(String s) {
        Component[] acomponent = this.getComponents();
        int i = 0;
        while (i < acomponent.length) {
            Component component = acomponent[i];
            if (component != null && component instanceof JButton && ((JButton)component).getActionCommand().equals(s)) {
                return (JButton)component;
            }
            ++i;
        }
        return null;
    }

    public static final JButton findToolbarButtonByActionCommand(String s) {
        return MainFrame.toolBar == null ? null : MainFrame.toolBar.findButtonByActionCommand(s);
    }

    public void updateToolbarButtonVisible() {
        AppToolBar.updateToolbarButtonVisible(this);
    }

    public void setExtraDatasetCmds(String[] as) {
        this.extDatasetCmds = as;
    }

    boolean isCommandValidate(String s) {
        if (s == null) {
            return false;
        }
        if (this.fixedDatasetCmds == null) {
            this.fixedDatasetCmds = ",h9soft.app.MainApp.open,h9soft.app.MainApp.about,=h9soft.app.MainApp.contextHelp,h9soft.util.Calculator.showCalculatorDialog,save,find,print,copy,cut,paste,first,prev,next,last,lastadd,insert,delete,post,refresh,";
        }
        if (this.fixedDatasetCmds.indexOf("," + s + ",") >= 0) {
            return true;
        }
        if (this.extDatasetCmds != null) {
            int i = 0;
            while (i < this.extDatasetCmds.length) {
                if (s.equals(this.extDatasetCmds[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void updateToolbarButtonVisible(Container container) {
        if (container == null) {
            return;
        }
        Component[] acomponent = container.getComponents();
        int i = 0;
        while (i < acomponent.length) {
            Component component = acomponent[i];
            if (component != null && component instanceof JIconButton) {
                ((JIconButton)component).setVisible();
            }
            ++i;
        }
    }

    public void removeButtonActionListener(ActionListener actionlistener) {
        Component[] acomponent = this.getComponents();
        int i = 0;
        while (i < acomponent.length) {
            Component component = acomponent[i];
            if (component != null && component instanceof AbstractButton) {
                ((AbstractButton)component).removeActionListener(actionlistener);
            }
            ++i;
        }
    }

    public JButton addToolBarIConButton(String s, String s1, String s2, ActionListener actionlistener) {
        if (s.equals("_")) {
            this.add(Box.createRigidArea(ToobarButtonGroupGapDimension));
            return null;
        }
        JIconButton jiconbutton = new JIconButton(s);
        if (s2 != null) {
            jiconbutton.setToolTipText(s2);
        }
        if (s1 != null) {
            jiconbutton.setActionCommand(s1);
            if (actionlistener == null && s1.indexOf(46) > 0) {
                jiconbutton.addActionListener(MainFrame.menuAdapter);
            }
        }
        if (actionlistener != null) {
            jiconbutton.addActionListener(actionlistener);
        }
        return this.addToolBarIConButton(jiconbutton);
    }

    public JButton addToolBarIConButton(JButton jbutton) {
        if (jbutton != null) {
            this.add(jbutton);
        }
        return jbutton;
    }

    public JButton[] addToolBarIConButtons(JButton[] ajbutton) {
        int i = 0;
        while (i < ajbutton.length) {
            this.addToolBarIConButton(ajbutton[i]);
            ++i;
        }
        return ajbutton;
    }

    public JButton[] addToolBarIConButtons(int i, String[] as, String[] as1, String[] as2, ActionListener actionlistener) {
        int j = as.length;
        JButton[] ajbutton = new JButton[j - i];
        int k = i;
        while (k < j) {
            ajbutton[k - i] = this.addToolBarIConButton(as[k], as1 != null && as1.length > k ? as1[k] : null, as2 != null && as2.length > k ? as2[k] : null, actionlistener);
            ++k;
        }
        ajbutton[0].addActionListener(this);
        ajbutton[0].setActionCommand("calculator");
        return ajbutton;
    }

    public void removeToolBarComponents(Component[] acomponent) {
        int i = 0;
        while (i < acomponent.length) {
            if (acomponent[i] != null) {
                this.remove(acomponent[i]);
            }
            ++i;
        }
    }

    public void updateDatasetButtonEnabledState() {
        this.updateToolbarButtonVisible();
        try {
            if (this.dataSetAccess != null) {
                this.firstButton.setEnabled(this.dataSetAccess.isNavFirstable());
                this.priorButton.setEnabled(this.dataSetAccess.isNavPriorable());
                this.nextButton.setEnabled(this.dataSetAccess.isNavNextable());
                this.lastButton.setEnabled(this.dataSetAccess.isNavLastable());
                this.insertButton.setEnabled(this.dataSetAccess.isInsertable());
                this.lastaddButton.setEnabled(this.dataSetAccess.isLastaddable());
                this.deleteButton.setEnabled(this.dataSetAccess.isDeleteable());
                this.saveButton.setEnabled(this.dataSetAccess.isSaveable());
                this.refreshButton.setEnabled(this.dataSetAccess.refreshSupported());
                this.printButton.setEnabled(this.dataSetAccess.isPrintable());
                this.copyButton.setEnabled(true);
                this.cutButton.setEnabled(true);
                this.pasteButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DataSet getFocusedDataSet() {
        return this.dataSetAccess != null ? this.dataSetAccess.getDataSet() : null;
    }

    public void setDataSetAccess(DataSetAccess datasetaccess) {
        Component[] acomponent = this.getComponents();
        if (this.dataSetAccess != null) {
            this.removeButtonActionListener(this.dataSetAccess);
            this.dataSetAccess.updateButtonEnable(acomponent, true);
        }
        this.dataSetAccess = datasetaccess;
        if (datasetaccess != null) {
            int i = 0;
            while (i < acomponent.length) {
                Component component = acomponent[i];
                if (component != null && component instanceof AbstractButton && datasetaccess.acceptActionCommand(((AbstractButton)component).getActionCommand())) {
                    ((AbstractButton)component).addActionListener(datasetaccess);
                }
                ++i;
            }
            this.dataSetAccess.updateButtonEnable(acomponent, false);
        } else {
            int j = 0;
            while (j < acomponent.length) {
                Component component1 = acomponent[j];
                if (component1 != null && component1 instanceof AbstractButton) {
                    ((AbstractButton)component1).setEnabled(true);
                }
                ++j;
            }
        }
        this.updateDatasetButtonEnabledState();
    }

    public DataSetAccess getDataSetAccess() {
        return this.dataSetAccess;
    }

    public static void setToolbarDataSetAccess(DataSetAccess datasetaccess) {
        if (MainFrame.toolBar != null) {
            MainFrame.toolBar.setDataSetAccess(datasetaccess);
        }
    }

    public static DataSetAccess getToolbarDataSetAccess() {
        return MainFrame.toolBar == null ? null : MainFrame.toolBar.getDataSetAccess();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getActionCommand().equals("calculator")) {
            Calculator.showCalculatorDialog();
        }
        if (actionevent.getSource() instanceof JButton && this.dataSetAccess != null) {
            try {
                JButton jbutton = (JButton)actionevent.getSource();
                if (jbutton == this.firstButton) {
                    this.dataSetAccess.goFirst();
                } else if (jbutton == this.nextButton) {
                    this.dataSetAccess.goNext();
                } else if (jbutton == this.priorButton) {
                    this.dataSetAccess.goPrior();
                } else if (jbutton == this.lastButton) {
                    this.dataSetAccess.goLast();
                } else if (jbutton == this.insertButton) {
                    this.dataSetAccess.insertRow();
                } else if (jbutton == this.lastaddButton) {
                    this.dataSetAccess.lastaddRow();
                } else if (jbutton == this.deleteButton) {
                    this.dataSetAccess.deleteRow();
                } else if (jbutton == this.postButton) {
                    this.dataSetAccess.postRowUpdate();
                } else if (jbutton == this.dittoButton) {
                    this.dataSetAccess.deleteRow();
                } else if (jbutton == this.cancelButton) {
                    this.dataSetAccess.cancelRowUpdate();
                } else if (jbutton == this.saveButton) {
                    this.dataSetAccess.save();
                } else if (jbutton == this.refreshButton) {
                    this.dataSetAccess.refresh();
                } else if (jbutton == this.printButton) {
                    this.dataSetAccess.print();
                } else if (jbutton == this.findButton) {
                    this.dataSetAccess.find();
                } else if (jbutton == this.pasteButton) {
                    this.dataSetAccess.pasteAction();
                } else if (jbutton == this.cutButton) {
                    this.dataSetAccess.cutAction();
                } else if (jbutton == this.copyButton) {
                    this.dataSetAccess.copyAction();
                }
            }
            catch (Exception exception) {
                Message.printException(exception, true);
            }
        }
    }

    public static void requestUpdateDatasetButton() {
        if (MainFrame.toolBar != null) {
            MainFrame.toolBar.updateDatasetButtonEnabledState();
        }
    }

    public class DownBorder
    extends AbstractBorder {
        int thickness = 1;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.gray);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(Color.white);
            g.drawLine(width - 1, 0, width - 1, height);
            g.drawLine(0, height - 1, width, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }

    public final class JIconButton
    extends JButton
    implements MouseListener {
        private Border borderOut = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border borderIn;
        private Border borderPressed;

        public void setVisible() {
            boolean flag = false;
            Object[] aobj = this.listenerList.getListenerList();
            int i = 0;
            while (i < aobj.length) {
                if (aobj[i + 1] != null && aobj[i + 1] instanceof ActionListener && (aobj[i + 1] != AppToolBar.this || AppToolBar.this.dataSetAccess != null)) {
                    flag = true;
                    break;
                }
                i += 2;
            }
            if (AppToolBar.this.bHideCmdButWhenDisabled) {
                this.setVisible(flag);
            } else {
                boolean flag1 = AppToolBar.this.isCommandValidate(this.getActionCommand());
                if (!flag1) {
                    this.setVisible(flag);
                } else {
                    if (flag && !this.isVisible()) {
                        this.setVisible(true);
                    }
                    this.setEnabled(flag);
                }
            }
        }

        public String getToolTipText() {
            String s;
            if (AppToolBar.this.dataSetAccess != null && (s = AppToolBar.this.dataSetAccess.getToolBarTipText(this.getActionCommand())) != null) {
                return s;
            }
            return super.getToolTipText();
        }

        public JIconButton(String s) {
            this.borderIn = new UpBorder();
            this.borderPressed = new DownBorder();
            try {
                this.setIcon(Utilities.createImageIconFromResource(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addMouseListener(this);
            this.setBorder(null);
            this.setMinimumSize(Dimension_24X24);
            this.setPreferredSize(Dimension_24X24);
            this.setMaximumSize(Dimension_24X24);
            this.setRequestFocusEnabled(false);
        }

        public void mouseEntered(MouseEvent e) {
            if (this.isEnabled()) {
                this.setBorder(this.borderIn);
            }
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.borderOut);
        }

        public void mousePressed(MouseEvent e) {
            if (this.isEnabled()) {
                this.setBorder(this.borderPressed);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.getBounds().contains(e.getX(), e.getY()) && this.isEnabled()) {
                this.setBorder(this.borderIn);
            } else {
                this.setBorder(this.borderOut);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    public class UpBorder
    extends AbstractBorder {
        int thickness = 1;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(Color.gray);
            g.drawLine(width - 1, 0, width - 1, height);
            g.drawLine(0, height - 1, width, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }
}

