/*
 * Decompiled with CFR 0.152.
 */
package softface.imagebutton;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import softface.imagebutton.DisableFilter;
import softface.imagebutton.Tooltips;

public class ImageButton
extends AbstractButton
implements Runnable,
Accessible {
    int x;
    int y;
    int width;
    int height;
    int imageX;
    int imageY;
    int fontX;
    int fontY;
    private Image NormalImage;
    private Image EnterImage;
    private Image PressImage;
    private Image DisableImage;
    private String textx;
    private Font font = new Font("Dialog", 0, 12);
    private Color basicColor = Color.lightGray;
    private Thread draw;
    private boolean imageLoaded;
    private int h_bosomSpace = 1;
    private int v_bosomSpace = 1;
    private int h_sideSpace = 3;
    private int v_sideSpace = 3;
    private int Status = 5;
    private static final int Normal = 1;
    private static final int Enter = 2;
    private static final int Press = 3;
    private static final int Disable = 4;
    private static final int Hide = 5;
    private int Alignment;
    public static final int HORIZON = 1;
    public static final int VERTICAL = 2;
    private Tooltips tooltips;
    private String explain;

    public ImageButton(byte[] NormalIcon, String text) {
        this(NormalIcon, NormalIcon, NormalIcon, NormalIcon, text, 1);
    }

    public ImageButton(byte[] NormalIcon, byte[] EnterIcon, byte[] PressIcon, byte[] DisableIcon, String text, int Alignment) {
        this.setModel(new DefaultButtonModel());
        this.setBorderPainted(false);
        if (Alignment != 1 && Alignment != 2) {
            throw new NumberFormatException("Alignment format error,at the ImageButton construction");
        }
        this.textx = text;
        this.Alignment = Alignment;
        if (NormalIcon.length != 0) {
            this.NormalImage = this.getToolkit().createImage(NormalIcon, 0, NormalIcon.length);
        }
        if (!new String(EnterIcon).equals(new String(NormalIcon))) {
            this.EnterImage = this.getToolkit().createImage(EnterIcon, 0, EnterIcon.length);
        }
        if (!new String(PressIcon).equals(new String(NormalIcon))) {
            this.PressImage = this.getToolkit().createImage(PressIcon, 0, PressIcon.length);
        }
        if (!new String(DisableIcon).equals(new String(NormalIcon))) {
            this.DisableImage = this.getToolkit().createImage(DisableIcon, 0, DisableIcon.length);
        }
        this.LoadImage();
        this.definePoint();
    }

    public ImageButton(Image NormalImage, int Alignment) {
        this(NormalImage, null, null, null, null, Alignment);
    }

    public ImageButton(Image NormalImage, Image EnterImage, Image PressImage, Image DisableImage, String text, int Alignment) {
        this.setModel(new DefaultButtonModel());
        this.setBorderPainted(false);
        if (Alignment != 1 && Alignment != 2) {
            throw new NumberFormatException("Alignment format error,at the  ImageButton construction");
        }
        this.textx = text;
        this.Alignment = Alignment;
        this.NormalImage = NormalImage;
        this.EnterImage = EnterImage;
        this.PressImage = PressImage;
        this.DisableImage = DisableImage;
        this.LoadImage();
        this.definePoint();
    }

    private void LoadImage() {
        MediaTracker tracker = new MediaTracker(this);
        if (this.DisableImage == null) {
            DisableFilter filter = new DisableFilter();
            this.DisableImage = this.createImage(new FilteredImageSource(this.NormalImage.getSource(), filter));
        }
        if (this.EnterImage == null) {
            this.EnterImage = this.NormalImage;
        }
        if (this.PressImage == null) {
            this.PressImage = this.EnterImage;
        }
        tracker.addImage(this.NormalImage, 0);
        tracker.addImage(this.EnterImage, 1);
        tracker.addImage(this.PressImage, 2);
        tracker.addImage(this.DisableImage, 3);
        try {
            tracker.waitForAll();
            if (tracker.isErrorAny()) {
                throw new InterruptedException("image Load error,at the LoadImage method");
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    private void definePoint() {
        int fontWidth = 0;
        int fontHeight = 0;
        FontMetrics fm = this.getFontMetrics(this.font);
        if (this.textx != null) {
            fontWidth = fm.stringWidth(this.textx);
            fontHeight = fm.getHeight();
        }
        if (this.NormalImage == null) {
            return;
        }
        int imageWidth = this.NormalImage.getWidth(this);
        int imageHeight = this.NormalImage.getHeight(this);
        switch (this.Alignment) {
            case 1: {
                if (this.h_sideSpace * 2 + imageWidth + this.h_bosomSpace + fontWidth > this.width) {
                    this.width = this.h_sideSpace * 2 + imageWidth + this.h_bosomSpace + fontWidth;
                }
                if (imageHeight + this.v_sideSpace * 2 > this.height) {
                    this.height = imageHeight + this.v_sideSpace * 2;
                }
                if (fontHeight + this.v_sideSpace * 2 > this.height) {
                    this.height = fontHeight + this.v_sideSpace * 2;
                }
                if (this.textx == null) {
                    this.imageX = (this.width - imageWidth) / 2;
                    this.imageY = (this.height - imageHeight) / 2;
                    this.fontY = 0;
                    this.fontX = 0;
                    break;
                }
                this.imageX = (this.width - imageWidth - this.h_bosomSpace - fontWidth) / 2;
                this.imageY = (this.height - imageHeight) / 2;
                this.fontX = this.imageX + imageWidth + this.h_bosomSpace;
                this.fontY = (this.height - fontHeight) / 2 + fm.getAscent();
                break;
            }
            case 2: {
                if (imageWidth + this.h_sideSpace * 2 > this.width) {
                    this.width = imageWidth + this.h_sideSpace * 2;
                }
                if (fontWidth + this.h_sideSpace * 2 > this.width) {
                    this.width = fontWidth + this.h_sideSpace * 2;
                }
                if (this.v_sideSpace * 2 + imageHeight + this.v_bosomSpace + fontHeight > this.height) {
                    this.height = this.v_sideSpace * 2 + imageHeight + this.v_bosomSpace + fontHeight;
                }
                if (this.textx == null) {
                    this.imageX = (this.width - imageWidth) / 2;
                    this.imageY = (this.height - imageHeight) / 2;
                    this.fontY = 0;
                    this.fontX = 0;
                    break;
                }
                this.imageX = (this.width - imageWidth) / 2;
                this.imageY = (this.height - imageHeight - this.v_bosomSpace - fontHeight) / 2;
                this.fontX = (this.width - fontWidth) / 2;
                this.fontY = this.imageY + imageHeight + this.v_bosomSpace + fm.getAscent();
            }
        }
    }

    public void start() {
        if (this.draw == null) {
            this.imageLoaded = false;
            this.draw = new Thread((Runnable)this, "paint image button");
            this.draw.start();
        }
    }

    public void stop() {
        if (this.draw != null) {
            this.draw.stop();
            this.draw = null;
        }
    }

    public void run() {
        this.draw.setPriority(1);
        while (!this.imageLoaded) {
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                break;
            }
        }
        this.stop();
    }

    public void setTooltipsText(String explain) {
        this.explain = explain;
    }

    public void setTooltips(Tooltips tooltips, String explain) {
        this.tooltips = tooltips;
        this.explain = explain;
    }

    public int getAlignment() {
        return this.Alignment;
    }

    public void setAlignment(int ID) {
        if (ID != 1 && ID != 2) {
            throw new NumberFormatException("Alignment format error, at setAlignment method");
        }
        this.Alignment = ID;
        this.setTransform();
    }

    public String getText() {
        return this.textx;
    }

    public void setText(String text) {
        this.textx = text;
        this.setTransform();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.setTransform();
    }

    public void setBosomspace(int h_bosomSpace, int v_bosomSpace) {
        if (h_bosomSpace <= 0 || v_bosomSpace <= 0) {
            throw new NumberFormatException("set value error,at setBosomspace method");
        }
        this.h_bosomSpace = h_bosomSpace;
        this.v_bosomSpace = v_bosomSpace;
        this.setTransform();
    }

    public void setSidespace(int h_sideSpace, int v_sideSpace) {
        if (h_sideSpace <= 0 || v_sideSpace <= 0) {
            throw new NumberFormatException("set value error,at setSidespace method");
        }
        this.h_sideSpace = h_sideSpace;
        this.v_sideSpace = v_sideSpace;
        this.setTransform();
    }

    private void setTransform() {
        this.definePoint();
        if (this.Status != 5) {
            super.setBounds(this.x, this.y, this.width, this.height);
            this.repaint();
        }
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.definePoint();
        if (this.Status != 5) {
            super.setBounds(this.x, this.y, this.width, this.height);
            this.start();
        }
    }

    public boolean isVisible() {
        return this.Status != 5;
    }

    public boolean isEnabled() {
        return this.Status != 4;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.Status = 1;
            super.setVisible(true);
            super.setBounds(this.x, this.y, this.width, this.height);
            this.start();
        } else {
            this.Status = 5;
            super.setVisible(false);
        }
    }

    public void setEnabled(boolean b) {
        this.setStatus(b ? 1 : 4);
    }

    public void setDisable() {
        this.setEnabled(false);
    }

    public synchronized boolean setClicked() {
        if (this.Status == 4) {
            return false;
        }
        this.setStatus(2);
        return true;
    }

    public synchronized boolean setEntered(Point mouse, Rectangle frame) {
        if (this.tooltips != null && this.explain != null) {
            int toolX = mouse.x - this.x - frame.x * 2;
            int toolY = mouse.y - this.y - frame.y * 2;
            this.tooltips.setVisible(this.explain, new Point(toolX, toolY), frame);
        }
        if (this.Status == 4) {
            return false;
        }
        this.setStatus(2);
        return true;
    }

    public synchronized boolean setExited() {
        if (this.tooltips != null && this.explain != null && this.tooltips.isVisible()) {
            this.tooltips.setCleared();
        }
        if (this.Status == 4) {
            return false;
        }
        this.setStatus(1);
        return true;
    }

    public synchronized boolean setPressed() {
        if (this.tooltips != null && this.explain != null && this.tooltips.isVisible()) {
            this.tooltips.setCleared();
        }
        if (this.Status == 4) {
            return false;
        }
        this.setStatus(3);
        return true;
    }

    public synchronized boolean setReleased(Point mouse) {
        if (this.Status == 4) {
            return false;
        }
        if (mouse.x >= 0 && mouse.x <= this.width - 1 && mouse.y >= 0 && mouse.y <= this.height - 1) {
            this.setStatus(2);
        } else {
            this.setStatus(1);
        }
        return true;
    }

    private void setStatus(int ID) {
        if (ID < 1 || ID > 5) {
            throw new NumberFormatException("Status format error,at the setStatus method");
        }
        if (this.Status == 5) {
            return;
        }
        this.Status = ID;
        this.repaint();
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void update(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.getForeground());
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        switch (this.Status) {
            case 1: {
                this.imageLoaded = g.drawImage(this.NormalImage, this.imageX, this.imageY, null, this);
                if (this.textx == null) break;
                g.setColor(Color.black);
                g.setFont(this.font);
                g.drawString(this.textx, this.fontX, this.fontY);
                break;
            }
            case 2: {
                g.setColor(Color.white);
                g.drawRect(0, 0, this.width, this.height);
                g.setColor(Color.gray);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawImage(this.EnterImage, this.imageX, this.imageY, null, this);
                if (this.textx == null) break;
                g.setColor(Color.blue);
                g.setFont(this.font);
                g.drawString(this.textx, this.fontX, this.fontY);
                break;
            }
            case 3: {
                g.setColor(Color.gray);
                g.drawRect(0, 0, this.width, this.height);
                g.setColor(Color.white);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawImage(this.PressImage, this.imageX + 1, this.imageY + 1, null, this);
                if (this.textx == null) break;
                g.setColor(Color.red);
                g.setFont(this.font);
                g.drawString(this.textx, this.fontX + 1, this.fontY + 1);
                break;
            }
            case 4: {
                g.drawImage(this.DisableImage, this.imageX, this.imageY, null, this);
                if (this.textx == null) break;
                g.setColor(Color.gray);
                g.setFont(this.font);
                g.drawString(this.textx, this.fontX, this.fontY);
            }
        }
    }
}

