/*
 * Decompiled with CFR 0.152.
 */
package softface.imagebutton;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;

public class Tooltips
extends Canvas
implements Runnable {
    private Font font;
    private int x;
    private int y;
    private int width;
    private int height;
    private int fontX;
    private int fontY;
    private int h_sideSpace = 3;
    private int v_sideSpace = 3;
    private int keep = 3;
    private int delay = 10;
    private Thread draw;
    private String text;
    private int Status = 4;
    private static final int Draw = 1;
    private static final int stopDraw = 2;
    private static final int Clear = 3;
    private static final int Hide = 4;
    private static final int Suspend = 5;

    public Tooltips() {
        this(new Font("Dialog", 0, 12));
    }

    public Tooltips(Font font) {
        this.font = font;
    }

    public synchronized void setVisible(String text, Point mouse, Rectangle frame) {
        if (text == null) {
            return;
        }
        this.text = text;
        FontMetrics fm = this.getFontMetrics(this.font);
        int fontWidth = fm.stringWidth(this.text);
        int fontHeight = fm.getHeight();
        this.width = fontWidth + this.h_sideSpace * 2;
        this.height = fontHeight + this.v_sideSpace * 2;
        this.fontX = (this.width - fontWidth) / 2;
        this.fontY = (this.height - fontHeight) / 2 + fm.getAscent();
        if (mouse.y - this.height - 20 < 0 && mouse.y + this.height + 20 >= frame.height) {
            return;
        }
        this.x = mouse.x + this.width >= frame.width ? (frame.width - this.width - 5 > 0 ? frame.width - this.width - 5 : 0) : mouse.x;
        int n = this.y = mouse.y + 20 + this.height <= frame.height ? mouse.y + 20 : mouse.y - 20 - this.height;
        if (this.draw == null) {
            this.start();
        } else if (this.Status == 5) {
            this.draw.resume();
        }
        this.Status = 1;
    }

    public synchronized boolean isVisible() {
        return this.Status == 1 || this.Status == 2;
    }

    public synchronized void setCleared() {
        if (this.Status != 1 && this.Status != 2) {
            return;
        }
        this.Status = 3;
    }

    public void setDelay(int delay) {
        if (delay < 3) {
            throw new NumberFormatException("delay value error,at the setDelay method");
        }
        this.delay = delay;
    }

    public void setKeep(int keep) {
        if (keep < 1) {
            throw new NumberFormatException("keep value error,at the setKeep method");
        }
        this.keep = keep;
    }

    public void start() {
        if (this.draw == null) {
            this.draw = new Thread((Runnable)this, "draw text");
            this.draw.start();
        }
    }

    public void stop() {
        if (this.draw != null) {
            this.draw.stop();
            this.draw = null;
        }
    }

    public void run() {
        this.draw.setPriority(5);
        long beginTime = new Date().getTime();
        while (true) {
            switch (this.Status) {
                case 1: {
                    super.setBounds(this.x, this.y, this.width, this.height);
                    this.repaint();
                    beginTime = new Date().getTime();
                    break;
                }
                case 3: {
                    super.setBounds(this.x, this.y, 0, 0);
                    this.Status = 4;
                    beginTime = new Date().getTime();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                this.stop();
                break;
            }
            if (this.Status == 2 && (new Date().getTime() - beginTime) / 1000L >= (long)this.keep) {
                this.Status = 3;
                continue;
            }
            if (this.Status != 4 || (new Date().getTime() - beginTime) / 1000L < (long)this.delay) continue;
            this.Status = 5;
            this.draw.suspend();
        }
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void update(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.Status == 1 || this.Status == 2) {
            Tooltips tooltips = this;
            synchronized (tooltips) {
                g.setColor(Color.yellow);
                g.fillRect(0, 0, this.width, this.height);
                g.setColor(Color.black);
                g.drawRect(0, 0, this.width - 1, this.height - 1);
                g.setColor(Color.red);
                g.setFont(this.font);
                g.drawString(this.text, this.fontX, this.fontY);
                this.Status = 2;
            }
        }
    }
}

