/*
 * Decompiled with CFR 0.152.
 */
package softface.theme;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import softface.theme.Log;

public class PropertiesMetalTheme
extends DefaultMetalTheme {
    private String name = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;

    public PropertiesMetalTheme(InputStream inputstream) {
        this.initColors();
        this.loadProperties(inputstream);
    }

    private void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    private void loadProperties(InputStream inputstream) {
        Properties properties = new Properties();
        try {
            properties.load(inputstream);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        Object obj = properties.get("name");
        if (obj != null) {
            this.name = obj.toString();
        }
        Object obj1 = null;
        obj1 = properties.get("primary1");
        if (obj1 != null) {
            this.primary1 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("primary2")) != null) {
            this.primary2 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("primary3")) != null) {
            this.primary3 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("secondary1")) != null) {
            this.secondary1 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("secondary2")) != null) {
            this.secondary2 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("secondary3")) != null) {
            this.secondary3 = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("black")) != null) {
            this.black = this.parseColor(obj1.toString());
        }
        if ((obj1 = properties.get("white")) != null) {
            this.white = this.parseColor(obj1.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public ColorUIResource getPrimary1() {
        return this.primary1;
    }

    public ColorUIResource getPrimary2() {
        return this.primary2;
    }

    public ColorUIResource getPrimary3() {
        return this.primary2;
    }

    public ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    public ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    public ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    public ColorUIResource getBlack() {
        return this.black;
    }

    public ColorUIResource getWhite() {
        return this.white;
    }

    public ColorUIResource getControlShadow() {
        return this.getPrimary1();
    }

    private ColorUIResource parseColor(String s) {
        int i = 0;
        int j = 0;
        int k = 0;
        try {
            StringTokenizer stringtokenizer = new StringTokenizer(s, ",");
            i = Integer.parseInt(stringtokenizer.nextToken());
            j = Integer.parseInt(stringtokenizer.nextToken());
            k = Integer.parseInt(stringtokenizer.nextToken());
        }
        catch (Exception exception) {
            Log.printError("Couldn't parse color :" + s);
        }
        return new ColorUIResource(i, j, k);
    }
}

