/*
 * Decompiled with CFR 0.152.
 */
package softface.tree;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import softface.tree.FileNodeComparator;
import softface.tree.FileTreeIcon;
import softface.tree.IconData;
import softface.tree.TreeIcon;

public class FileNode {
    protected boolean isExpendFiles = false;
    protected File m_file;

    public FileNode(File file) {
        this.m_file = file;
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        return this.m_file.getName().length() <= 0 ? this.m_file.getPath() : this.m_file.getName();
    }

    public boolean isDirectory() {
        return this.m_file.isDirectory();
    }

    public boolean isExpendFiles() {
        return this.isExpendFiles;
    }

    public void setExpendFiles(boolean flag) {
        this.isExpendFiles = flag;
    }

    public boolean expand(DefaultMutableTreeNode defaultmutabletreenode) {
        return this.expand(defaultmutabletreenode, null);
    }

    public boolean expand(DefaultMutableTreeNode defaultmutabletreenode, FileFilter filefilter) {
        if (defaultmutabletreenode.isLeaf()) {
            return false;
        }
        DefaultMutableTreeNode defaultmutabletreenode1 = (DefaultMutableTreeNode)defaultmutabletreenode.getFirstChild();
        if (defaultmutabletreenode1 == null) {
            return false;
        }
        Object obj = defaultmutabletreenode1.getUserObject();
        if (!(obj instanceof Boolean)) {
            return false;
        }
        defaultmutabletreenode.removeAllChildren();
        File[] afile = this.listFiles();
        if (afile == null) {
            return true;
        }
        Vector<FileNode> vector = new Vector<FileNode>();
        int i = 0;
        while (i < afile.length) {
            File file = afile[i];
            if (filefilter == null || filefilter.accept(file)) {
                FileNode filenode = new FileNode(file);
                vector.addElement(filenode);
            }
            ++i;
        }
        Object[] afilenode = new FileNode[vector.size()];
        vector.copyInto(afilenode);
        Arrays.sort(afilenode, new FileNodeComparator());
        int j = 0;
        while (j < afilenode.length) {
            Object filenode1 = afilenode[j];
            IconData icondata = null;
            icondata = ((FileNode)filenode1).isDirectory() ? new IconData(TreeIcon.ICON_FOLDER, TreeIcon.ICON_EXPANDEDFOLDER, filenode1) : new IconData(FileTreeIcon.getImageIcon(((FileNode)filenode1).getFile(), false), filenode1);
            DefaultMutableTreeNode defaultmutabletreenode2 = new DefaultMutableTreeNode(icondata);
            defaultmutabletreenode.add(defaultmutabletreenode2);
            if (((FileNode)filenode1).hasSubDirs(filefilter)) {
                defaultmutabletreenode2.add(new DefaultMutableTreeNode(new Boolean(true)));
            }
            ++j;
        }
        return true;
    }

    public boolean hasSubDirs(FileFilter filefilter) {
        File[] afile = this.listFiles();
        if (afile == null) {
            return false;
        }
        int i = 0;
        while (i < afile.length) {
            if (afile[i].isDirectory() || filefilter != null && filefilter.accept(afile[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected File[] listFiles() {
        if (!this.m_file.isDirectory()) {
            return null;
        }
        return this.m_file.listFiles();
    }
}

