/*
 * Decompiled with CFR 0.152.
 */
package softface.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import softface.tree.IconData;

public class IconCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
    protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
    protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
    protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    protected boolean m_selected;

    public IconCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree jtree, Object obj, boolean flag, boolean flag1, boolean flag2, int i, boolean flag3) {
        DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode)obj;
        Object obj1 = defaultmutabletreenode.getUserObject();
        this.setText(obj1.toString());
        if (obj1 instanceof Boolean) {
            this.setText("");
        }
        if (obj1 instanceof IconData) {
            IconData icondata = (IconData)obj1;
            if (flag1) {
                this.setIcon(icondata.getExpandedIcon());
            } else {
                this.setIcon(icondata.getIcon());
            }
        } else {
            this.setIcon(null);
        }
        this.setFont(jtree.getFont());
        this.setForeground(flag ? this.m_textSelectionColor : this.m_textNonSelectionColor);
        this.setBackground(flag ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
        this.m_selected = flag;
        return this;
    }

    public void paintComponent(Graphics g) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        g.setColor(color);
        int i = 0;
        if (icon != null && this.getText() != null) {
            i = icon.getIconWidth() + this.getIconTextGap();
        }
        g.fillRect(i, 0, this.getWidth() - 1 - i, this.getHeight() - 1);
        if (this.m_selected) {
            g.setColor(this.m_borderSelectionColor);
            g.drawRect(i, 0, this.getWidth() - 1 - i, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }
}

