/*
 * Decompiled with CFR 0.152.
 */
package softface.tree;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import softface.theme.Log;
import softface.theme.Utils;

public class LockIcon
extends ImageIcon {
    private static final Image lockImage = Utils.readImage("/com/fr/gui/images/locked.gif");
    private Image mainImage = null;
    transient int loadStatus = 0;
    ImageObserver imageObserver;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    int width = -1;
    int height = -1;

    public LockIcon(Image image) {
        this.loadImage(lockImage);
        this.mainImage = image;
        if (this.mainImage != null) {
            this.loadImage(this.mainImage);
        }
    }

    public void paintIcon(Component component1, Graphics g, int i, int j) {
        if (this.mainImage != null) {
            g.drawImage(this.mainImage, i, j, component1);
        }
        if (lockImage != null) {
            g.drawImage(lockImage, i, j, component1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedexception) {
                Log.printError("INTERRUPTED while loading Image");
            }
            this.loadStatus = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
        }
    }

    public Image getImage() {
        return this.mainImage;
    }

    public LockIcon getDisabledLockIcon() {
        Image image = GrayFilter.createDisabledImage(this.mainImage);
        return new LockIcon(image);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

