/*
 * Decompiled with CFR 0.152.
 */
package softoperation;

import java.awt.Graphics;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JPanel;
import softoperation.Timer;
import softoperation.TimerListener;

class ClockCanvas
extends JPanel
implements TimerListener {
    private int seconds = 0;
    private String city;
    private int offset;
    private GregorianCalendar calendar;
    private final int LOCAL = 16;

    public ClockCanvas(String c, String tz) {
        this.city = c;
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone(tz));
        Timer t = new Timer(1000, this);
        t.start();
        this.setSize(125, 125);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawOval(0, 0, 100, 100);
        double hourAngle = Math.PI * 2 * (double)(this.seconds - 10800) / 43200.0;
        double minuteAngle = Math.PI * 2 * (double)(this.seconds - 900) / 3600.0;
        double secondAngle = Math.PI * 2 * (double)(this.seconds - 15) / 60.0;
        g.drawLine(50, 50, 50 + (int)(30.0 * Math.cos(hourAngle)), 50 + (int)(30.0 * Math.sin(hourAngle)));
        g.drawLine(50, 50, 50 + (int)(40.0 * Math.cos(minuteAngle)), 50 + (int)(40.0 * Math.sin(minuteAngle)));
        g.drawLine(50, 50, 50 + (int)(45.0 * Math.cos(secondAngle)), 50 + (int)(45.0 * Math.sin(secondAngle)));
        g.drawString(this.city, 0, 115);
    }

    public void timeElapsed(Timer t) {
        this.calendar.setTime(new Date());
        this.seconds = this.calendar.get(10) * 60 * 60 + this.calendar.get(12) * 60 + this.calendar.get(13);
        this.repaint();
    }
}

