/*
 * Decompiled with CFR 0.152.
 */
package softoperation.ERPTrade;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class JRadioButtonTableExample2
extends JFrame {
    public JRadioButtonTableExample2() {
        super("JRadioButtonTable Example");
        Object[] columnHeader = new String[]{"Questions", "Answer"};
        Object[][] o = new Object[5][2];
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(o, columnHeader);
        JTable table = new JTable(dm);
        String[] answer = new String[]{"a", "b", "c"};
        table.getColumn("Answer").setCellRenderer(new RadioButtonRenderer(answer));
        table.getColumn("Answer").setCellEditor(new RadioButtonEditor(new JCheckBox(), new RadioButtonPanel(answer)));
        JScrollPane scroll = new JScrollPane(table);
        this.getContentPane().add(scroll);
    }

    public static void main(String[] args) {
        JRadioButtonTableExample2 frame = new JRadioButtonTableExample2();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(230, 140);
        frame.setVisible(true);
    }

    class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        RadioButtonPanel panel;

        public RadioButtonEditor(JCheckBox checkBox, RadioButtonPanel panel) {
            super(checkBox);
            this.panel = panel;
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton[] buttons = panel.getButtons();
            int i = 0;
            while (i < buttons.length) {
                buttonGroup.add(buttons[i]);
                buttons[i].addItemListener(this);
                ++i;
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Integer) {
                this.panel.setSelectedIndex((Integer)value);
            }
            return this.panel;
        }

        public Object getCellEditorValue() {
            return new Integer(this.panel.getSelectedIndex());
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    class RadioButtonPanel
    extends JPanel {
        JRadioButton[] buttons;

        RadioButtonPanel(String[] str) {
            this.setLayout(new BoxLayout(this, 0));
            this.buttons = new JRadioButton[str.length];
            int i = 0;
            while (i < this.buttons.length) {
                this.buttons[i] = new JRadioButton(str[i]);
                this.buttons[i].setFocusPainted(false);
                this.add(this.buttons[i]);
                ++i;
            }
        }

        public void setSelectedIndex(int index) {
            int i = 0;
            while (i < this.buttons.length) {
                this.buttons[i].setSelected(i == index);
                ++i;
            }
        }

        public int getSelectedIndex() {
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i].isSelected()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public JRadioButton[] getButtons() {
            return this.buttons;
        }
    }

    class RadioButtonRenderer
    extends RadioButtonPanel
    implements TableCellRenderer {
        RadioButtonRenderer(String[] strs) {
            super(strs);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Integer) {
                this.setSelectedIndex((Integer)value);
            }
            return this;
        }
    }
}

