/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpRowFilter;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;
import softoperation.finance.erpdata.TableYearMonthCellDataAccess;

public class ErpBCodeTable
extends GridTable {
    private String bcodePtn = null;
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] bcodeLevl;
    private Variant variant = new Variant();
    int levl;
    int levlDataType;
    private Hashtable codeHash;
    TableColumn bcodeColumn;
    private String oldBCode = "";

    public ErpBCodeTable(String s, boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u90e8\u95e8\u4eba\u5458\uff1f");
        if (!flag) {
            try {
                this.bcodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 9 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 2) != 0;
            this.bUsedAddSubCodeEnable = true;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select bcode from balance where (bcode is not null) and bcode<>' ' group by bcode  order by bcode", "select bcode from ivoucher where (bcode is not null) and bcode<>' ' group by bcode order by bcode"}, 0, -1, this.bcodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bcodePtn = s;
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void print() {
        try {
            ErpPubl.printTable("\u90e8\u95e8\u4eba\u5458", this.dataSet, 9);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldBCode = this.dataSet.getString("bcode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldBCode = this.dataSet.getString("bcode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldBCode.length() > 0 && this.codeHash.get(this.oldBCode) != null;
        this.setRwFlags(32, flag1);
        if (this.bcodeColumn != null) {
            this.bcodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",bname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("bcode")) {
            try {
                String s = dataset.getString("bcode");
                int i = s != null ? s.length() : 0;
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.bcodeLevl, i, true) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void find() {
        ErpPubl.find(this, "bcode");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u90e8\u95e8\u4eba\u5458");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u90e8\u95e8\u4eba\u5458");
            this.addLoged = true;
        }
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("bcode");
            if (this.bcodePtn != null && !Utilities.likeOneOf(s1, this.bcodePtn, false)) {
                s = String.valueOf(s) + "\u90e8\u95e8\u7801\u8f93\u5165\u9519\u8bef\uff01\n";
            } else if (this.levl < 0) {
                s = String.valueOf(s) + "\u90e8\u95e8\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldBCode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('b');
                if (Utilities.seekDataSet(dataset, "bcode", s1)) {
                    s = String.valueOf(s) + "\u90e8\u95e8\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.bcodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u90e8\u95e8\u7801" + s2 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupBCode(boolean flag, String s) throws DataSetException {
        if (s != null) {
            String[] as = Utilities.splitString(s, ',');
            s = null;
            int i = 0;
            while (i < as.length) {
                s = s == null ? String.valueOf(as[i]) + '*' : String.valueOf(s) + ',' + as[i] + '*';
                ++i;
            }
        }
        ErpBCodeTable snabcodetable = new ErpBCodeTable(s, flag);
        snabcodetable.setDatasetTablename("bcode");
        snabcodetable.addColumns(new String[]{"bcode", "bname", "ym_deprecated", "shortcode"}, new String[]{"\u90e8\u95e8\u7801", "\u90e8\u95e8\u540d", "\u8c03\u79bb\u5e74\u6708", "\u7b80\u7801"});
        TableColumn tablecolumn = snabcodetable.getColumn("bcode");
        tablecolumn.setOptions(0x308000, true);
        snabcodetable.bcodeColumn = tablecolumn;
        tablecolumn.setDisplayWidth(96);
        tablecolumn = snabcodetable.getColumn("bname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(160);
        tablecolumn = snabcodetable.getColumn("ym_deprecated");
        tablecolumn.setDataType(16);
        tablecolumn.setTableCellDataAccess(new TableYearMonthCellDataAccess());
        tablecolumn.setDisplayWidth(64);
        if ((ErpConfig.getOtherOption() & 2) != 0) {
            TableColumn tablecolumn1 = new TableColumn();
            tablecolumn1.setCellId("strval1", "\u8d77\u59cb\u53d1\u7968\u53f7");
            tablecolumn1.setDisplayWidth(128);
            snabcodetable.addColumn(tablecolumn1);
            tablecolumn1 = new TableColumn();
            tablecolumn1.setCellId("strval2", "\u7ec8\u6b62\u53d1\u7968\u53f7");
            tablecolumn1.setDisplayWidth(128);
            snabcodetable.addColumn(tablecolumn1);
        }
        DataSet dataset = ErpPubl.getSharedTblDataSet("bcode");
        Column column = dataset.getColumn("levl");
        snabcodetable.levlDataType = column.getDataType();
        ErpPubl.addExtraTableColumn(snabcodetable, 9, 101);
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        if (s != null) {
            ErpRowFilter snarowfilter = new ErpRowFilter(1, "bcode", s);
            try {
                datasetview.addRowFilterListener((RowFilterListener)snarowfilter);
            }
            catch (Exception exception) {
                Message.out.println(exception);
            }
        }
        datasetview.setSort(dataset.getSort());
        datasetview.open();
        ErpPubl.createDataSetInternalFrame("\u90e8\u95e8\u4eba\u5458", snabcodetable, (DataSet)datasetview, true);
    }
}

