/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.TableDataSet;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import softcore.awt.ScrollBarPanel;
import softcore.table.DebitCreditSumAggOperaror;
import softcore.table.GridTable;
import softcore.table.RecordTable;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.table.TableColumnSumAggObjectGetter;
import softcore.table.TableStaticCell;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Type;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpBnkDialogPanel;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpTableVouTypeVouNoCellDataAccess;
import softoperation.finance.erpdata.ErpdataDataWindow;
import softoperation.finance.erpdata.TableDebitCreditCellDataAccess;

public class ErpBnkAdjustTable
extends ErpdataDataWindow {
    int year;
    int month;
    int bMonth = 1;
    int autoCheckedWord;
    String acode;
    String bcode;
    String fcode;
    String where;
    TableDataSet blcDataSet;
    QueryDataSet bnkSheetDataSet;
    QueryDataSet bnkLdgDataSet;
    Table blcTable;
    Table sheetTable;
    Table ldgTable;
    BigDecimal sheetBlc;
    BigDecimal ldgBlc;
    private BigDecimal zeroBigDecimal = new BigDecimal(0.0);
    private Variant variant = new Variant();

    public ErpBnkAdjustTable(int i, int j, String s, String s1, String s2) {
        this.year = i;
        this.month = j;
        this.autoCheckedWord = (i - 1900) * 16 + j;
        this.acode = s;
        this.bcode = s1;
        this.fcode = s2;
        this.where = "(acode='" + s + "')";
        if (s1 != null) {
            this.where = String.valueOf(this.where) + " and (bcode like '" + s1 + "%')";
        }
        if (s2 != null) {
            this.where = String.valueOf(this.where) + " and (fcode = '" + s2 + "')";
        }
        try {
            this.blcTable = this.createBlcTable();
            this.sheetTable = this.createBnkSheetTable();
            this.ldgTable = this.createBnkLdgTable();
            this.setBalance();
            this.blcTable.setDataSetChanged(false);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    int getDC(String s) {
        DataSet dataset = ErpPubl.getSharedTblDataSet('a');
        try {
            if (Utilities.seekDataSet(dataset, "acode", s)) {
                Variant variant1 = new Variant();
                dataset.getVariant("dc", variant1);
                return variant1.getAsInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        return 1;
    }

    BigDecimal getLdgBalance0() throws SQLException {
        String s = "select sum(" + (this.fcode != null ? "fcybalance" : "rmbbalance") + ") from balance where year=" + this.year + " and month=" + this.month;
        Object obj = JDBC.sqlSelect1(null, s = String.valueOf(s) + " and " + this.where);
        BigDecimal bigdecimal = Type.toBigDecimal((Number)obj, 2);
        if (bigdecimal != null && this.getDC(this.acode) < 0) {
            bigdecimal = bigdecimal.negate();
        }
        return bigdecimal;
    }

    void setBalance() throws DataSetException {
        BigDecimal bigdecimal = this.blcDataSet.getBigDecimal("sheetbalance0");
        if (bigdecimal == null) {
            bigdecimal = this.ldgBlc;
        } else if (this.ldgBlc != null) {
            bigdecimal = bigdecimal.add(this.ldgBlc);
        }
        this.blcDataSet.setBigDecimal("sheetbalance", bigdecimal);
        bigdecimal = this.blcDataSet.getBigDecimal("ldgbalance0");
        if (bigdecimal == null) {
            bigdecimal = this.sheetBlc;
        } else if (this.sheetBlc != null) {
            bigdecimal = bigdecimal.add(this.sheetBlc);
        }
        this.blcDataSet.setBigDecimal("ldgbalance", bigdecimal);
    }

    RecordTable createBlcTable() throws SQLException, DataSetException {
        this.blcDataSet = new TableDataSet();
        ErpPubl.addColumns(this.blcDataSet, new String[]{"ldgbalance0", "ldgbalance", "sheetbalance0", "sheetbalance"}, new int[]{10, 10, 10, 10});
        this.blcDataSet.open();
        this.blcDataSet.insertRow(false);
        String s = "select vmonth," + (this.fcode != null ? "fcybalance" : "rmbbalance") + " from banksheet where year=" + this.year + " and month=0 and dc=0";
        s = String.valueOf(s) + " and " + this.where;
        Object[] aobj = JDBC.sqlSelect2(null, s);
        BigDecimal bigdecimal = this.zeroBigDecimal;
        if (aobj != null) {
            if (aobj[0] != null) {
                this.bMonth = ((Number)aobj[0]).intValue();
            }
            if (this.month >= this.bMonth - 1 && aobj[1] != null) {
                bigdecimal = Type.toBigDecimal((Number)aobj[1], 2);
            }
        }
        if (this.month >= this.bMonth) {
            String s1 = "select sum(" + (this.fcode == null ? "rmb" : "fcy") + "*dc) from banksheet where dc<>0 and year=" + this.year + " and month>=" + this.bMonth + " and month<=" + this.month;
            Object obj = JDBC.sqlSelect1(null, s1 = String.valueOf(s1) + " and " + this.where);
            if (obj != null) {
                bigdecimal = bigdecimal.add(Type.toBigDecimal((Number)obj, 2));
            }
        }
        this.blcDataSet.setBigDecimal("sheetbalance0", bigdecimal);
        BigDecimal bigdecimal1 = this.month < this.bMonth - 1 ? null : this.getLdgBalance0();
        this.blcDataSet.setBigDecimal("ldgbalance0", bigdecimal1 != null ? bigdecimal1 : this.zeroBigDecimal);
        RecordTable recordtable = new RecordTable();
        recordtable.setRwFlags(1, true);
        int i = 10;
        int j = 5;
        TableStaticCell tablestaticcell = null;
        Object obj1 = null;
        String[] as = new String[]{"\u5bf9\u5e10\u5355\u8c03\u8282\u524d\u4f59\u989d\uff1a", "\u94f6\u884c\u5e10\u8c03\u8282\u524d\u4f59\u989d\uff1a", "\u5bf9\u5e10\u5355\u8c03\u8282\u540e\u4f59\u989d\uff1a", "\u94f6\u884c\u5e10\u8c03\u8282\u540e\u4f59\u989d\uff1a"};
        String[] as1 = new String[]{"sheetbalance0", "ldgbalance0", "sheetbalance", "ldgbalance"};
        int k = 0;
        while (k < as1.length) {
            if (k % 2 == 0) {
                i = 10;
                j += (tablestaticcell == null ? 0 : tablestaticcell.height) + 5;
            }
            tablestaticcell = new TableStaticCell();
            tablestaticcell.setDockXY(i, j);
            tablestaticcell.width = 150;
            tablestaticcell.height = 20;
            tablestaticcell.displayCaption = as[k];
            recordtable.addStaticCell(tablestaticcell);
            TableColumn tablecolumn = new TableColumn();
            tablecolumn.setDockXY(i += tablestaticcell.width + 10, j);
            tablecolumn.width = 130;
            tablecolumn.height = 20;
            tablecolumn.setCellId(as1[k], null);
            recordtable.addColumn(tablecolumn);
            i += tablecolumn.width + 10;
            ++k;
        }
        recordtable.setDataSet((DataSet)this.blcDataSet);
        recordtable.initial();
        return recordtable;
    }

    GridTable createBnkSheetTable() throws DataSetException {
        this.bnkSheetDataSet = new QueryDataSet();
        String s = "";
        if (this.month < this.bMonth - 1) {
            s = String.valueOf(s) + " where (year=-1)";
        } else {
            s = String.valueOf(s) + " where dc<>0 and year=" + this.year + " and ((month=0) or (month>=" + this.bMonth + " and month<=" + this.month + "))";
            s = String.valueOf(s) + " and ( (vmonth is null) or (vmonth=0) or (" + JDBC.sqlModFunction("vmonth", 16384) + " > " + this.autoCheckedWord + ") )";
            s = String.valueOf(s) + " and " + this.where;
            String s1 = "select sum(" + (this.fcode == null ? "rmb" : "fcy") + "*dc) from banksheet" + s;
            try {
                Object obj = JDBC.sqlSelect1(null, s1);
                if (obj != null) {
                    this.sheetBlc = Type.toBigDecimal((Number)obj, 2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        String s2 = "select * from banksheet" + s;
        this.bnkSheetDataSet.setQuery(new QueryDescriptor(ErpPubl.database, s2, null, true, true));
        this.bnkSheetDataSet.setSort(new SortDescriptor(null, new String[]{"bkdate"}, null, true, false, null));
        this.bnkSheetDataSet.setColumns(DebitCreditSumAggOperaror.createDebitCreditSumColumn(null, this.fcode == null ? "rmb" : "fcy", "dc"));
        this.bnkSheetDataSet.setResolvable(false);
        this.bnkSheetDataSet.open();
        GridTable gridtable = new GridTable();
        gridtable.setRwFlags(1, true);
        String s3 = this.fcode == null ? "rmbdebit" : "fcydebit";
        String s4 = this.fcode == null ? "rmbcredit" : "fcycredit";
        gridtable.addColumns(new String[]{"bkdate", "qcode", "expl", s3, s4}, new String[]{"\u65e5\u671f", "\u652f\u7968\u53f7", "\u6458\u8981", "\u6536\u65b9", "\u4ed8\u65b9"});
        gridtable.setBottomFixedRows(1);
        TableColumn tablecolumn = gridtable.getColumn("qcode");
        tablecolumn.setBottomValue(new Object[]{"\u5408\u8ba1\uff1a"});
        tablecolumn = gridtable.getColumn(s3);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fcode == null ? "rmb" : "fcy", "dc", 1));
        tablecolumn.setBottomValue(new Object[]{new TableColumnSumAggObjectGetter((DataSet)this.bnkSheetDataSet, this.fcode == null ? "rmb_DebitTotal" : "fcy_DebitTotal", tablecolumn)});
        tablecolumn = gridtable.getColumn(s4);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fcode == null ? "rmb" : "fcy", "dc", -1));
        tablecolumn.setBottomValue(new Object[]{new TableColumnSumAggObjectGetter((DataSet)this.bnkSheetDataSet, this.fcode == null ? "rmb_CreditTotal" : "fcy_CreditTotal", tablecolumn)});
        gridtable.setDataSet((DataSet)this.bnkSheetDataSet);
        gridtable.initial();
        return gridtable;
    }

    GridTable createBnkLdgTable() throws DataSetException {
        this.bnkLdgDataSet = new QueryDataSet();
        String s = "";
        if (this.month < this.bMonth - 1) {
            s = String.valueOf(s) + " where (year=-1)";
        } else {
            s = String.valueOf(s) + " where (kept<>0) and (kept is not null) and year=" + this.year + " and ((month=0) or (month>=" + this.bMonth + " and month<=" + this.month + "))";
            s = String.valueOf(s) + " and ( (bankmonth is null) or (bankmonth=0) or (" + JDBC.sqlModFunction("bankmonth", 16384) + " > " + this.autoCheckedWord + ") )";
            s = String.valueOf(s) + " and " + this.where;
            String s1 = "select sum(" + (this.fcode == null ? "rmb" : "fcy") + "*vdc) from ivoucher" + s;
            try {
                Object obj = JDBC.sqlSelect1(null, s1);
                if (obj != null) {
                    this.ldgBlc = Type.toBigDecimal((Number)obj, 2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        String s2 = "select * from ivoucher" + s;
        this.bnkLdgDataSet.setQuery(new QueryDescriptor(ErpPubl.database, s2, null, true, true));
        this.bnkLdgDataSet.setSort(new SortDescriptor(null, new String[]{"vdate", "ino"}, null, true, false, null));
        this.bnkLdgDataSet.setColumns(DebitCreditSumAggOperaror.createDebitCreditSumColumn(null, this.fcode == null ? "rmb" : "fcy", "vdc"));
        this.bnkLdgDataSet.setResolvable(false);
        this.bnkLdgDataSet.open();
        GridTable gridtable = new GridTable();
        gridtable.setRwFlags(1, true);
        String s3 = this.fcode == null ? "rmbdebit" : "fcydebit";
        String s4 = this.fcode == null ? "rmbcredit" : "fcycredit";
        gridtable.addColumns(new String[]{"vdate", "vtypeandno", "qcode", "expl", s3, s4}, new String[]{"\u51ed\u8bc1\u65e5\u671f", "\u51ed\u8bc1\u53f7", "\u652f\u7968\u53f7", "\u6458\u8981", "\u501f\u65b9", "\u8d37\u65b9"});
        gridtable.setBottomFixedRows(1);
        TableColumn tablecolumn = gridtable.getColumn("qcode");
        tablecolumn.setBottomValue(new Object[]{"\u5408\u8ba1\uff1a"});
        tablecolumn = gridtable.getColumn("vtypeandno");
        tablecolumn.setDataType(16);
        tablecolumn.setDisplayWidth(64);
        tablecolumn.setTableCellDataAccess(new ErpTableVouTypeVouNoCellDataAccess("vtypeno"));
        tablecolumn = gridtable.getColumn(s3);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fcode == null ? "rmb" : "fcy", "vdc", 1));
        tablecolumn.setBottomValue(new Object[]{new TableColumnSumAggObjectGetter((DataSet)this.bnkLdgDataSet, this.fcode == null ? "rmb_DebitTotal" : "fcy_DebitTotal", tablecolumn)});
        tablecolumn = gridtable.getColumn(s4);
        tablecolumn.setDataType(10);
        tablecolumn.setTableCellDataAccess(new TableDebitCreditCellDataAccess(this.fcode == null ? "rmb" : "fcy", "vdc", -1));
        tablecolumn.setBottomValue(new Object[]{new TableColumnSumAggObjectGetter((DataSet)this.bnkLdgDataSet, this.fcode == null ? "rmb_CreditTotal" : "fcy_CreditTotal", tablecolumn)});
        gridtable.setDataSet((DataSet)this.bnkLdgDataSet);
        gridtable.initial();
        return gridtable;
    }

    JSplitPane createSplitPane() {
        JSplitPane jsplitpane = new JSplitPane(1, new ScrollBarPanel(this.sheetTable, 3), new ScrollBarPanel(this.ldgTable, 3));
        JSplitPane jsplitpane1 = new JSplitPane(0, this.blcTable, jsplitpane);
        Dimension dimension = new Dimension(600, 55);
        this.blcTable.setPreferredSize(dimension);
        this.blcTable.setMinimumSize(dimension);
        if (MainApp.javaVersion >= 304) {
            jsplitpane.setResizeWeight(0.5);
        }
        return jsplitpane1;
    }

    public static void queryBnkAdjustTable() throws DataSetException, SQLException {
        int i = ErpConfig.getBnkCheckByBCodeLevl();
        if (!ErpBnkDialogPanel.askBnkCheck(i <= 0 ? 3 : 7, false, 3, false, 0, "\u94f6\u884c\u5bf9\u5e10\u8c03\u8282\u8868")) {
            return;
        }
        String s = i <= 0 ? null : ErpPubl.bnkBCode;
        String s1 = (ErpPubl.bnkACodeProperty & 0x1000) == 0 ? null : ErpPubl.bnkFCode;
        ErpBnkAdjustTable snabnkadjusttable = new ErpBnkAdjustTable(ErpPubl.ymd[0], ErpPubl.ymd[1], ErpPubl.bnkACode, s, s1);
        snabnkadjusttable.addDataSet((DataSet)snabnkadjusttable.blcDataSet);
        snabnkadjusttable.addDataSet((DataSet)snabnkadjusttable.bnkSheetDataSet);
        snabnkadjusttable.addDataSet((DataSet)snabnkadjusttable.bnkLdgDataSet);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = snabnkadjusttable.blcTable.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width / 2 - 30, dimension.height - dimension1.height - 150);
        snabnkadjusttable.ldgTable.setPreferredSize(dimension2);
        snabnkadjusttable.sheetTable.setPreferredSize(dimension2);
        String s2 = ErpPubl.ymd[0] + "\u5e74" + ErpPubl.ymd[1] + "\u6708\u94f6\u884c\u5bf9\u5e10\u8c03\u8282\u8868[\u5e10\u6237:" + ErpPubl.bnkACode;
        if (s != null) {
            s2 = String.valueOf(s2) + ",\u90e8\u95e8:" + s;
        }
        if (s1 != null) {
            s2 = String.valueOf(s2) + ",\u5e01\u79cd:" + s1;
        }
        s2 = String.valueOf(s2) + ']';
        snabnkadjusttable.createSqlInternalFrame(s2, snabnkadjusttable.createSplitPane(), new JComponent[]{snabnkadjusttable.blcTable, snabnkadjusttable.sheetTable, snabnkadjusttable.ldgTable}, snabnkadjusttable.blcTable);
    }
}

