/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpRowFilter;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;
import softoperation.finance.erpdata.TableYearMonthCellDataAccess;

public class ErpCCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] ccodeLevl;
    private Variant variant = new Variant();
    int levl;
    int levlDataType;
    private String oldCName;
    private DataRow row;
    private DataSet pDataSet;
    private ErpRowFilter dataRowFilter;
    private Hashtable parmHash = new Hashtable();
    private Hashtable codeHash;
    TableColumn ccodeColumn;
    private String oldCCode = "";

    public ErpCCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u5ba2\u6237\uff1f");
        if (!flag) {
            try {
                this.ccodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 10 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 4) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 4) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select ccode from balance where ccode<>' ' group by ccode order by ccode", "select ccode from ivoucher where ccode<>' ' group by ccode order by ccode"}, 0, -1, this.ccodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldCCode = this.dataSet.getString("ccode");
        if ((ErpConfig.getOtherOption() & 8) != 0) {
            this.oldCName = this.dataSet.getString("cname");
        }
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldCCode = this.dataSet.getString("ccode");
            if ((ErpConfig.getOtherOption() & 8) != 0) {
                this.oldCName = this.dataSet.getString("cname");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldCCode.length() > 0 && this.codeHash.get(this.oldCCode) != null;
        this.setRwFlags(32, flag1);
        if (this.ccodeColumn != null) {
            this.ccodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",cname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void print() {
        try {
            ErpPubl.printTable("\u5f80\u6765\u5ba2\u6237", this.dataSet, 10);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5ba2\u6237");
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e\u5ba2\u6237");
            this.addLoged = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("ccode")) {
            try {
                String s = dataset.getString("ccode");
                int i = s != null ? s.length() : 0;
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.ccodeLevl, i, false) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        super.keyPressed(keyevent);
        try {
            int i = keyevent.getKeyCode();
            if (i == 120) {
                ErpPubl.filterTable(this, null, "\u8fc7\u6ee4", this.parmHash, null);
            }
            if (keyevent.isControlDown()) {
                switch (i) {
                    case 76: {
                        ErpPubl.locateTable(this, this.parmHash);
                        break;
                    }
                    case 90: {
                        ErpPubl.filterTable(this, null);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void find() {
        try {
            ErpPubl.locateTable(this, null, "\u5b9a\u4f4d", this.parmHash);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("ccode");
            if (this.levl < 0) {
                s = String.valueOf(s) + "\u5ba2\u6237\u7f16\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldCCode)) {
                String s3;
                DataSet dataset = ErpPubl.getSharedTblDataSet('c');
                if (Utilities.seekDataSet(dataset, "ccode", s1)) {
                    s = String.valueOf(s) + "\u5ba2\u6237\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s3 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.ccodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u5ba2\u6237\u7801" + s3 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
            String s2 = this.dataSet.getString("cname");
            if (!this.bQuery && (ErpConfig.getOtherOption() & 8) != 0 && !s2.equals(this.oldCName)) {
                this.row.setString("cname", s2);
                if (this.pDataSet.lookup((ReadRow)this.row, null, 32)) {
                    s = String.valueOf(s) + "\u5ba2\u6237\u540d\u91cd\u590d\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupCCode(boolean flag) throws DataSetException {
        ErpCCodeTable snaccodetable = new ErpCCodeTable(flag);
        snaccodetable.addColumns(new String[]{"ccode", "cname", "shortcode", "ym_deprecated", "ucodefilter"}, new String[]{"\u5ba2\u6237\u7f16\u7801", "\u5ba2\u6237\u540d", "\u7b80\u7801", "\u505c\u7528\u5e74\u6708", "\u53ef\u7528\u64cd\u4f5c\u5458"});
        TableColumn tablecolumn = snaccodetable.getColumn("cname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(320);
        snaccodetable.ccodeColumn = tablecolumn = snaccodetable.getColumn("ccode");
        tablecolumn.setOptions(0x308000, true);
        tablecolumn.setDisplayWidth(80);
        tablecolumn = snaccodetable.getColumn("ym_deprecated");
        tablecolumn.setDataType(16);
        tablecolumn.setTableCellDataAccess(new TableYearMonthCellDataAccess());
        tablecolumn.setDisplayWidth(64);
        DataSet dataset = ErpPubl.getSharedTblDataSet("ccode");
        if (!flag && (ErpConfig.getOtherOption() & 8) != 0) {
            snaccodetable.pDataSet = dataset;
            snaccodetable.row = new DataRow(dataset, "cname");
        }
        Column column = dataset.getColumn("levl");
        snaccodetable.levlDataType = column.getDataType();
        snaccodetable.dataRowFilter = new ErpRowFilter(7, "ccode", snaccodetable, null);
        snaccodetable.dataRowFilter.setCodePtn(null);
        ErpPubl.addExtraTableColumn(snaccodetable, 10, 101);
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        try {
            datasetview.addRowFilterListener((RowFilterListener)snaccodetable.dataRowFilter);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame("\u5f80\u6765\u5ba2\u6237", snaccodetable, (DataSet)datasetview, true);
    }
}

