/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.StorageDataSet;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class ErpICodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] icodeLevl;
    private Hashtable codeHash;
    TableColumn icodeColumn;
    private String oldICode = "";

    public ErpICodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u8bb0\u5f55\uff1f");
        if (!flag) {
            try {
                this.icodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 16 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x100) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x100) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select icode from balance where icode<>' ' group by icode order by icode", "select icode from ivoucher where icode<>' ' group by icode order by icode"}, 0, -1, this.icodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldICode = this.dataSet.getString("icode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldICode = this.dataSet.getString("icode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldICode.length() > 0 && this.codeHash.get(this.oldICode) != null;
        this.setRwFlags(32, flag1);
        if (this.icodeColumn != null) {
            this.icodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",iname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void print() {
        try {
            ErpPubl.printTable("ICODE", this.dataSet, 16);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getICodeTitle());
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getICodeTitle());
            this.addLoged = true;
        }
    }

    public void find() {
        ErpPubl.find(this, "icode");
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        try {
            if (tablecolumn.cellId.equals("icode") && (ErpConfig.getVouOption1() & 0x100) != 0) {
                dataset.setString("icode", dataset.getString("icode").toUpperCase());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("icode");
            int i = ErpPubl.codeLevlMatched(this.icodeLevl, s1.trim().length(), false);
            if (i < 0) {
                s = String.valueOf(s) + "\u7f16\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldICode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('i');
                if (Utilities.seekDataSet(dataset, "icode", s1)) {
                    s = String.valueOf(s) + "\u7f16\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.icodeLevl, i)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u7684\u7f16\u7801" + s2 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupICode(boolean flag) throws DataSetException {
        ErpICodeTable snaicodetable = new ErpICodeTable(flag);
        snaicodetable.setDatasetTablename("icode");
        snaicodetable.addColumns(new String[]{"icode", "iname"}, new String[]{"\u7f16\u7801", "\u540d\u79f0"});
        TableColumn tablecolumn = snaicodetable.getColumn("iname");
        tablecolumn.setDisplayWidth(240);
        snaicodetable.icodeColumn = tablecolumn = snaicodetable.getColumn("icode");
        tablecolumn.setOptions(0x308000, true);
        tablecolumn.setDisplayWidth(160);
        ErpPubl.addExtraTableColumn(snaicodetable, 16, 101);
        DataSet dataset = ErpPubl.getSharedTblDataSet("icode");
        ErpPubl.addYmdepcAndUCodeFilterColumn(snaicodetable, dataset);
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame(ErpConfig.getICodeTitle(), snaicodetable, (DataSet)datasetview, true);
    }
}

