/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.util.Hashtable;
import softcore.table.GridTable;
import softcore.table.TableColumn;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpa.ErpACodeTable;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class ErpSCodeTable
extends GridTable {
    private boolean bQuery = false;
    private boolean addLoged;
    private boolean bUsedAddSubCodeEnable;
    private boolean bUsedModifyEnable;
    private Object[] scodeLevl;
    private Variant variant = new Variant();
    int levl;
    int levlDataType;
    private Hashtable codeHash;
    TableColumn scodeColumn;
    private String oldSCode = "";

    public ErpSCodeTable(boolean flag) {
        this.saveChangesOnPerRow = true;
        this.setPromptDeleteRow("\u786e\u8ba4\u5220\u9664\u8be5\u8bb0\u5f55\uff1f");
        if (!flag) {
            try {
                this.scodeLevl = JDBC.sqlSelect2(null, "select codelen from codelevl where tblid = 13 and levlid <> 0 order by levlid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bUsedModifyEnable = (MainApp.getAppIntOption(104, 3) & 0x800) != 0;
            this.bUsedAddSubCodeEnable = (MainApp.getAppIntOption(104, 6) & 0x800) != 0;
            this.codeHash = ErpPubl.createHashFromSql(new String[]{"select scode from balance where scode<>' ' group by scode order by scode", "select scode from ivoucher where scode<>' ' group by scode order by scode"}, 0, -1, this.scodeLevl);
        } else {
            this.setRwFlags(1, true);
        }
        this.bQuery = flag;
        this.addLoged = (ErpConfig.getOtherOption0() & 1) == 0;
    }

    public void postRow(DataChangeEvent datachangeevent) throws Exception {
        super.postRow(datachangeevent);
        this.oldSCode = this.dataSet.getString("scode");
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        if (this.bQuery) {
            return;
        }
        try {
            this.oldSCode = this.dataSet.getString("scode");
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
        boolean flag1 = this.oldSCode.length() > 0 && this.codeHash.get(this.oldSCode) != null;
        this.setRwFlags(32, flag1);
        if (this.scodeColumn != null) {
            this.scodeColumn.setOptions(256, flag1);
        }
        if (!this.bUsedModifyEnable) {
            String s = ",sname,";
            TableColumn[] atablecolumn = this.getTableColumns();
            int i = 0;
            while (i < atablecolumn.length) {
                if (s.indexOf("," + atablecolumn[i].cellId + ",") >= 0) {
                    atablecolumn[i].setOptions(256, flag1);
                }
                ++i;
            }
        }
    }

    public void print() {
        try {
            ErpPubl.printTable("SCODE", this.dataSet, 13);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public void find() {
        ErpPubl.find(this, "scode");
    }

    public void deleteRow() throws DataSetException {
        super.deleteRow();
        if (!this.addLoged) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getSCodeTitle());
            this.addLoged = true;
        }
    }

    protected void doSaveChanges() throws DataSetException {
        super.doSaveChanges();
        if (!this.addLoged && !this.isAllDataSetChangedOrChanging()) {
            Erpdata.addLogRecord(ErpdataConfig.currentConfig.idSystem, "\u8bbe\u7f6e" + ErpConfig.getSCodeTitle());
            this.addLoged = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onUnsavedExit() {
        if (!(this.dataSet instanceof DataSetView)) return true;
        StorageDataSet storagedataset = this.dataSet.getStorageDataSet();
        if (storagedataset == null) return true;
        if (!storagedataset.refreshSupported()) return true;
        try {
            try {
                this.fireEnableDataSetEvent(false, this.dataSet);
                storagedataset.refresh();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireEnableDataSetEvent(true, this.dataSet);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireEnableDataSetEvent(true, this.dataSet);
        return true;
    }

    protected void onPostEditingValue(DataSet dataset, TableColumn tablecolumn) {
        super.onPostEditingValue(dataset, tablecolumn);
        if (tablecolumn.cellId.equals("scode")) {
            try {
                String s = dataset.getString("scode");
                int i = s != null ? s.length() : 0;
                int n = this.levl = i != 0 ? ErpPubl.codeLevlMatched(this.scodeLevl, i, false) : -1;
                if (this.levl >= 0) {
                    Utilities.setIntToVariant(this.levl, this.variant, this.levlDataType);
                    dataset.setVariant("levl", this.variant);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    protected String getRowErrorText() {
        String s = super.getRowErrorText();
        if (s != null) {
            return s;
        }
        s = "";
        try {
            String s1 = this.dataSet.getString("scode");
            if (this.levl < 0) {
                s = String.valueOf(s) + "\u7f16\u7801\u957f\u5ea6\u4e0e\u7ea7\u957f\u5b9a\u4e49\u4e0d\u4e00\u81f4\uff01\n";
            } else if (!s1.equals(this.oldSCode)) {
                String s2;
                DataSet dataset = ErpPubl.getSharedTblDataSet('s');
                if (Utilities.seekDataSet(dataset, "scode", s1)) {
                    s = String.valueOf(s) + "\u7f16\u7801\u91cd\u590d\uff01\n";
                } else if (!this.bUsedAddSubCodeEnable && (s2 = ErpACodeTable.getParentUsedCode(dataset, this.codeHash, s1, this.scodeLevl, this.levl)) != null) {
                    s = String.valueOf(s) + "\u4e0d\u80fd\u589e\u52a0\u5df2\u4f7f\u7528\u8fc7\u7684\u7f16\u7801" + s2 + "\u7684\u5b50\u7801\uff01\n";
                }
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return s.equals("") ? null : s;
    }

    public static final void setupSCode(boolean flag) throws DataSetException {
        ErpSCodeTable snascodetable = new ErpSCodeTable(flag);
        snascodetable.setDatasetTablename("scode");
        snascodetable.addColumns(new String[]{"scode", "sname", "shortcode"}, new String[]{"\u7f16\u7801", "\u540d\u79f0", "\u7b80\u7801"});
        snascodetable.scodeColumn = snascodetable.getColumn("scode");
        snascodetable.scodeColumn.setOptions(0x308000, true);
        TableColumn tablecolumn = snascodetable.getColumn("sname");
        tablecolumn.setOptions(32768, true);
        tablecolumn.setDisplayWidth(240);
        ErpPubl.addExtraTableColumn(snascodetable, 13, 101);
        DataSet dataset = ErpPubl.getSharedTblDataSet("scode");
        ErpPubl.addYmdepcAndUCodeFilterColumn(snascodetable, dataset);
        Column column = dataset.getColumn("levl");
        snascodetable.levlDataType = column.getDataType();
        DataSetView datasetview = new DataSetView();
        datasetview.setStorageDataSet((StorageDataSet)dataset);
        datasetview.open();
        datasetview.setSort(dataset.getSort());
        ErpPubl.createDataSetInternalFrame(ErpConfig.getSCodeTitle(), snascodetable, (DataSet)datasetview, true);
    }
}

