/*
 * Decompiled with CFR 0.152.
 */
package softoperation.finance.erpa;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.TableDataSet;
import com.borland.dx.dataset.Variant;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Hashtable;
import softcore.awt.InfoPane;
import softcore.table.CodeNameMap;
import softcore.table.CodeNameSortedArray;
import softcore.table.DataSetCodeNameMap;
import softcore.table.Table;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softoperation.finance.erpa.ErpConfig;
import softoperation.finance.erpa.ErpPubl;
import softoperation.finance.erpa.ErpSetUnCheckLdg;
import softoperation.finance.erpa.ErpVoucher;
import softoperation.finance.erpdata.SelectGCodeDlg;

public class ErpVouInfoPane
extends InfoPane {
    private TableDataSet vouFldDataSet;
    private String vtype_bcode;
    private String oldVtypeBCode;
    private int oldVtype;
    private DataSet vouDataSet;
    private boolean closeVouFldDataSet;
    static final Color green = new Color(0, 128, 128);
    Hashtable codeNameHash;
    private BigDecimal zeroBigDecimal;
    private BigDecimal fcyTotal;
    private BigDecimal qtyTotal;
    public Table vouTable;
    boolean bBookMode;
    String yclACode1;
    Variant variant;
    Variant dataVar;

    public ErpVouInfoPane(TableDataSet tabledataset, DataSet dataset) {
        this(tabledataset, dataset, null);
    }

    public ErpVouInfoPane(TableDataSet tabledataset, DataSet dataset, String s) {
        Font font = new Font("Dialog", 0, 14);
        this.setFont(font);
        this.oldVtype = -1;
        this.closeVouFldDataSet = false;
        this.zeroBigDecimal = new BigDecimal(0.0).setScale(2, 4);
        this.bBookMode = false;
        this.variant = new Variant();
        this.dataVar = new Variant();
        this.setPreferredSize(new Dimension(0, 64));
        this.codeNameHash = new Hashtable();
        this.vouDataSet = dataset;
        this.vouFldDataSet = tabledataset;
        this.vtype_bcode = s;
        boolean bl = this.bBookMode = ErpPubl.getAppOptionAsText(2202, 1) != null;
        if (this.bBookMode) {
            this.yclACode1 = ErpPubl.getAppOptionAsText(2202, 11);
        }
        if (this.vouFldDataSet == null) {
            this.closeVouFldDataSet = true;
            this.vouFldDataSet = new TableDataSet();
            try {
                ErpSetUnCheckLdg.getVoucherField(this.vouFldDataSet);
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    public void setVtypeBCode(String s) {
        this.vtype_bcode = s;
    }

    CodeNameMap getCodeNameMap(String s, int i, int j) {
        Object obj = this.codeNameHash.get(s);
        if (obj != null) {
            return (CodeNameMap)obj;
        }
        if (i < 0) {
            return null;
        }
        if (i > 0) {
            CodeNameSortedArray codenamesortedarray = new CodeNameSortedArray();
            try {
                codenamesortedarray.loadFromJdbc(null, "select explcode,expl from expl where expltype=" + i + " order by explcode");
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
            this.codeNameHash.put(s, codenamesortedarray);
            return codenamesortedarray;
        }
        if ((j & 1) == 0 || s.length() != 5 || !s.endsWith("code") || s.equals("qcode")) {
            return null;
        }
        DataSet dataset = ErpPubl.getSharedTblDataSet(s);
        if (dataset == null) {
            return null;
        }
        CodeNameMap obj1 = null;
        if ((ErpConfig.getOtherOption0() & 8) != 0 && s.equals("gcode")) {
            obj1 = new SelectGCodeDlg(dataset);
            obj1.setTable(this.vouTable);
        } else {
            obj1 = new DataSetCodeNameMap(dataset, s, s.charAt(0) + "name");
        }
        this.codeNameHash.put(s, obj1);
        return obj1;
    }

    String getCodeName(String s, int i, int j, String s1) {
        CodeNameMap codenamemap = this.getCodeNameMap(s, i, j);
        if (codenamemap == null) {
            return null;
        }
        if ((j & 8) != 0) {
            if (codenamemap instanceof SelectGCodeDlg) {
                return ((SelectGCodeDlg)codenamemap).getFullNameByCode(s1);
            }
            return Utilities.findFullname(codenamemap, s1);
        }
        return codenamemap.getNameByCode(s1);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.closeVouFldDataSet) {
            try {
                this.vouFldDataSet.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        }
    }

    void getQFTotal(String s, int i) throws DataSetException {
        this.fcyTotal = this.zeroBigDecimal;
        this.qtyTotal = this.zeroBigDecimal;
        String s1 = this.vouDataSet.getString("fcode");
        String s2 = this.vouDataSet.getString("gcode");
        if (s1.trim().length() <= 0 && s2.trim().length() <= 0) {
            return;
        }
        int j = this.vouDataSet.getRowCount();
        int k = 0;
        while (k < j) {
            this.vouDataSet.getVariant("vdc", k, this.variant);
            int l = this.variant.getAsInt();
            this.vouDataSet.getVariant("acode", k, this.variant);
            String s3 = this.variant.getString();
            if (s.equals(s3) && i == l) {
                boolean flag = true;
                int i1 = ErpConfig.getVouOption1();
                if ((i1 & 0x4000) != 0) {
                    this.vouDataSet.getVariant("gcode", k, this.variant);
                    if (!s2.equals(this.variant.getString())) {
                        flag = false;
                    }
                }
                if (flag) {
                    this.vouDataSet.getVariant("qty", k, this.variant);
                    if (!this.variant.isNull()) {
                        this.qtyTotal = this.qtyTotal.add(this.variant.getAsBigDecimal());
                    }
                }
                flag = true;
                if ((i1 & 0x8000) != 0) {
                    this.vouDataSet.getVariant("fcode", k, this.variant);
                    if (!s1.equals(this.variant.getString())) {
                        flag = false;
                    }
                }
                if (flag) {
                    this.vouDataSet.getVariant("fcy", k, this.variant);
                    if (!this.variant.isNull()) {
                        this.fcyTotal = this.fcyTotal.add(this.variant.getAsBigDecimal());
                    }
                }
            }
            ++k;
        }
        this.fcyTotal = this.fcyTotal.setScale(2, 4);
        this.qtyTotal = this.qtyTotal.setScale(ErpPubl.getScale("qty"), 4);
    }

    private String getVtypeBCode() {
        if (ErpConfig.getKeepVouByBCodeLevl() <= 0) {
            return null;
        }
        if (this.vtype_bcode != null) {
            return this.vtype_bcode;
        }
        try {
            this.vouDataSet.getVariant("vtype", this.variant);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
            return null;
        }
        int i = this.variant.getAsInt();
        if (this.oldVtype != i) {
            this.oldVtype = i;
            try {
                this.oldVtypeBCode = JDBC.sqlSelectString("select bcodeslimit from vtype where vtype=" + i);
                return this.oldVtypeBCode;
            }
            catch (Exception exception1) {
                exception1.printStackTrace(Message.out);
                return null;
            }
        }
        return this.oldVtypeBCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addText() {
        block21: {
            block20: {
                this.clear();
                try {
                    try {
                        String s = this.vouDataSet.getString("acode");
                        if (s.trim().equals("")) {
                            Object var11_3 = null;
                            break block20;
                        }
                        this.vouDataSet.getVariant("vdc", this.variant);
                        int i = this.variant.getAsInt();
                        if (i != 1 && i != -1) {
                            i = 1;
                        }
                        this.getQFTotal(s, i);
                        this.addText(green, String.valueOf(s) + ':');
                        this.addText(Color.black, this.getCodeName("acode", 0, 9, s));
                        this.addNewLine();
                        int j = 0;
                        DataSet dataset = ErpPubl.getSharedTblDataSet('a');
                        if (Utilities.seekDataSet(dataset, "acode", s)) {
                            dataset.getVariant("property", this.variant);
                            j = this.variant.getAsInt();
                        }
                        this.vouFldDataSet.first();
                        while (this.vouFldDataSet.inBounds()) {
                            block22: {
                                block25: {
                                    int l;
                                    String s1;
                                    block24: {
                                        short word0;
                                        block23: {
                                            s1 = this.vouFldDataSet.getString("fldname");
                                            if (s1.equals("acode") || s1.equals("rmb")) break block22;
                                            word0 = this.vouFldDataSet.getShort("id");
                                            String s2 = this.vouFldDataSet.getString("bcode");
                                            if (!ErpVoucher.IVoucherRecordTable.isBCodeMatched(s2, this.getVtypeBCode())) break block22;
                                            if (word0 != 0) break block23;
                                            this.vouFldDataSet.getVariant("property", this.variant);
                                            int k = this.variant.getAsInt();
                                            String s3 = this.vouFldDataSet.getString("dcmask");
                                            if (!s1.equals("bcode") && ((j & k) == 0 || Utilities.likeOneOf(String.valueOf(i != 1 ? "D" : "C") + s, s3) || Utilities.likeOneOf("E" + s, s3))) break block22;
                                        }
                                        this.vouDataSet.getVariant(s1, this.dataVar);
                                        if (this.dataVar.isNull() || (l = this.dataVar.getType()) == 16 && this.dataVar.getString().trim().equals("")) break block22;
                                        this.addText(Color.blue, String.valueOf(this.vouFldDataSet.getString("dispname")) + ':');
                                        if (l != 16) break block24;
                                        this.vouFldDataSet.getVariant("flags", this.variant);
                                        int i1 = this.variant.getAsInt();
                                        String s4 = this.getCodeName(s1, word0, i1, this.dataVar.getString());
                                        if (s4 == null || s4.equals("")) {
                                            this.addText(Color.black, this.dataVar.getString());
                                        } else {
                                            this.addText(green, this.dataVar.getString());
                                            this.addText(Color.black, s4);
                                        }
                                        if (s1.equals("gcode") && this.qtyTotal.signum() != 0) {
                                            this.addText(Color.black, "(\u5408\u8ba1:" + this.qtyTotal + ")");
                                            break block25;
                                        } else if (s1.equals("fcode") && this.fcyTotal.signum() != 0) {
                                            this.addText(Color.black, "(\u5408\u8ba1:" + this.fcyTotal + ")");
                                        }
                                        break block25;
                                    }
                                    if (l == 15) {
                                        this.addText(Color.black, Utilities.dateToString(new Date(this.dataVar.getTimestamp().getTime())));
                                    } else if (l == 10) {
                                        this.vouFldDataSet.getVariant("flddecimal", this.variant);
                                        int j1 = this.variant.getAsInt();
                                        if (this.bBookMode && s1.equals("qty")) {
                                            j1 = 3;
                                            if (this.yclACode1 != null && !s.startsWith(this.yclACode1)) {
                                                j1 = 0;
                                            }
                                        }
                                        BigDecimal bigdecimal = this.dataVar.getAsBigDecimal().setScale(j1, 4);
                                        this.addText(Color.black, bigdecimal.toString());
                                    } else {
                                        this.addText(Color.black, this.dataVar.toString());
                                    }
                                }
                                this.addText(Color.black, "  ");
                            }
                            this.vouFldDataSet.next();
                        }
                        break block21;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Message.out);
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_4 = null;
                    this.repaint();
                    throw throwable;
                }
            }
            this.repaint();
            return;
        }
        Object var11_5 = null;
        this.repaint();
    }
}

