/*
 * Decompiled with CFR 0.152.
 */
package softoperation.query;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import softcore.util.Utilities;
import softoperation.query.CheckBoxAndLabel;
import softoperation.query.MyListCellRenderer;
import softoperation.query.flddata;

public class QueryDragList
extends JList {
    private MyListCellRenderer cellRenderer = new MyListCellRenderer();
    private DefaultListModel model = new DefaultListModel();
    Rectangle dragCellBounds;
    int dragSel = -1;
    int desSel = -1;
    Point mousePos;
    Point dragPos;
    boolean noIcon = false;
    boolean canDraging = true;
    boolean isDraging = false;
    boolean isSorticon = false;
    boolean isExecing = false;

    public QueryDragList() {
        this.setCellRenderer(this.cellRenderer);
        this.setModel(this.model);
        this.setFixedCellHeight(MyListCellRenderer.iconHeight + 5);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseevent) {
                QueryDragList.this.list_mouseDragged(mouseevent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseevent) {
                QueryDragList.this.list_mouseClicked(mouseevent);
            }

            public void mousePressed(MouseEvent mouseevent) {
                QueryDragList.this.list_mousePressed(mouseevent);
            }

            public void mouseReleased(MouseEvent mouseevent) {
                QueryDragList.this.list_mouseReleased(mouseevent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyevent) {
                QueryDragList.this.list_keyPressed(keyevent);
            }
        });
    }

    public void addElement(CheckBoxAndLabel checkboxandlabel) {
        this.model.addElement(checkboxandlabel);
    }

    public void addElement(String s, String s1) {
        this.model.addElement(new CheckBoxAndLabel(s, s1));
    }

    public void addElement(boolean flag, String s, String s1) {
        this.model.addElement(new CheckBoxAndLabel(flag, s, s1, 0, null));
    }

    public void addElement(boolean[] aflag, String[] as, Object[] aobj) {
        int i = 0;
        while (i < aflag.length) {
            this.model.addElement(new CheckBoxAndLabel(aflag[i], as[i], aobj[i].toString(), 0, null));
            ++i;
        }
    }

    public void addElement(flddata[] aflddata, int i, int j, int k) {
        this.addElement(aflddata, i, j, k, true);
    }

    public void addElement(flddata[] aflddata, int i, int j, int k, boolean flag) {
        boolean flag1 = false;
        boolean flag2 = true;
        int l = 0;
        while (l < aflddata.length) {
            boolean flag3;
            if (i == 0) {
                flag1 = aflddata[l].fldcheck;
            } else if (i == 1) {
                flag1 = aflddata[l].bGroup;
            } else if (i == 2) {
                this.isSorticon = true;
                boolean bl = flag1 = aflddata[l].bUpdown > 0;
            }
            boolean bl = flag ? true : (flag3 = !flag1);
            if ((i == 1 || j == 0 || j == 1 && (aflddata[l].bGroup || aflddata[l].bTotal)) && flag3 && (!this.isExecing || this.isExecing && aflddata[l].bUse)) {
                this.model.addElement(new CheckBoxAndLabel(flag1, aflddata[l].flditem, aflddata[l].fldid, !this.isSorticon ? 0 : aflddata[l].bUpdown, aflddata[l]));
            }
            ++l;
        }
    }

    public void addElement(flddata[] aflddata) {
        this.addElement(aflddata, 0, 0, 0);
    }

    public void setNoicon(boolean flag) {
        this.noIcon = flag;
        this.cellRenderer.setNoicon(flag);
    }

    public void setCanDraging(boolean flag) {
        this.canDraging = flag;
    }

    public void setCanExecing(boolean flag) {
        this.isExecing = flag;
    }

    public void setUseSorticon(boolean flag) {
        this.isSorticon = flag;
    }

    public void setChecked(int i, boolean flag) {
        CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
        checkboxandlabel.setSelected(flag);
    }

    public void setChecked(String s, flddata[] aflddata) {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        if (!s.equals("ALL")) {
            String s1 = "";
            String[] as = Utilities.splitString(s, ';');
            int j = 0;
            while (j < as.length) {
                String[] as1 = Utilities.splitString(as[j], ',');
                if (!as[j].trim().equals("")) {
                    String s2 = as1[0];
                    hashmap.put(s2.trim(), String.valueOf(as1[0]) + ":" + as1[2]);
                    s1 = String.valueOf(s1) + "\n" + as1[0] + ":" + as1[2];
                }
                ++j;
            }
        }
        int i = 0;
        while (i < aflddata.length) {
            Object obj = hashmap.get(aflddata[i].fldid);
            boolean flag = obj != null;
            aflddata[i].setFldcheck(flag);
            if (s.equals("ALL")) {
                flag = true;
            }
            if (flag) {
                aflddata[i].setbUse(true);
            }
            ++i;
        }
        this.repaint();
    }

    private void list_keyPressed(KeyEvent keyevent) {
        this.onKeyPressed(keyevent);
    }

    private void list_mouseClicked(MouseEvent mouseevent) {
        this.mouseClicked(mouseevent);
        Point point = mouseevent.getPoint();
        int i = this.locationToIndex(point);
        if (i == -1) {
            return;
        }
        if (mouseevent.getModifiers() == 16) {
            if (mouseevent.getClickCount() == 2) {
                CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.getSelectedValue();
                this.onCheck2Item(checkboxandlabel);
            }
            if (point.x > 0 && point.x < MyListCellRenderer.iconWidth && mouseevent.getClickCount() == 1) {
                CheckBoxAndLabel checkboxandlabel1;
                checkboxandlabel1.setSelected(!(checkboxandlabel1 = (CheckBoxAndLabel)this.getSelectedValue()).IsChecked());
                this.onCheckItem(checkboxandlabel1);
                this.repaint();
            }
        }
        if (mouseevent.getModifiers() == 4) {
            CheckBoxAndLabel checkboxandlabel2 = (CheckBoxAndLabel)this.getSelectedValue();
            this.onCheck3Item(checkboxandlabel2, mouseevent);
        }
    }

    private void list_mousePressed(MouseEvent mouseevent) {
        this.dragSel = this.getLeadSelectionIndex();
        if (this.dragSel == -1) {
            return;
        }
        this.dragCellBounds = this.getCellBounds(this.dragSel, this.dragSel);
    }

    private void list_mouseReleased(MouseEvent mouseevent) {
        if (this.isDraging && this.desSel != -1) {
            if (this.desSel != this.dragSel && this.desSel != this.dragSel + 1) {
                CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(this.dragSel);
                this.model.removeElementAt(this.dragSel);
                if (this.model.getSize() + 1 == this.desSel) {
                    this.model.addElement(checkboxandlabel);
                    this.setSelectedIndex(this.desSel - 1);
                } else if (this.desSel > this.dragSel) {
                    this.model.insertElementAt(checkboxandlabel, this.desSel - 1);
                    this.setSelectedIndex(this.desSel - 1);
                } else {
                    this.model.insertElementAt(checkboxandlabel, this.desSel);
                    this.setSelectedIndex(this.desSel);
                }
                this.dragSel = -1;
                this.desSel = -1;
                this.isDraging = false;
            }
            this.isDraging = false;
            this.desSel = -1;
        }
        this.repaint();
    }

    private void list_mouseDragged(MouseEvent mouseevent) {
        if (!this.canDraging) {
            return;
        }
        this.mousePos = mouseevent.getPoint();
        this.setSelectedIndex(this.dragSel);
        this.isDraging = true;
        this.desSel = this.locationToIndex(this.mousePos);
        int i = this.model.getSize();
        if (this.mousePos.y > i * this.getFixedCellHeight() && this.desSel == -1) {
            this.desSel = i;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.dragSel != -1 && this.isDraging && this.mousePos != null) {
            int i = this.desSel * this.getFixedCellHeight();
            g.setColor(Color.pink);
            g.drawLine(0, i, this.getWidth(), i);
            g.drawLine(0, i + 1, this.getWidth(), i + 1);
        }
    }

    public CheckBoxAndLabel getCheckBoxAndLabel(int i) {
        return (CheckBoxAndLabel)this.model.elementAt(i);
    }

    public Vector getSelKeyWord() {
        Vector<String> vector = new Vector<String>();
        int i = 0;
        while (i < this.model.getSize()) {
            CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
            if (checkboxandlabel.IsChecked()) {
                vector.addElement(checkboxandlabel.getKeyword());
            }
            ++i;
        }
        return vector;
    }

    public Vector getSelLabel() {
        Vector<String> vector = new Vector<String>();
        int i = 0;
        while (i < this.model.getSize()) {
            CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
            if (checkboxandlabel.IsChecked()) {
                vector.addElement(checkboxandlabel.getLabel());
            }
            ++i;
        }
        return vector;
    }

    public void onKeyPressed(KeyEvent keyevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public String onCheckItem(CheckBoxAndLabel checkboxandlabel) {
        return checkboxandlabel.getLabel();
    }

    public String onCheck2Item(CheckBoxAndLabel checkboxandlabel) {
        return checkboxandlabel.getLabel();
    }

    public String onCheck3Item(CheckBoxAndLabel checkboxandlabel, MouseEvent mouseevent) {
        return checkboxandlabel.getLabel();
    }

    public void removeAllItem() {
        this.model.removeAllElements();
        this.repaint();
    }

    public void removeElementAt(int i) {
        this.model.removeElementAt(i);
        this.repaint();
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public int getItemIndex(String s) {
        int i = 0;
        while (i < this.model.getSize()) {
            CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
            if (checkboxandlabel.getKeyword().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getItemText(int i) {
        CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
        return String.valueOf(checkboxandlabel.getLabel()) + (!this.isSorticon ? "" : "," + checkboxandlabel.getUseUpdown());
    }

    public String getItemText2(int i) {
        CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
        return checkboxandlabel.getLabel2();
    }

    public boolean isItemChecked(int i) {
        CheckBoxAndLabel checkboxandlabel = (CheckBoxAndLabel)this.model.elementAt(i);
        return checkboxandlabel.IsChecked();
    }
}

