/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.CacheImageLoader;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class DownloadWindow
extends WindowAdapter
implements ActionListener,
LaunchDownload.DownloadProgress,
CacheImageLoaderCallback {
    private JFrame _frame = null;
    private String _title;
    private String _vendor;
    private long _estimatedDownloadSize = 0L;
    private long _totalDownloadedBytes = 0L;
    private URL _currentUrl = null;
    static final int TIMER_UPDATE_RATE = 1000;
    static final int TIMER_INITIAL_DELAY = 10;
    static final int TIMER_AVERAGE_SIZE = 10;
    Timer _timerObject = null;
    long[] _timerDownloadAverage = new long[10];
    int _timerCount = 0;
    long _timerLastBytesCount = 0L;
    boolean _timerOn = false;
    static final int HEART_BEAT_RATE = 250;
    static final boolean[] HEART_BEAT_RYTHM = new boolean[]{false, false, false, true, false, true};
    Timer _heartbeatTimer = null;
    Object _heartbeatLock = new Object();
    int _heartbeatCount = 0;
    boolean _heartbeatOn = false;
    boolean _isCanceled = false;
    boolean _exitOnCancel = true;
    private Image _appImage;
    private JButton _cancelButton = null;
    private JLabel _titleLabel = null;
    private JLabel _vendorLabel = null;
    private JLabel _infoStatus = null;
    private JLabel _infoProgressTxt = null;
    private JLabel _infoEstimatedTime = null;
    private JProgressBar _infoProgressBar = null;
    private JLabel _imageLabel = null;
    private static final int _yRestriction = 20;
    private static final int MAX_DISPLAY = 20;
    private static final String LEAD = "...";
    private DefaultBoundedRangeModel _loadingModel;
    private ActionListener _cancelActionListener;

    public DownloadWindow() {
    }

    public void buildIntroScreen() {
        this._frame = GeneralUtilities.createFrame(Resources.getString("appname"));
        this._frame.setResizable(false);
        this._frame.addWindowListener(this);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(null);
        jLabel.setLayout(null);
        Container container = this._frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jLabel, "Center");
        int n = 455;
        int n2 = 8;
        int n3 = 215 + 2 * n2;
        int n4 = n2;
        int n5 = 162 + n4;
        container.setBounds(0, 0, n, n3);
        this._frame.addNotify();
        Insets insets = this._frame.getInsets();
        JLabel jLabel2 = new JLabel();
        jLabel2.setBorder(new CompoundBorder(new LineBorder(Color.black), new BevelBorder(1)));
        jLabel2.setLayout(null);
        jLabel2.setBackground(Color.white);
        jLabel2.setOpaque(true);
        jLabel2.setBounds(5, n4, 433, 156);
        jLabel.add(jLabel2);
        Color color = Color.black;
        Font font = new Font("SansSerif", 1, 22);
        Font font2 = new Font("SansSerif", 1, 18);
        Color color2 = Color.black;
        Font font3 = new Font("SansSerif", 0, 14);
        this._titleLabel = new JLabel(this._title);
        this._titleLabel.setVerticalTextPosition(1);
        this._titleLabel.setFont(font);
        this._titleLabel.setForeground(color);
        this._titleLabel.setOpaque(false);
        this._titleLabel.setBounds(86, 14, n - 20 - 86, 30);
        jLabel2.add(this._titleLabel);
        this._vendorLabel = new JLabel(this._vendor);
        this._vendorLabel.setVerticalTextPosition(1);
        this._vendorLabel.setFont(font2);
        this._vendorLabel.setForeground(color);
        this._vendorLabel.setOpaque(false);
        this._vendorLabel.setBounds(86, 44, n - 20 - 86, 30);
        jLabel2.add(this._vendorLabel);
        this._cancelButton = new JButton(Resources.getString("launch.cancel"));
        this._cancelActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadWindow.this.cancelAction();
            }
        };
        this._cancelButton.addActionListener(this._cancelActionListener);
        Dimension dimension = this._cancelButton.getPreferredSize();
        this._cancelButton.setBounds(366, n5, dimension.width, dimension.height);
        jLabel.add(this._cancelButton);
        this._loadingModel = new DefaultBoundedRangeModel(0, 1, 0, 100);
        this._infoStatus = new JLabel(Resources.getString("launch.initializing", this._title, this._vendor));
        this._infoStatus.setBounds(10, 79, n - 10 - 20, 22);
        this._infoStatus.setForeground(color2);
        this._infoStatus.setOpaque(false);
        this._infoStatus.setFont(font3);
        this._infoProgressTxt = new JLabel(" ");
        this._infoProgressTxt.setOpaque(false);
        this._infoProgressTxt.setForeground(color2);
        this._infoProgressTxt.setFont(font3);
        this._infoProgressTxt.setBounds(10, 101, n - 10 - 20, 22);
        this._infoEstimatedTime = new JLabel("");
        this._infoEstimatedTime.setOpaque(false);
        this._infoEstimatedTime.setForeground(color2);
        this._infoEstimatedTime.setFont(font3);
        this._infoEstimatedTime.setBounds(10, 123, n - 10 - 20, 22);
        this._infoProgressBar = new JProgressBar(this._loadingModel);
        this._infoProgressBar.setBackground(Color.white);
        this._infoProgressBar.setForeground(new Color(131, 171, 239));
        this._infoProgressBar.setOpaque(true);
        this._infoProgressBar.setBorderPainted(true);
        Dimension dimension2 = this._infoProgressBar.getPreferredSize();
        this._infoProgressBar.setBounds(5, n5 + 6, 350, (int)dimension2.getHeight());
        jLabel2.add(this._infoStatus);
        jLabel2.add(this._infoProgressTxt);
        jLabel2.add(this._infoEstimatedTime);
        jLabel.add(this._infoProgressBar);
        this._infoProgressBar.setVisible(true);
        this._imageLabel = new JLabel();
        this._imageLabel.setOpaque(false);
        this._imageLabel.setBackground(Color.white);
        this._imageLabel.setBounds(10, 10, 64, 64);
        this.updateImage(GeneralUtilities.getDefaultImage().getImage(), false);
        jLabel2.add(this._imageLabel);
        Rectangle rectangle = new Rectangle(0, 0, n, n3);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        rectangle.width = Math.min(dimension3.width, rectangle.width);
        rectangle.height = Math.min(dimension3.height, rectangle.height);
        this._frame.setBounds((dimension3.width - rectangle.width) / 2, (dimension3.height - rectangle.height) / 2, rectangle.width, rectangle.height);
        this.setIndeterminedProgressBar(true);
    }

    private void cancelAction() {
        if (this._exitOnCancel) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Main.systemExit(-1);
                    return null;
                }
            });
        } else {
            this._isCanceled = true;
        }
    }

    void clearWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearWindowHelper();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DownloadWindow.this.clearWindowHelper();
                    }
                });
            }
            catch (Exception exception) {
                Debug.ignoredException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWindowHelper() {
        if (this._timerObject != null) {
            this._timerObject.stop();
            this._timerObject = null;
            this._timerDownloadAverage = null;
        }
        if (this._heartbeatTimer != null) {
            Object object = this._heartbeatLock;
            synchronized (object) {
                this._heartbeatTimer.stop();
                this._heartbeatTimer = null;
            }
        }
        if (this._frame != null) {
            this._infoStatus = null;
            this._infoProgressTxt = null;
            this._infoProgressBar = null;
            this._loadingModel = null;
            this._infoEstimatedTime = null;
            this._cancelButton.removeActionListener(this._cancelActionListener);
            this._cancelButton = null;
            this._cancelActionListener = null;
            this._frame.getContentPane().removeAll();
        }
    }

    void disposeWindow() {
        if (this._frame != null) {
            this.clearWindow();
            this._frame.removeWindowListener(this);
            this._frame.setVisible(false);
            this._frame.dispose();
            this._frame = null;
        }
    }

    void reset() {
        this.setStatus(null);
        this.setProgressText(null);
        this.setProgressBarVisible(false);
    }

    public void resetCancled() {
        this._isCanceled = false;
    }

    public void resetDownloadTimer() {
        this._timerCount = 0;
        this._timerLastBytesCount = 0L;
    }

    public void showLoadingProgressScreen() {
        this.setStatus(Resources.getString("launch.progressScreen"));
        this._timerObject = new Timer(1000, this);
        this._timerObject.start();
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public void setProgressBarValue(int n) {
        if (this._heartbeatOn) {
            this.setIndeterminedProgressBar(false);
        }
        this._loadingModel.setValue(n);
        this.setProgressBarVisible(n != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndeterminedProgressBar(boolean bl) {
        if (this._heartbeatTimer == null) {
            this._heartbeatTimer = new Timer(250, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = DownloadWindow.this._heartbeatLock;
                    synchronized (object) {
                        if (DownloadWindow.this._heartbeatOn && DownloadWindow.this._heartbeatTimer != null) {
                            DownloadWindow.this._heartbeatCount = (DownloadWindow.this._heartbeatCount + 1) % HEART_BEAT_RYTHM.length;
                            boolean bl = HEART_BEAT_RYTHM[DownloadWindow.this._heartbeatCount];
                            if (bl) {
                                DownloadWindow.this._loadingModel.setValue(100);
                            } else {
                                DownloadWindow.this._loadingModel.setValue(0);
                            }
                        }
                    }
                }
            });
        }
        Object object = this._heartbeatLock;
        synchronized (object) {
            if (bl) {
                this.setProgressBarVisible(true);
                this._loadingModel.setValue(0);
                this._heartbeatTimer.start();
                this._heartbeatOn = true;
            } else {
                this.setProgressBarVisible(false);
                this._heartbeatTimer.stop();
                this._heartbeatOn = false;
            }
        }
    }

    public void setProgressBarVisible(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoProgressBar != null) {
                    DownloadWindow.this._infoProgressBar.setVisible(bl);
                }
            }
        });
    }

    public DownloadWindow(LaunchDesc launchDesc, boolean bl) {
        this.setLaunchDesc(launchDesc, bl);
    }

    void setLaunchDesc(LaunchDesc launchDesc, boolean bl) {
        IconDesc iconDesc;
        InformationDesc informationDesc = launchDesc.getInformation();
        this._title = informationDesc.getTitle();
        this._vendor = informationDesc.getVendor();
        if (this._titleLabel != null) {
            this._titleLabel.setText(this._title);
            this._vendorLabel.setText(this._vendor);
        }
        this._isCanceled = false;
        this._exitOnCancel = bl;
        if (informationDesc != null && (iconDesc = informationDesc.getIconLocation(2, 0)) != null) {
            CacheImageLoader.getInstance().loadImage(iconDesc, this);
        }
    }

    private void setAppImage(Image image) {
        this.updateImage(image, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(Image image, boolean bl) {
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if ((n != 64 || n2 != 64) && n != 48 && n2 != 48) {
                int n3 = 64;
                if (n2 > n && n2 < 2 * n) {
                    n3 = 64 * n / n2;
                }
                BufferedImage bufferedImage = new BufferedImage(64, 64, 1);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                try {
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, 64, 64);
                    graphics.drawImage(image, (64 - n3) / 2, 0, n3, 64, null);
                    Object var10_9 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    graphics.dispose();
                    throw throwable;
                }
                image = bufferedImage;
            }
        }
        DownloadWindow downloadWindow = this;
        synchronized (downloadWindow) {
            if (this._appImage == null || bl) {
                this._appImage = image;
            }
        }
        if (this._imageLabel != null) {
            if (this._appImage != null) {
                this._imageLabel.setIcon(new ImageIcon(this._appImage));
                this._imageLabel.setOpaque(true);
            } else {
                this._imageLabel.setIcon(null);
                this._imageLabel.setOpaque(false);
            }
            this._imageLabel.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._timerOn) {
            return;
        }
        if (this._estimatedDownloadSize <= 0L) {
            return;
        }
        long l = this._totalDownloadedBytes - this._timerLastBytesCount;
        this._timerLastBytesCount = this._totalDownloadedBytes;
        this._timerDownloadAverage[this._timerCount % 10] = l;
        if (this._totalDownloadedBytes > this._estimatedDownloadSize) {
            this._estimatedDownloadSize = this._totalDownloadedBytes;
        }
        if (this._timerCount > 10) {
            float f = 0.0f;
            int n = 0;
            while (n < 10) {
                f += (float)this._timerDownloadAverage[n];
                ++n;
            }
            f /= 10.0f;
            if ((f /= 1.0f) == 0.0f) {
                this.setEstimatedTime(Resources.getString("launch.stalledDownload"));
            } else if (this._estimatedDownloadSize > 0L) {
                int n2 = (int)((float)(this._estimatedDownloadSize - this._totalDownloadedBytes) / f);
                int n3 = n2 / 3600;
                int n4 = (n2 -= n3 * 3600) / 60;
                int n5 = n2 -= n4 * 60;
                this.setEstimatedTime(Resources.getString("launch.estimatedTimeLeft", n3, n4, n5));
            }
        }
        ++this._timerCount;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancelAction();
    }

    private String bytesToString(long l) {
        String string = "";
        double d = l;
        int n = 0;
        if (l > 0x40000000L) {
            d /= 1.073741824E9;
            string = "G";
            n = 1;
        } else if (l > 0x100000L) {
            d /= 1048576.0;
            string = "M";
            n = 1;
        } else if (l > 1024L) {
            d /= 1024.0;
            string = "K";
            n = 0;
        }
        return Resources.formatDouble(d, n) + string;
    }

    private void setEstimatedTime(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoEstimatedTime != null) {
                    if (string != null) {
                        DownloadWindow.this._infoEstimatedTime.setText(string);
                    }
                    DownloadWindow.this._infoEstimatedTime.setVisible(string != null);
                }
            }
        });
    }

    public void setProgressText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoProgressTxt != null) {
                    DownloadWindow.this._infoProgressTxt.setVisible(string != null);
                    DownloadWindow.this._infoProgressTxt.setText(string);
                }
            }
        });
    }

    public void setStatus(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoStatus != null) {
                    DownloadWindow.this._infoStatus.setVisible(string != null);
                    DownloadWindow.this._infoStatus.setText(string);
                }
            }
        };
        if (this._infoStatus.isShowing()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    void showLaunchingApplication(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._loadingModel != null) {
                    DownloadWindow.this._infoStatus.setText(string);
                    DownloadWindow.this._infoProgressTxt.setVisible(false);
                    DownloadWindow.this._infoEstimatedTime.setVisible(false);
                    DownloadWindow.this._loadingModel.setValue(0);
                }
            }
        });
    }

    public void extensionDownload(String string, int n) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        if (string != null) {
            this.setStatus(Resources.getString("launch.extensiondownload-name", string, n));
        } else {
            this.setStatus(Resources.getString("launch.extensiondownload", string, n));
        }
    }

    private void loadingFromNet(URL uRL, int n, int n2) {
    }

    public JFrame getFrame() {
        return this._frame;
    }

    private String maxDisplay(String string) {
        int n = string.length();
        if (n > 20) {
            string = LEAD + string.substring(n - (20 - LEAD.length()), n);
        }
        return string;
    }

    public void downloadFailed(URL uRL, String string) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        this.setStatus(Resources.getString("launch.loadingResourceFailedSts", uRL.toString()));
        this.setProgressText(Resources.getString("launch.loadingResourceFailed"));
        this.setProgressBarVisible(false);
    }

    public void patching(URL uRL, String string, int n, int n2) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        if (this._currentUrl != uRL || n == 0) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n3 = string3.lastIndexOf(47);
            if (n3 != -1) {
                string3 = string3.substring(n3 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(Resources.getString("launch.patchingStatus", string3, string2));
            this._currentUrl = uRL;
        }
        this.setProgressText(null);
        this.setProgressBarValue(n2);
    }

    public void progress(URL uRL, String string, long l, long l2, int n) {
        this._timerOn = true;
        this._totalDownloadedBytes = Math.max(0L, l);
        this._estimatedDownloadSize = l2;
        if (uRL != this._currentUrl && uRL != null) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n2 = string3.lastIndexOf(47);
            if (n2 != -1) {
                string3 = string3.substring(n2 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(Resources.getString("launch.loadingNetStatus", string3, string2));
            this._currentUrl = uRL;
        }
        if (l2 == -1L) {
            this.setProgressText(Resources.getString("launch.loadingNetProgress", this.bytesToString(this._totalDownloadedBytes)));
        } else {
            this.setProgressText(Resources.getString("launch.loadingNetProgressPercent", this.bytesToString(this._totalDownloadedBytes), this.bytesToString(l2), new Long(Math.max(0, n)).toString()));
            this.setProgressBarValue(n);
        }
    }

    public void validating(URL uRL, String string, long l, long l2, int n) {
        long l3;
        this._timerOn = false;
        this.setEstimatedTime(null);
        long l4 = l3 = l2 == 0L ? 0L : l * 100L / l2;
        if (this._currentUrl != uRL || l == 0L) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n2 = string3.lastIndexOf(47);
            if (n2 != -1) {
                string3 = string3.substring(n2 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(Resources.getString("launch.validatingStatus", string3, string2));
            this._currentUrl = uRL;
        }
        if (l != 0L) {
            this.setProgressText(Resources.getString("launch.validatingProgress", (int)l3));
        } else {
            this.setProgressText(null);
        }
        this.setProgressBarValue(n);
    }

    public void jreDownload(String string, URL uRL) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        String string2 = uRL.getHost();
        string2 = this.maxDisplay(string2);
        this.setStatus(Resources.getString("launch.downloadingJRE", string, string2));
    }

    public void finalImageAvailable(IconDesc iconDesc, Image image, File file) {
    }

    public void imageAvailable(IconDesc iconDesc, Image image, File file) {
        this.updateImage(image, true);
    }
}

