/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.Resources;
import com.sun.javaws.ui.player.JNLEntry;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class EntryManager {
    public static final int LOADED = 0;
    public static final int LOADING = 1;
    private SwingPropertyChangeSupport _changeSupport;
    private int _selectedIndex = -1;
    private EventListenerList _listenerList = new EventListenerList();
    private ChangeEvent _changeEvent;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getState() {
        return 0;
    }

    public abstract int size();

    protected void fireStateChanged() {
        Object[] objectArray = this._listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? EntryManager.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this._changeEvent == null) {
                    this._changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this._changeEvent);
            }
            n -= 2;
        }
    }

    public abstract void refresh();

    public void save() {
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canRemove() {
        return false;
    }

    public void remove(int n) {
        if (this.getSelectedIndex() >= this.size()) {
            this.setSelectedIndex(this.size() - 1);
        }
        this.fireStateChanged();
    }

    public void setSelectedIndex(int n) {
        int n2 = this._selectedIndex;
        this._selectedIndex = n;
        this.firePropertyChange("selectedIndex", n2, n);
    }

    public JNLEntry getSelectedEntry() {
        int n = this.getSelectedIndex();
        if (n >= 0 && n < this.size()) {
            return this.get(n);
        }
        return null;
    }

    public abstract JNLEntry get(int var1);

    public void add(int n, JNLEntry jNLEntry) {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new SwingPropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public String getDescription() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        string = "player." + string + ".label";
        return Resources.getString(string);
    }

    public String getRemoveString() {
        return null;
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (this._changeSupport != null && n != n2) {
            this._changeSupport.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    public void selectEntryWithCodebase(URL uRL) {
        if (uRL != null) {
            String string = uRL.toExternalForm();
            int n = this.size() - 1;
            while (n >= 0) {
                JNLEntry jNLEntry = this.get(n);
                if (jNLEntry != null && jNLEntry.getCodebase() != null && string.equals(jNLEntry.getCodebase().toExternalForm())) {
                    this.setSelectedIndex(n);
                    break;
                }
                --n;
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = EntryManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = EntryManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, object, object2);
        }
    }
}

