/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import javax.crypto.SunJCE_b;
import javax.crypto.SunJCE_g;
import javax.crypto.SunJCE_m;
import javax.crypto.SunJCE_o;
import javax.crypto.SunJCE_p;
import javax.crypto.SunJCE_t;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private Provider a;
    private CipherSpi b;
    private String c;
    private SunJCE_m d;
    private ExemptionMechanism e;
    private boolean f = false;
    private int g = 0;
    private static final String h = "2.5.29.15";
    static /* synthetic */ Class i;
    static /* synthetic */ Class j;
    static /* synthetic */ Class k;
    static /* synthetic */ Class l;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.b = cipherSpi;
        this.a = provider;
        this.c = string;
    }

    Cipher(CipherSpi cipherSpi, Provider provider, SunJCE_m sunJCE_m, ExemptionMechanism exemptionMechanism, Boolean bl, String string) {
        this(cipherSpi, provider, string);
        this.d = sunJCE_m;
        this.e = exemptionMechanism;
    }

    private static String[] a(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("No transformation given");
        }
        String[] stringArray = new String[3];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n < 3) {
                stringArray[n++] = stringTokenizer.nextToken().trim();
            }
            if (n == 0 || n == 2 || stringTokenizer.hasMoreTokens()) {
                throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchAlgorithmException("Invalid transformation format:" + string);
        }
        if (stringArray[0] == null || stringArray[0].equals("")) {
            throw new NoSuchAlgorithmException("Invalid transformation:algorithm not specified-" + string);
        }
        return stringArray;
    }

    private static Cipher a(String[] stringArray, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = null;
        int n = 4;
        if (stringArray[1] == null || stringArray[1].equals("")) {
            n -= 2;
        }
        if (stringArray[2] == null || stringArray[2].equals("")) {
            --n;
        }
        switch (n) {
            case 4: {
                try {
                    objectArray = SunJCE_b.a(stringArray[0] + "/" + stringArray[1] + "/" + stringArray[2], "Cipher", provider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    try {
                        objectArray = SunJCE_b.a(stringArray[0] + "/" + stringArray[1], "Cipher", provider);
                        bl2 = true;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        try {
                            objectArray = SunJCE_b.a(stringArray[0] + "//" + stringArray[2], "Cipher", provider);
                            bl = true;
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                            objectArray = SunJCE_b.a(stringArray[0], "Cipher", provider);
                            bl = true;
                            bl2 = true;
                        }
                    }
                }
                break;
            }
            case 3: {
                try {
                    objectArray = SunJCE_b.a(stringArray[0] + "/" + stringArray[1], "Cipher", provider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    objectArray = SunJCE_b.a(stringArray[0], "Cipher", provider);
                    bl = true;
                }
                break;
            }
            case 2: {
                try {
                    objectArray = SunJCE_b.a(stringArray[0] + "//" + stringArray[2], "Cipher", provider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    objectArray = SunJCE_b.a(stringArray[0], "Cipher", provider);
                    bl2 = true;
                }
                break;
            }
            case 1: {
                objectArray = SunJCE_b.a(stringArray[0], "Cipher", provider);
            }
        }
        Cipher cipher = new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], (SunJCE_m)objectArray[2], (ExemptionMechanism)objectArray[3], (Boolean)objectArray[4], string);
        if (bl) {
            cipher.b.engineSetMode(stringArray[1]);
        }
        if (bl2) {
            cipher.b.engineSetPadding(stringArray[2]);
        }
        return cipher;
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] stringArray = Cipher.a(string);
        Cipher cipher = null;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length && cipher == null; ++i) {
            try {
                cipher = Cipher.a(stringArray, string, providerArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cipher == null) {
            throw new NoSuchAlgorithmException("Cannot find any provider supporting " + string);
        }
        return cipher;
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        String[] stringArray = Cipher.a(string);
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Missing provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("Provider '" + string2 + "' not found");
        }
        return Cipher.a(stringArray, string, provider);
    }

    public static final Cipher getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] stringArray = Cipher.a(string);
        if (provider == null) {
            throw new IllegalArgumentException("Missing provider");
        }
        return Cipher.a(stringArray, string, provider);
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final String getAlgorithm() {
        return this.c;
    }

    public final int getBlockSize() {
        return this.b.engineGetBlockSize();
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        return this.b.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        return this.b.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this.b.engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return this.e;
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, SunJCE_b.b);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, secureRandom);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d == null) {
            SunJCE_g sunJCE_g = (SunJCE_g)AccessController.doPrivileged(new SunJCE_p(this));
            if (!sunJCE_g.a()) {
                throw new NullPointerException();
            }
        } else if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, algorithmParameterSpec, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, algorithmParameterSpec, SunJCE_b.b);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, algorithmParameterSpec, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d == null) {
            SunJCE_g sunJCE_g = (SunJCE_g)AccessController.doPrivileged(new SunJCE_o(this));
            if (!sunJCE_g.a()) {
                throw new NullPointerException();
            }
        } else if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.a(algorithmParameters);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
            }
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, algorithmParameterSpec, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, algorithmParameters, SunJCE_b.b);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize(key);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.a(algorithmParameters);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
            }
            if (!this.d.implies(new SunJCE_m(key.getAlgorithm(), n2, algorithmParameterSpec, this.d.b()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(this.e.getName() + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n, key, algorithmParameters, secureRandom);
        this.f = true;
        this.g = n;
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, SunJCE_b.b);
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set<String> set;
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains(h) && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && (n == 1 && blArray.length > 3 && !blArray[3] || n == 3 && blArray.length > 2 && !blArray[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        serializable = certificate.getPublicKey();
        if (this.d != SunJCE_t.b) {
            int n2 = this.b.engineGetKeySize((Key)serializable);
            if (!this.d.implies(new SunJCE_m(serializable.getAlgorithm(), n2))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
        }
        this.b.engineInit(n, (Key)serializable, secureRandom);
        this.f = true;
        this.g = n;
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (byArray.length == 0) {
            return null;
        }
        return this.b.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return null;
        }
        return this.b.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.b.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.b.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return this.b.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.b.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        return this.b.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.b.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.b.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n < 0 || n2 > byArray.length - n || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.b.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.g != 3) {
            throw new IllegalStateException("Cipher not initialized for wrapping keys");
        }
        return this.b.engineWrap(key);
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.g != 4) {
            throw new IllegalStateException("Cipher not initialized for unwrapping keys");
        }
        if (n != 3 && n != 2 && n != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return this.b.engineUnwrap(byArray, string, n);
    }

    private AlgorithmParameterSpec a(AlgorithmParameters algorithmParameters) throws InvalidParameterSpecException {
        if (algorithmParameters == null) {
            return null;
        }
        String string = algorithmParameters.getAlgorithm().toUpperCase();
        if (string.equalsIgnoreCase("RC2")) {
            return algorithmParameters.getParameterSpec(i == null ? (i = Cipher.class$("javax.crypto.spec.RC2ParameterSpec")) : i);
        }
        if (string.equalsIgnoreCase("RC5")) {
            return algorithmParameters.getParameterSpec(j == null ? (j = Cipher.class$("javax.crypto.spec.RC5ParameterSpec")) : j);
        }
        if (string.startsWith("PBE")) {
            return algorithmParameters.getParameterSpec(k == null ? (k = Cipher.class$("javax.crypto.spec.PBEParameterSpec")) : k);
        }
        if (string.startsWith("DES")) {
            return algorithmParameters.getParameterSpec(l == null ? (l = Cipher.class$("javax.crypto.spec.IvParameterSpec")) : l);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

