/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import sun.plugin.security.CertificateStore;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;

public final class PluginCertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _deploymentcerts = null;

    static {
        _filename = UserProfile.getCertificateFile();
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("jpicertstore.cert.loading", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (PluginCertificateStore.this._deploymentcerts == null) {
                        PluginCertificateStore.this._deploymentcerts = KeyStore.getInstance("JKS");
                        PluginCertificateStore.this._deploymentcerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        PluginCertificateStore.this._deploymentcerts.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("jpicertstore.cert.loaded", new Object[]{_filename});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("jpicertstore.cert.saving", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    PluginCertificateStore.this._deploymentcerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("jpicertstore.cert.saved", new Object[]{_filename});
    }

    public KeyStore getKeyStore() {
        Trace.msgSecurityPrintln("jpicertstore.cert.getkeystore");
        return this._deploymentcerts;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpicertstore.cert.adding");
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentcerts.getCertificate(string = "deploymentcert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._deploymentcerts.setCertificateEntry(string, certificate);
            Trace.msgSecurityPrintln("jpicertstore.cert.added", new Object[]{string});
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpicertstore.cert.removing");
        String string = this._deploymentcerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentcerts.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("jpicertstore.cert.removed", new Object[]{string});
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("jpicertstore.cert.instore");
        String string = null;
        string = this._deploymentcerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("jpicertstore.cert.canverify");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.msgSecurityPrintln("jpicertstore.cert.iterator");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._deploymentcerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._deploymentcerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }
}

