GLOBAL.require "actions"
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe  
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local ACTIONS = GLOBAL.ACTIONS
local COLLISION = GLOBAL.COLLISION
local GetWorld = GLOBAL.GetWorld
local GROUND = GLOBAL.GROUND

Assets = {
    Asset("IMAGE", "images/inventoryimages/yiyu_pitchfork.tex"),
    Asset("ATLAS", "images/inventoryimages/yiyu_pitchfork.xml"),
}

PrefabFiles = {	"yiyu_pitchfork",}

function PostInit(inst)
if inst.components.keeponland then inst:RemoveComponent("keeponland") end
if inst and not inst.components.yiyu_keeponland then inst:AddComponent("yiyu_keeponland") end
local yiyu_pitchfork = GLOBAL.Recipe("yiyu_pitchfork", {Ingredient("pitchfork", 1), Ingredient("goldnugget", 2)}, RECIPETABS.REFINE, TECH.NONE )
yiyu_pitchfork.atlas = "images/inventoryimages/yiyu_pitchfork.xml"
end

if GLOBAL.LanguageTranslator.defaultlang == "chs" then
STRINGS.NAMES.YIYU_PITCHFORK = "填海草叉"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.YIYU_PITCHFORK = "千万注意!\n小心淹死!"
STRINGS.RECIPE_DESC.YIYU_PITCHFORK = "千万注意!\n小心淹死!"
else
STRINGS.NAMES.YIYU_PITCHFORK = "Sea reclamation fork"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.YIYU_PITCHFORK = "Be careful of drowning!"
STRINGS.RECIPE_DESC.YIYU_PITCHFORK = "Be careful of drowning!"
end

AddMinimapAtlas("images/inventoryimages/yiyu_pitchfork.xml")
AddSimPostInit(function(inst) PostInit(inst) end)
