local assets=
{
	Asset("ANIM", "anim/yiyu_pitchfork.zip"),
	Asset("ANIM", "anim/swap_yiyu_pitchfork.zip"),
	Asset("IMAGE", "images/inventoryimages/yiyu_pitchfork.tex"),
	Asset("ATLAS", "images/inventoryimages/yiyu_pitchfork.xml"),
}

local function onfinished(inst, owner)
    inst:Remove()
end

local function darktridentequip(inst, owner)
	inst.entity:AddAnimState():SetBuild("yiyu_pitchfork")
	owner.AnimState:OverrideSymbol("swap_object", "swap_yiyu_pitchfork", "swap_pitchfork")
	owner.AnimState:Show("ARM_carry") 
	owner.AnimState:Hide("ARM_normal")
    owner.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    owner.Physics:ClearCollisionMask()
    owner.Physics:CollidesWith(COLLISION.GROUND)
    owner.Physics:CollidesWith(COLLISION.OBSTACLES)
    owner.Physics:CollidesWith(COLLISION.CHARACTERS)
    owner:AddTag("amphibious")
    owner:AddTag("yiyu_pitchfork")
end

local function darktridentunequip(inst, owner) 
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal")
    owner:RemoveTag("amphibious")
    owner:RemoveTag("yiyu_pitchfork")
	ChangeToCharacterPhysics(owner)
end

local function IsWater(tile)
	return tile == GROUND.OCEAN_MEDIUM or 
		tile == GROUND.OCEAN_DEEP or 
		tile == GROUND.OCEAN_SHALLOW or
		tile == GROUND.OCEAN_SHORE or 
		tile == GROUND.OCEAN_CORAL or 
		tile == GROUND.OCEAN_CORAL_SHORE or 
		tile == GROUND.OCEAN_SHIPGRAVEYARD or
		tile == GROUND.MANGROVE or 
		tile == GROUND.MANGROVE_SHORE
end

local function yiyupitchfork(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)

	anim:SetBank("yiyu_pitchfork")
	anim:SetBuild("yiyu_pitchfork")
	anim:PlayAnimation("idle")

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(25)

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(100)
	inst.components.finiteuses:SetOnFinished( onfinished )

	inst:AddComponent("terraformer")
	inst.components.finiteuses:SetConsumption(ACTIONS.TERRAFORM, 1)
	inst:AddInherentAction(ACTIONS.TERRAFORM)

	local oldterraform = inst.components.terraformer.Terraform
	inst.components.terraformer.CanTerraformPoint = function(pt) return true end
    function inst.components.terraformer:Terraform(pt)
    local ground = GetWorld()
    if ground then
		local original_tile_type = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
		local x, y = ground.Map:GetTileCoordsAtPoint(pt.x, pt.y, pt.z)
		self.inst.components.finiteuses:Use(1)
		if original_tile_type == GROUND.BEACH then
			if x and y then ground.Map:SetTile(x,y, GROUND.OCEAN_SHALLOW) ground.Map:RebuildLayer( GROUND.OCEAN_SHALLOW, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.OCEAN_SHALLOW, x, y ) end
		elseif IsWater(original_tile_type) then
			if x and y then ground.Map:SetTile(x,y, GROUND.BEACH) ground.Map:RebuildLayer( GROUND.BEACH, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.BEACH, x, y ) end
		elseif original_tile_type == GROUND.VOLCANO_ROCK then
			if x and y then ground.Map:SetTile(x,y, GROUND.IMPASSABLE) ground.Map:RebuildLayer( GROUND.IMPASSABLE, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.IMPASSABLE, x, y ) end
		elseif original_tile_type == GROUND.VOLCANO_LAVA then
			if x and y then ground.Map:SetTile(x,y, GROUND.VOLCANO_ROCK) ground.Map:RebuildLayer( GROUND.VOLCANO_ROCK, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.VOLCANO_ROCK, x, y ) end
		elseif original_tile_type == GROUND.DIRT then
			if x and y then ground.Map:SetTile(x,y, GROUND.IMPASSABLE) ground.Map:RebuildLayer( GROUND.IMPASSABLE, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.IMPASSABLE, x, y ) end
		elseif original_tile_type == GROUND.ROAD then
			if x and y then ground.Map:SetTile(x,y, GROUND.DIRT) ground.Map:RebuildLayer( GROUND.DIRT, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.DIRT, x, y ) end
		elseif original_tile_type == GROUND.IMPASSABLE then
			if x and y then ground.Map:SetTile(x,y, GROUND.DIRT) ground.Map:RebuildLayer( GROUND.DIRT, x, y ) end
			local minimap = TheSim:FindFirstEntityWithTag("minimap")
			if minimap then minimap.MiniMap:RebuildLayer( GROUND.DIRT, x, y ) end
		else
            oldterraform(self, pt)
		end
	end
	end


	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "yiyu_pitchfork"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/yiyu_pitchfork.xml"

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( darktridentequip )
	inst.components.equippable:SetOnUnequip( darktridentunequip )

    inst:AddComponent("talker")
    inst.components.talker.fontsize = 24
	inst.components.talker.offset = Vector3(0,-800,0)
    inst.components.talker.colour = Vector3(0.75, 0.85, 1, 1)

	return inst
end

return Prefab( "common/inventory/yiyu_pitchfork", yiyupitchfork, assets, prefabs)
