require "behaviours/follow"
require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/panic"

local MIN_FOLLOW_DIST = 0
local TARGET_FOLLOW_DIST = 4
local MAX_FOLLOW_DIST = 8
local MAX_WANDER_DIST = 8

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8

local KEEP_WORKING_DIST = 10
local SEE_WORK_DIST = 15

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end


local FaitheBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)


function FaitheBrain:OnStart()
    local root = 
    PriorityNode({
        WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
        Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
        FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
       Wander(self.inst, function() return self.inst:GetPosition() end, MAX_WANDER_DIST),   
    }, .25)
    self.bt = BT(self.inst, root)
end

return FaitheBrain