
local Assets =
{
	Asset("ANIM", "anim/hat_warfarinhood.zip"),
}

local function perish(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner then
     owner:RemoveTag("notarget")
	end
	inst:Remove()
end

local function Hide(inst, data)
    local equippedArmor = inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
    if data.statename == "idle" or data.statename == "run_start" or data.statename == "run" or data.statename == "run_stop" or data.statename == "funnyidle" then
           inst:AddTag("notarget")
if IsDLCEnabled(REIGN_OF_GIANTS) then
    equippedArmor.components.equippable.dapperness = TUNING.CRAZINESS_SMALL
			else
    equippedArmor.components.dapperness.dapperness = TUNING.CRAZINESS_SMALL
		end
    equippedArmor.components.fueled:StartConsuming()        
    else
           inst:RemoveTag("notarget")
    equippedArmor.components.fueled:StopConsuming()        
if IsDLCEnabled(REIGN_OF_GIANTS) then
    equippedArmor.components.equippable.dapperness = TUNING.CRAZINESS_SMALL*0.4
			else
    equippedArmor.components.dapperness.dapperness = TUNING.CRAZINESS_SMALL*0.4
		end
    end
end

    local function onequip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_hat", "hat_warfarinhood", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        owner.AnimState:Hide("HAIR_PIGTAILS")
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD_HAT")
			owner.AnimState:Hide("HEAD")
		end
        
    inst:ListenForEvent("newstate", Hide, owner) 
    end


    local function onunequip(inst, owner)

        owner.AnimState:Hide("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
        owner.AnimState:Show("HAIR_PIGTAILS")
		if owner:HasTag("player") then
			owner.AnimState:Show("HEAD_HAT")
	        owner.AnimState:Show("HEAD")
		end

    inst:RemoveEventCallback("newstate", Hide, owner)
     owner:RemoveTag("notarget")
    inst.components.fueled:StopConsuming() 
    end

local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("footballhat")
        inst.AnimState:SetBuild("hat_warfarinhood")
        inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("sanity")
    inst:AddTag("warfarinhood")

        inst:AddComponent("inspectable")

  
        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_warfarinhood.xml"

	inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.INSULATION_MED

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst.components.equippable.walkspeedmult = 1.2
if IsDLCEnabled(REIGN_OF_GIANTS) then
        inst:AddComponent("waterproofer")
        inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
			else
    inst:AddComponent("dapperness")
		end

        inst:AddComponent("fueled")
        inst.components.fueled.fueltype = "USAGE"
        inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME)
        inst.components.fueled:SetDepletedFn(perish)

        inst.components.equippable:SetOnEquip( onequip )

        inst.components.equippable:SetOnUnequip( onunequip )

        return inst
end


return Prefab( "common/inventory/hat_warfarinhood", fn, Assets)


