local assets=
{
	Asset("ANIM", "anim/warfarin_arrows1.zip"),
	Asset("ANIM", "anim/warfarin_arrows2.zip"),
	Asset("ANIM", "anim/swap_warfarin_bow.zip"),
	Asset("ANIM", "anim/warfarin_bow.zip"),
	Asset("ANIM", "anim/ui_warfarinbow_1x4.zip"),
}
    
local prefabs =
{
	"warfarinbow_projectile",
	"warfarinbow_projectile_spike",
	"warfarinbow_projectile_rock",
	"warfarinbow_projectile_water",
	"warfarinbow_projectile_fire",
}

local function onattack_norm(inst, attacker, target)

	if inst.components.container:Has("warfarinarrow_normal", 1) then
    inst.components.container:ConsumeByName("warfarinarrow_normal", 1)
    end
end

local function onattack_rock(inst, attacker, target)

	if inst.components.container:Has("warfarinarrow_rock", 1) then
    inst.components.container:ConsumeByName("warfarinarrow_rock", 1)
    end
end

local function onattack_water(inst, attacker, target)

	if inst.components.container:Has("warfarinarrow_water", 1) then
    inst.components.container:ConsumeByName("warfarinarrow_water", 1)
    end
end

local function onattack_fire(inst, attacker, target)

	if inst.components.container:Has("warfarinarrow_fire", 1) then
    inst.components.container:ConsumeByName("warfarinarrow_fire", 1)
    end
end

local function onattack_spike(inst, attacker, target)

	if inst.components.container:Has("warfarinarrow_spike", 1) then
    inst.components.container:ConsumeByName("warfarinarrow_spike", 1)
    end
end

local function checkarrow(inst)

    local container = inst.components.container

    for i = 1, container:GetNumSlots() do
        local item = container:GetItemInSlot(i)
        
        if not item then
	inst.SoundEmitter:PlaySound("dontstarve/HUD/collect_resource")
		if inst.components.weapon then
    	inst:RemoveComponent("weapon")
    	inst:RemoveTag("rangedfireweapon")
    	inst:RemoveTag("firestaff")
    	inst:RemoveTag("extinguisher")
    	inst:RemoveTag("waterbow") 
    	inst:RemoveTag("rockbow")  
		end
		if inst.string then
    inst.string.AnimState:PlayAnimation("nil")
    inst.string.AnimState:ClearBloomEffectHandle()
		end
		if inst.components.heater then
        inst:RemoveComponent("heater")
		end
       	elseif item and item.prefab then

        if item.prefab == "warfarinarrow_normal" then
	inst.SoundEmitter:PlaySound("dontstarve/wilson/equip_item")
		if not inst.components.weapon then
    inst:AddTag("normbow")
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+2, TUNING.BOOMERANG_DISTANCE+2.5)
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetProjectile("warfarinbow_projectile")
    inst.components.weapon:SetOnProjectileLaunch(onattack_norm)
    --inst.components.weapon:SetOnAttack(onattack_norm)
			end
		if inst.string then
	inst.string.AnimState:SetBuild("warfarinbow_arrow")
    inst.string.AnimState:PlayAnimation("idle_1")
		end
        elseif item.prefab == "warfarinarrow_rock" then
                    inst.SoundEmitter:PlaySound("dontstarve/wilson/use_pick_rock")
		if not inst.components.weapon then
    inst:AddTag("rockbow") 
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+2, TUNING.BOOMERANG_DISTANCE+2.5)
    inst.components.weapon:SetDamage(0)
    inst:AddComponent("inspectable")
    inst.components.weapon:SetProjectile("warfarinbow_projectile_rock")
    inst.components.weapon:SetOnProjectileLaunch(onattack_rock)
    --inst.components.weapon:SetOnAttack(onattack_rock)
			end
		if inst.string then
	inst.string.AnimState:SetBuild("warfarinbow_arrow")
    inst.string.AnimState:PlayAnimation("idle_2")
		end
        elseif item.prefab == "warfarinarrow_water" then
	inst.SoundEmitter:PlaySound("dontstarve/winter/pondfreeze")
		if not inst.components.weapon then
    inst:AddTag("extinguisher")
    inst:AddTag("waterbow")  
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+2, TUNING.BOOMERANG_DISTANCE+2.5)
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetProjectile("warfarinbow_projectile_water")
    inst.components.weapon:SetOnProjectileLaunch(onattack_water)
    --inst.components.weapon:SetOnAttack(onattack_water)
			end
		if inst.string then
	inst.string.AnimState:SetBuild("warfarinbow_arrow")
    inst.string.AnimState:PlayAnimation("idle_3")
			end
	if not inst.components.heater then
        inst:AddComponent("heater")
        inst.components.heater.iscooler = true
        inst.components.heater.equippedheat = -10
		end
        elseif item.prefab == "warfarinarrow_fire" then
                    inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_firestaff")
		if not inst.components.weapon then
    inst:AddTag("rangedfireweapon")
    inst:AddTag("firebow")  
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+2, TUNING.BOOMERANG_DISTANCE+2.5)
    inst.components.weapon:SetDamage(0)
    inst:AddTag("firestaff")
    inst.components.weapon:SetProjectile("warfarinbow_projectile_fire")
    inst.components.weapon:SetOnProjectileLaunch(onattack_fire)
    --inst.components.weapon:SetOnAttack(onattack_fire)
			end
		if inst.string then
    inst.string.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
	inst.string.AnimState:SetBuild("warfarinbow_arrow2")
    inst.string.AnimState:PlayAnimation("idle_3")
			end
		if not inst.components.heater then
        inst:AddComponent("heater")
        inst.components.heater.iscooler = false
        inst.components.heater.equippedheat = 50
		end
        elseif item.prefab == "warfarinarrow_spike" then
	inst.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
		if not inst.components.weapon then 
    inst:AddTag("spikebow")  
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+2, TUNING.BOOMERANG_DISTANCE+2.5)
    inst.components.weapon:SetProjectile("warfarinbow_projectile_spike")
    inst.components.weapon:SetOnProjectileLaunch(onattack_spike)
    --inst.components.weapon:SetOnAttack(onattack_spike)
					end
		if inst.string then
	inst.string.AnimState:SetBuild("warfarinbow_arrow2")
    inst.string.AnimState:PlayAnimation("idle_1")
				end
			end
		end
        end
end

local function onopen(inst)
	inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_open", "open")
end 

local function itemtest(inst, item, slot)
	return item:HasTag("wararrow")
end

local function onclose(inst) 
	inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_close", "open")
end 

local slotpos = { Vector3(0,64+32+8+4,0) }

local slipupchance = 0.4

local widgetbuttoninfo = {
	text = "spikey Arrow: \n 1 Arrow\n 3 Hound Teeth \n Sharpen \n \n \n ",
	position = Vector3(0,-20-37,0),
	fn = function(inst)
	local player = GetPlayer()
	if inst.components.container:Has("warfarinarrow_normal", 1) and player.components.inventory:Has("houndstooth", 3) then
    inst.components.container:ConsumeByName("warfarinarrow_normal", 1)
    player.components.inventory:ConsumeByName("houndstooth", 3)
    local arrow = SpawnPrefab("warfarinarrow_spike")
	player.components.inventory:GiveItem(arrow)
	inst.SoundEmitter:PlaySound("dontstarve/HUD/collect_newitem")
            player.sg:GoToState("doshortaction")
    if math.random() < slipupchance then
        player.components.combat:GetAttacked(inst, 1)
	end
		else
           GetPlayer().components.talker:Say("...")
	inst.SoundEmitter:PlaySound("dontstarve/HUD/click_negative")
		end
	end,
	
}

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    --owner.components.inventory:SetOverflow(inst)
		inst.components.container.canbeopened = true
    inst.components.container:Open(owner)
		if not inst.string then
    inst.string = SpawnPrefab( "warfarinbowstring" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, 1 )
	end
  		  inst:DoTaskInTime(0.1, function(inst)
			checkarrow(inst)
		end)
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
    --owner.components.inventory:SetOverflow(nil)
		if inst.components.container then
		inst.components.container.canbeopened = false 
    inst.components.container:Close(owner)
		end
		if inst.string then 
	inst.string:Remove()
    inst.string = nil
		end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("bow")
    inst:AddTag("warwep")

    MakeInventoryPhysics(inst)

	inst.Transform:SetScale(1.2, 1.2, 1.2)
    inst.AnimState:SetBank("poop")
    inst.AnimState:SetBuild("warfarin_bow")
    inst.AnimState:PlayAnimation("idle")
  
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    ---------------------       
        inst:AddTag("nopunch")
    inst:AddTag("normbow")
    inst:AddTag("sharp")

    inst:AddComponent("container")
    inst.components.container.itemtestfn = itemtest
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_cookpot_1x4"
    inst.components.container.widgetanimbuild = "ui_warfarinbow_1x4"
if IsDLCEnabled(CAPY_DLC) then
    inst.components.container.widgetpos = Vector3(-400, -260, 0)
	else
    inst.components.container.widgetpos = Vector3(0, -260, 0)
	end
    inst.components.container.side_align_tip = 130
    inst.components.container.type = "bow"
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
		inst.components.container.canbeopened = false 

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    
    inst.components.finiteuses:SetOnFinished(function()
        if inst.components.container then
            inst.components.container:DropEverything()
            inst.components.container:Close()
            inst:RemoveComponent("container")
        end
		if inst.string then 
	inst.string:Remove()
    inst.string = nil
		end
    inst:Remove()
end)

    inst:DoTaskInTime(0.2, function(inst)
	inst:ListenForEvent("itemget", checkarrow)
	inst:ListenForEvent("itemlose", checkarrow)
	if inst.components.equippable.isequipped then
	local owner = inst.components.inventoryitem.owner
	checkarrow(inst)
    	inst.components.container:Close(owner)
    	inst.components.container:Open(owner)
		end
		end)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinbow.xml"
    
    return inst
end

return Prefab( "common/inventory/warfarinbow", fn, assets) 

