local assets =
{
	Asset("ANIM", "anim/warfarinbow_arrow.zip"),
	Asset("ANIM", "anim/warfarinbow_arrow2.zip"),
}

local function commonfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local light = inst.entity:AddLight()
    inst.Transform:SetFourFaced()
    anim:SetBank("nightmare_watch")
    anim:SetBuild("warfarinbow_arrow")
    anim:PlayAnimation("nil")
	inst.Transform:SetScale(1.2, 1.8, 1.2)
    
	inst:DoPeriodicTask(1/100, function()
        inst:FacePoint(GetPlayer().Transform:GetWorldPosition())
	end)

	inst.persists = false

    inst:AddTag("FX")
    inst:AddTag("NOCLICK")

    anim:SetFinalOffset(1)
    return inst
end

local function norm()
	local inst = commonfn()

    inst.AnimState:PlayAnimation("idle_1")
	return inst
end

local function rock()
	local inst = commonfn()

    inst.AnimState:PlayAnimation("idle_2")
	return inst
end

local function stringwater()
	local inst = commonfn()

    inst.AnimState:PlayAnimation("idle_3")

	return inst
end

local function explo()
	local inst = commonfn()

	inst.AnimState:SetBuild("warfarinbow_arrow2")
    inst.AnimState:PlayAnimation("idle_3")

	return inst
end

local function sharp()
	local inst = commonfn()

	inst.AnimState:SetBuild("warfarinbow_arrow2")
    inst.AnimState:PlayAnimation("idle_1")

	return inst
end

return Prefab( "common/fx/warfarinbowstring_normal", norm, assets), 
	Prefab( "common/fx/warfarinbowstring", commonfn, assets),   
	Prefab( "common/fx/warfarinbowstring_rock", rock, assets), 
	Prefab( "common/fx/warfarinbowstring_fire", explo, assets),   
	Prefab( "common/fx/warfarinbowstring_spike", sharp, assets), 
	Prefab( "common/fx/warfarinbowstring_water", stringwater, assets)
