local assets=
{

Asset("ANIM", "anim/tkl.zip"),
Asset("ANIM", "anim/swap_tkl.zip"),

	  Asset("IMAGE", "images/inventoryimages/tkl.tex"),
    Asset("ATLAS", "images/inventoryimages/tkl.xml"),


 Asset("ANIM", "anim/diviningrod_fx.zip"),
}

local prefabs =
{
    


    "dr_hot_loop",
    "dr_warmer_loop",
    "dr_warm_loop_2",
    "dr_warm_loop_1",
}



local EFFECTS = 
{
    hot = "dr_hot_loop",--{anim="hot_loop", tint=Vector3(181/255, 32/255, 32/255)},
    warmer = "dr_warmer_loop",--{anim="warmer_loop", tint=Vector3(255/255, 163/255, 26/255)},
    warm = "dr_warm_loop_2",--{anim="warm_loop", tint=Vector3(105/255, 182/255, 239/255)},
    cold = "dr_warm_loop_1",--{anim="warm_loop", tint=Vector3(105/255, 160/255, 255/255)},
}

local function FindClosestPart(inst)
local a = TUNING.a
local b = TUNING.b
local c = TUNING.c

    if inst.tracking_parts == nil then
        inst.tracking_parts = {}
        for k,v in pairs(Ents) do
            if v.prefab == a or v.prefab == b or v.prefab == c then
                table.insert(inst.tracking_parts, v)
            end
        end
    end

    if inst.tracking_parts then
        local closest = nil
        local closest_dist = nil
        for k,v in pairs(inst.tracking_parts) do
            if v:IsValid() and not v:IsInLimbo() then
                local dist = v:GetDistanceSqToInst(inst)
                if not closest_dist or dist < closest_dist then
                    closest = v
                    closest_dist = dist
                end
            end
        end

        return closest
    end

end

local function CheckTargetPiece(inst)
local a = TUNING.a
local b = TUNING.b
local c = TUNING.c
    if inst.components.equippable:IsEquipped() and inst.components.inventoryitem.owner then
        local intensity = 0
        local closeness = nil
        local fx = nil
        local target = FindClosestPart(inst) --FindEntity(inst, TUNING.DIVINING_MAXDIST, function(guy) return (guy.prefab == a or guy.prefab == b or guy.prefab == c) end)
        local nextpingtime = TUNING.DIVINING_DEFAULTPING
        if target then
            local distsq = inst.components.inventoryitem.owner:GetDistanceSqToInst(target)
            intensity = math.max(0, 1 - (distsq/(TUNING.DIVINING_MAXDIST*TUNING.DIVINING_MAXDIST) ))
            for k,v in ipairs(TUNING.DIVINING_DISTANCES) do
                closeness = v
                fx = EFFECTS[v.describe]

                if v.maxdist and distsq <= v.maxdist*v.maxdist then
                    nextpingtime = closeness.pingtime
                    break
                end
            end
        end

        if closeness ~= inst.closeness then
            inst.closeness = closeness
	        local desc = inst.components.inspectable:GetDescription(inst.components.inventoryitem.owner)
	        if desc then
	            inst.components.inventoryitem.owner.components.talker:Say(desc)
	        end
        end
        
        if fx then
            inst.effect = SpawnPrefab(fx)--PlayFX(Vector3(0,0,0), "diviningrod_fx", "diviningrod_fx", fx.anim, nil, nil, fx.tint or Vector3(1, 1, 1) )
            local follower = inst.effect.entity:AddFollower()
	        follower:FollowSymbol(inst.components.inventoryitem.owner.GUID, "swap_object", 75, -300, 1 )
	    end

        inst.SoundEmitter:PlaySound("dontstarve/common/diviningrod_ping", "ping")
        inst.SoundEmitter:SetParameter("ping", "intensity", intensity)
        inst.task = inst:DoTaskInTime(nextpingtime or 1, CheckTargetPiece)
    end 
end




local function onequip(inst, owner) 


    owner.AnimState:OverrideSymbol("swap_object", "swap_tkl", "swap_diviningrod")
	
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

if not inst.disabled then
        inst.closeness = nil 
        inst.tracking_parts = nil       
        inst.task = inst:DoTaskInTime(1, CheckTargetPiece)
    end


 

end

local function onunequip(inst, owner) 


 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 


 if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
    if inst.fx ~= nil then
        if inst.fx:IsValid() then
            inst.fx:Remove()
        end
        inst.fx = nil
    end
    inst.closeness = nil

end





local function describe(inst)
    if inst.components.equippable:IsEquipped() then
        if inst.closeness and inst.closeness.describe then
            return string.upper(inst.closeness.describe)
        end
        return "COLD"
    end
end

local function OnSave(inst, data)
    data.disabled = inst.disabled
end

local function OnLoad(inst, data)
    if data then
        inst.disabled = data.disabled
    end
end


local function fn(Sim)
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
  inst.entity:AddSoundEmitter()
 
	
    MakeInventoryPhysics(inst)
    MakeInventoryFloatable(inst, "idle_water", "dropped")
	
    inst.AnimState:SetBank("diviningrod")
    inst.AnimState:SetBuild("tkl")
    inst.AnimState:PlayAnimation("dropped")
 MakeInventoryPhysics(inst)

   
  inst:AddTag("diviningrod")
	
   


    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tkl.xml"
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )




	
	
     inst.OnSave = OnSave
    inst.OnLoad = OnLoad
    return inst
end

return Prefab( "common/inventory/tkl", fn, assets) 
