
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wx78.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/ufo.zip" ),
        Asset( "ANIM", "anim/ghost_ufo_build.zip" ),
}
local prefabs = {}
local start_inv = {
	-- Custom starting items
	"eyeturret_item"
}
local function applyupgrades(inst)
	local max_upgrades = 15
    inst.level = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil(TUNING.WX78_MIN_HUNGER + inst.level * (TUNING.WX78_MAX_HUNGER - TUNING.WX78_MIN_HUNGER) / max_upgrades)
	inst.components.health:SetMaxHealth(math.ceil(TUNING.WX78_MIN_HEALTH + inst.level * (TUNING.WX78_MAX_HEALTH - TUNING.WX78_MIN_HEALTH) / max_upgrades))
	inst.components.sanity.max = math.ceil(TUNING.WX78_MIN_SANITY + inst.level * (TUNING.WX78_MAX_SANITY - TUNING.WX78_MIN_SANITY) / max_upgrades)

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end
local function oneat(inst, food)
	
	if food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS then
		--give an upgrade!
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		
		-- MarkL Can't do this here, need to do it inside the component
		-- todo pax Move upgrade logic elsewhere.  
		--inst.HUD.controls.status.heart:PulseGreen()
		--inst.HUD.controls.status.stomach:PulseGreen()
		--inst.HUD.controls.status.brain:PulseGreen()
		
		--inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		--inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		--inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
		
	end
end
local function onpreload(inst, data)
    if data ~= nil and data.level ~= nil then
        inst.level = data.level
        applyupgrades(inst)
        --re-set these from the save data, because of load-order clipping issues
        if data.health and data.health.health then inst.components.health:SetCurrentHealth(data.health.health) end
        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
        inst.components.health:DoDelta(0)
        inst.components.hunger:DoDelta(0)
        inst.components.sanity:DoDelta(0)
    end
end
local function onsave(inst, data)
	data.level = inst.level > 0 and inst.level or nil
end
local function ondeath(inst)
    if inst.level > 0 then
        local dropgears = math.random(math.floor(inst.level / 3), math.ceil(inst.level / 2))
        if dropgears > 0 then
            for i = 1, dropgears do
                local gear = SpawnPrefab("gears")
                if gear ~= nil then
                    local x, y, z = inst.Transform:GetWorldPosition()
                    if gear.Physics ~= nil then
                        local speed = 2 + math.random()
                        local angle = math.random() * 2 * PI
                        gear.Transform:SetPosition(x, y + 1, z)
                        gear.Physics:SetVel(speed * math.cos(angle), speed * 3, speed * math.sin(angle))
                    else
                        gear.Transform:SetPosition(x, y, z)
                    end
                    if gear.components.propagator ~= nil then
                        gear.components.propagator:Delay(5)
                    end
                end
            end
        end
        inst.level = 0
        applyupgrades(inst)
    end
end
-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- choose which sounds this character will play
	inst.soundsname = "wx78"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "ufo.tex" )
end

-- This initializes for the host only
local master_postinit = function(inst)
	-- Stats	
	inst.level = 0

	inst.components.eater.ignoresspoilage = true
    inst.components.eater:SetCanEatGears()
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	
    inst:ListenForEvent("death", ondeath)
	
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

end

return MakePlayerCharacter("ufo", prefabs, assets, common_postinit, master_postinit, start_inv)
