

PrefabFiles = {
	"mybackpack",
	"toadstool_sack",
}
Assets = {
	Asset( "ATLAS", "images/inventoryimages/toadstool_sack.xml" ),
	Asset("IMAGE", "images/inventoryimages/toadstool_sack.tex"), 
	Asset( "ATLAS", "images/inventoryimages/rivercrab_backpack.xml" ),
	Asset("IMAGE", "images/inventoryimages/rivercrab_backpack.tex"), 
}
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local TECH = GLOBAL.TECH
local STRINGS = GLOBAL.STRINGS
local Vector3 = GLOBAL.Vector3
local SpawnPrefab=GLOBAL.SpawnPrefab


AddRecipe("toadstool_sack", {Ingredient("shroom_skin", 2)}, RECIPETABS.SURVIVAL, TECH.LOST, nil, nil, nil,nil, nil,"images/inventoryimages/toadstool_sack.xml", "toadstool_sack.tex" )

AddRecipe("mybackpack", {Ingredient("gears", 2),Ingredient("transistor", 2),Ingredient("goldnugget", 4)}, RECIPETABS.SURVIVAL, TECH.SCIENCE_TWO, nil, nil, nil,nil, nil,"images/inventoryimages/rivercrab_backpack.xml", "rivercrab_backpack.tex" )

AddMinimapAtlas("images/inventoryimages/toadstool_sack.xml")
AddMinimapAtlas("images/inventoryimages/rivercrab_backpack.xml")
AddPrefabPostInit("toadstool",function(inst)
	inst:ListenForEvent("death", function()
		inst.components.lootdropper:AddChanceLoot("toadstool_sack_blueprint", 0.33)
	end)
end)

AddPrefabPostInit("toadstool_sack", function(inst)
	local sporecloud=SpawnPrefab("sporecloud_overlay")
	local x, y, z = inst.Transform:GetWorldPosition()
	sporecloud.entity:SetParent(inst.entity)
	sporecloud.Transform:SetScale(0.5,0.5,0.5)
	sporecloud.Transform:SetPosition(x, y+1, z)
end)

STRINGS.NAMES.TOADSTOOL_SACK= "蛤蟆包"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TOADSTOOL_SACK = "剧毒蛤蟆包!"
STRINGS.RECIPE_TOADSTOOL_SACK= "蛤蟆包"
STRINGS.RECIPE_DESC.TOADSTOOL_SACK = "加速腐烂食物,14格背包"

STRINGS.NAMES.MYBACKPACK= "河蟹包"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MYBACKPACK = "河蟹包"
STRINGS.RECIPE_MYBACKPACK= "河蟹包"
STRINGS.RECIPE_DESC.MYBACKPACK = "加速"


local ExtraSlots = false
for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
	if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "Extra Equip Slots" or GLOBAL.KnownModIndex:GetModInfo(moddir).name == "Extra Equip Slots API Edition" then
		ExtraSlots = true
	end 
end
if ExtraSlots then
	AddPrefabPostInit("mybackpack", function(inst)
		if GLOBAL.TheNet:GetIsServer() then
			inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.BACK or GLOBAL.EQUIPSLOTS.BODY
		end
	end)
	AddPrefabPostInit("toadstool_sack", function(inst)
		if GLOBAL.TheNet:GetIsServer() then
			inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.BACK or GLOBAL.EQUIPSLOTS.BODY
		end
	end)
end