local assets =
{
    Asset("ANIM", "anim/swap_rivercrab_backpack.zip"),
    Asset("ANIM", "anim/ui_backpack_2x4.zip"),
	Asset( "ATLAS", "images/inventoryimages/rivercrab_backpack.xml" ),
	Asset("IMAGE", "images/inventoryimages/rivercrab_backpack.tex"), 
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "swap_rivercrab_backpack", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_rivercrab_backpack", "swap_body")
    inst.components.container:Open(owner)
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
    inst.components.container:Close(owner)
	inst.components.equippable.walkspeedmult=0.8
end

local function onburnt(inst)
    if inst.components.container ~= nil then
        inst.components.container:DropEverything()
        inst.components.container:Close()
    end

    SpawnPrefab("ash").Transform:SetPosition(inst.Transform:GetWorldPosition())

    inst:Remove()
end
local function equipped(inst,data)
	local owner=data.owner
	if owner then
		owner:ListenForEvent("locomote", function()
			if owner.components.rider:IsRiding() then 
				return
			end
			if owner.components.inventory:IsHeavyLifting() then
				return
			end
			inst.startpos = inst:GetPosition()
			inst:DoTaskInTime(0, function()
				inst.endpos = inst:GetPosition()
				if inst.startpos == inst.endpos then
					inst.timeinmotion = 0
				end
				if inst.startpos ~= inst.endpos then
					inst.timeinmotion = inst.timeinmotion + 1
				end
				if inst.timeinmotion == 0 and inst:HasTag("faster") then
        		    inst:AddTag("slowed")
        		    inst:RemoveTag("faster")
					inst.components.equippable.walkspeedmult=0.8
				end
				if inst.timeinmotion == 62 and inst:HasTag("slowed") then
        		    inst:AddTag("faster")
        		    inst:RemoveTag("slowed")
					inst.components.equippable.walkspeedmult=1.25
				end
			end)
		end)
	end
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()


    inst.MiniMapEntity:SetIcon("rivercrab_backpack.tex")

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("icepack")
    inst.AnimState:SetBuild("swap_rivercrab_backpack")
    inst.AnimState:PlayAnimation("anim")
	
    inst:AddTag("backpack")
	inst:AddTag("slowed")	
    inst.foleysound = "dontstarve/movement/foley/backpack"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
		inst:DoTaskInTime(0, function()
            inst.replica.container:WidgetSetup("backpack")
        end)
        return inst
    end
	inst.timeinmotion = 0
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.cangoincontainer = false
    inst.components.inventoryitem.imagename = "rivercrab_backpack"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rivercrab_backpack.xml"
	      
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.walkspeedmult=0.8
	inst:ListenForEvent("equipped",equipped)
	
    inst:AddComponent("container")
    inst.components.container:WidgetSetup("backpack")

    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    inst.components.burnable:SetOnBurntFn(onburnt)

    MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

return Prefab("mybackpack", fn, assets)
