local assets =
{
   -- Asset("ANIM", "anim/backpack.zip"),
    Asset("ANIM", "anim/swap_toadstool_sack.zip"),
    Asset("ANIM", "anim/ui_krampusbag_2x5.zip"),
	Asset( "ATLAS", "images/inventoryimages/toadstool_sack.xml" ),
	Asset("IMAGE", "images/inventoryimages/toadstool_sack.tex"), 
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "swap_toadstool_sack", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_toadstool_sack", "swap_body")
    inst.components.container:Open(owner)
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
    inst.components.container:Close(owner)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.MiniMapEntity:SetIcon("toadstool_sack.tex")

    inst.AnimState:SetBank("icepack")
    inst.AnimState:SetBuild("swap_toadstool_sack")
    inst.AnimState:PlayAnimation("anim")
	
    inst.foleysound = "dontstarve/movement/foley/krampuspack"

    inst:AddTag("backpack")

    --waterproofer (from waterproofer component) added to pristine state for optimization
    inst:AddTag("waterproofer")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
		inst:DoTaskInTime(0, function()
            inst.replica.container:WidgetSetup("krampus_sack")
        end)
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.cangoincontainer = false
    inst.components.inventoryitem.imagename = "toadstool_sack"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/toadstool_sack.xml"
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0)

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("krampus_sack")
	inst:DoPeriodicTask(2,function(inst)
		inst.components.container:FindItems(function(inst) 	
			if inst.components.perishable then
				inst.components.perishable:ReducePercent(0.01)
			end
		end)
		if not inst:IsInLimbo() then
			local x, y, z = inst.Transform:GetWorldPosition()
			local ents = TheSim:FindEntities(x, y, z, 3.5, nil, { "small_livestock" }, { "fresh", "stale", 		"spoiled" })
			for i, v in ipairs(ents) do
				if v.components.perishable and  not v:IsInLimbo() then
					v.components.perishable:ReducePercent(0.01)
				end
			end
		end
	end)
	
    MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

return Prefab("toadstool_sack", fn, assets)
