-- motorsoundConfiguration.lua
-- sets an individual engine sound for engine configurations
--
-- Author Rival with help from bassaddict
-- 26.10.2016
--
-- convert FS19 Aluha74rus
motorConfigSound = {};


function motorConfigSound.prerequisitesPresent(specializations)
    return true;
end

function motorConfigSound.initSpecialization()
end

function motorConfigSound.registerOverwrittenFunctions(vehicleType)
end

function motorConfigSound.registerFunctions(vehicleType)
end

function motorConfigSound.registerEvents(vehicleType)
end

function motorConfigSound:registerActionEventsPlayer()
end

function motorConfigSound:registerActionEventsMenu()
end

function motorConfigSound:onRegisterActionEvents(isSelected, isOnActiveVehicle)
end

function motorConfigSound.registerEventListeners(vehicleType)
end
function motorConfigSound:loadSounds(xmlFile, motorId)
    if self.isClient then
		local xmlFile = self.xmlFile;
		local key, motorId = ConfigurationUtil.getXMLConfigurationKey(xmlFile, self.configurations["motor"], "vehicle.motorized.motorConfigurations.motorConfiguration", "vehicle.motorized", "motorsound");
        local spec = self.spec_motorized
		
    if key ~= nil and hasXMLProperty(xmlFile, key..".sounds(0)") then -- using default motor configuration
        baseString = key..".sounds"
		
        spec.samples = {}
        spec.samples.motorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.motorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.gearbox      = g_soundManager:loadSampleFromXML(xmlFile, baseString, "gearbox", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.retarder     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "retarder", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.motorSamples = {}
        local i = 0
        while true do
            local sample = g_soundManager:loadSampleFromXML(xmlFile, baseString, string.format("motor(%d)", i), self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
            if sample == nil then
                break
            end
            table.insert(spec.motorSamples, sample)
            i = i + 1
        end
        spec.samples.airCompressorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.airCompressorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.airCompressorRun     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorRun", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.compressedAir    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "compressedAir", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        if spec.samples.compressedAir ~= nil then
            spec.samples.compressedAir.brakeTime = 0
            spec.samples.compressedAir.lastBrakeTime = 0
        end
        spec.samples.airRelease       = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airRelease", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.reverseDrive     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "reverseDrive", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.reverseDriveThreshold    = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.reverseDriveSound#threshold"), 4)
        spec.brakeCompressor = {}
        spec.brakeCompressor.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#capacity"), 6)
        spec.brakeCompressor.refillFilllevel = math.min(spec.brakeCompressor.capacity, Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#refillFillLevel"), spec.brakeCompressor.capacity/2))
        spec.brakeCompressor.fillSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#fillSpeed"), 0.6) / 1000
        spec.brakeCompressor.fillLevel = 0
        spec.brakeCompressor.doFill = true
        spec.isBrakeSamplePlaying = false
        spec.samples.brake     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "brake", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.compressionSoundTime = 0
    else
        baseString = "vehicle.motorized.sounds"
		
        spec.samples = {}
        spec.samples.motorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.motorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.gearbox      = g_soundManager:loadSampleFromXML(xmlFile, baseString, "gearbox", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.retarder     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "retarder", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.motorSamples = {}
        local i = 0
        while true do
            local sample = g_soundManager:loadSampleFromXML(xmlFile, baseString, string.format("motor(%d)", i), self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
            if sample == nil then
                break
            end
            table.insert(spec.motorSamples, sample)
            i = i + 1
        end
        spec.samples.airCompressorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.airCompressorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.airCompressorRun     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorRun", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.compressedAir    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "compressedAir", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        if spec.samples.compressedAir ~= nil then
            spec.samples.compressedAir.brakeTime = 0
            spec.samples.compressedAir.lastBrakeTime = 0
        end
        spec.samples.airRelease       = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airRelease", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.reverseDrive     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "reverseDrive", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.reverseDriveThreshold    = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.reverseDriveSound#threshold"), 4)
        spec.brakeCompressor = {}
        spec.brakeCompressor.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#capacity"), 6)
        spec.brakeCompressor.refillFilllevel = math.min(spec.brakeCompressor.capacity, Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#refillFillLevel"), spec.brakeCompressor.capacity/2))
        spec.brakeCompressor.fillSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#fillSpeed"), 0.6) / 1000
        spec.brakeCompressor.fillLevel = 0
        spec.brakeCompressor.doFill = true
        spec.isBrakeSamplePlaying = false
        spec.samples.brake     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "brake", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.compressionSoundTime = 0
    end
    end
end
Motorized.loadSounds = Utils.overwrittenFunction(Motorized.loadSounds, motorConfigSound.loadSounds);

function motorConfigSound:onLoad(vehicle)
end
function motorConfigSound:onUpdate(dt)
end
function motorConfigSound:onUpdateTick(dt)
end
function motorConfigSound:onDelete()
end