require "prefabutil"

local assets = {
	Asset("ANIM", "anim/pandoras_chest.zip"),
}

local function onopen(inst) 
	inst.AnimState:PlayAnimation("open") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("close") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")		
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed", false)
end

local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 3 do
		table.insert(slotpos, Vector3(80*x-80*2+40, 80*y-80*2+80,0))
	end
end

local fn = function(Sim)
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "pandoras_chest.png" )
	
	inst:AddTag("structure")
	inst.AnimState:SetBank('pandoras_chest')
	inst.AnimState:SetBuild('pandoras_chest')
	inst.AnimState:PlayAnimation("closed")
	
	inst:AddComponent("inspectable")
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)
	
	inst.components.container.onopenfn = onopen
	inst.components.container.onclosefn = onclose
	
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetbgatlas = "images/ui_chest_4x3.xml"
	inst.components.container.widgetbgimage = "ui_chest_4x3.tex"
	
	
	inst.components.container.widgetpos = Vector3(0,200,0)
	inst.components.container.side_align_tip = 160   
	
	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(2)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
	
	inst:ListenForEvent( "onbuilt", onbuilt)
	MakeSnowCovered(inst, .01)
	
	return inst
end

return	Prefab( "common/ornate_chest", fn, assets), 
		MakePlacer("common/ornate_chest_placer", "pandoras_chest", "pandoras_chest", "closed")