PrefabFiles = {
	"hector",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/hector.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/hector.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/hector.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hector.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/hector_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hector_silho.xml" ),

    Asset( "IMAGE", "bigportraits/hector.tex" ),
    Asset( "ATLAS", "bigportraits/hector.xml" ),
	
	Asset( "IMAGE", "images/map_icons/hector.tex" ),
	Asset( "ATLAS", "images/map_icons/hector.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING

-- Temporary solution without Shipwrecked
GLOBAL.CAPY_DLC = 2

-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.hector = "Hector The Border Collie"
GLOBAL.STRINGS.CHARACTER_NAMES.hector = "Hector"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.hector = "*Can befriend hounds\n*Turns lantern on when nervous\n*Afraid of spiders"
STRINGS.CHARACTER_QUOTES.hector = "\"Drakness is comming! Turn the light on!\""

-- Custom speech strings
GLOBAL.STRINGS.CHARACTERS.HECTOR = require "speech_wilson"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "hector")


AddMinimapAtlas("images/map_icons/hector.xml")
AddModCharacter("hector")

-- Lantern responses
STRINGS.CHARACTERS.HECTOR.ANNOUNCE_TURNONLANTERN =
{
	[1] = "I'm scared!",
	[2] = "It's so dark!",
	[3] = "I need light!",
	[4] = "Was that a spider?",
	[5] = "I need my lantern!",
	[6] = "I can't help myself!",
}

local slotpos_3x4 = {}

for y = 2.5, -0.5, -1 do
    for x = 0, 2 do
        table.insert(slotpos_3x4, GLOBAL.Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end

local function MorphShadowChester(inst, dofx)
	inst:AddTag("spoiler")
	inst.components.container:SetNumSlots(#slotpos_3x4)
	inst.components.container.widgetslotpos = slotpos_3x4
	inst.components.container.widgetanimbank = "ui_chester_shadow_3x4"
	inst.components.container.widgetanimbuild = "ui_chester_shadow_3x4"
	inst.components.container.widgetpos = GLOBAL.Vector3(0,220,0)
	inst.components.container.widgetpos_controller = GLOBAL.Vector3(0,220,0)
	inst.components.container.side_align_tip = 160

	local leader = inst.components.follower.leader    
	if leader then
		inst.components.follower.leader:MorphShadowEyebone()
	end

	inst.AnimState:SetBuild("chester_shadow_build")
	inst.ChesterState = "SHADOW"
	inst.MiniMapEntity:SetIcon("chestershadow.png")
end

-- Change chester to shadow chester on first day
local chesterPostInit = function (inst)
	if GLOBAL.GetPlayer().prefab == "hector" then
		-- Prevent hounds from attacking
		inst:AddTag("houndfriend")
		
		-- Turn into shadow chester
		if GLOBAL.GetClock().numcycles == 0 then
			local chester = GLOBAL.TheSim:FindFirstEntityWithTag("chester")
			if chester then 
				MorphShadowChester(chester)
			end
		end
	end
end

AddPrefabPostInit("chester", chesterPostInit)

-- Post init for all hounds
local function AddHoundPostInit(fn)
	AddPrefabPostInitAny( function(inst)
		if inst and inst:HasTag("hound") then fn(inst) end
	end)
end

-- Function to remove sanity aura
local removeSanityAura = function(inst)
	if GLOBAL.GetPlayer().prefab == "hector" then
		if inst.components.sanityaura then
			local aurafn_orig = inst.components.sanityaura.aurafn
			local aurafn_new = function(inst, observer)
				-- Check if the observer is a friend of hounds
				if observer:HasTag("houndfriend") then
					return 0
				end
				if aurafn_orig then
					return aurafn_orig(inst, observer)
				end
				return inst.components.sanityaura.aura
			end
			inst.components.sanityaura.aurafn = aurafn_new
		end
	end
end

AddHoundPostInit(removeSanityAura)


----------------------------------------------------
-- BEFRIENDING HOUNDS

local HOUND_LOYALTY_PER_HUNGER = TUNING.TOTAL_DAY_TIME/25
local HOUND_LOYALTY_MAXTIME = 2.5*TUNING.TOTAL_DAY_TIME


local makeHoundFriend = function(inst)
	if not GLOBAL.GetPlayer().prefab == "hector" then
		return
	end
	
	-- Add the trader component if not already added
	if not inst.components.trader then
		inst:AddComponent("trader")
	end
	
	-- Add a new test function to whether they should accept or not
	local test_prev = inst.components.trader.test
	local test_new = function(inst, item, giver)
		if not giver then
			giver = GLOBAL.GetPlayer()
		end
		if not giver:HasTag("houndtamer") then
			-- Do whatever function it was before
			if test_prev then
				return test_prev(inst, item, giver)
			end
			return
		end

		if inst.components.eater:CanEat(item) then
			return true
		end
	end
    inst.components.trader:SetAcceptTest(test_new)
	
	local onaccept_prev = inst.components.trader.onaccept
	local onaccept_new = function(inst, giver, item)
		if not giver:HasTag("houndtamer") then
			-- Do whatever function it was before
			if onaccept_prev then
				return onaccept_prev(inst, giver, item)
			end
			return
		end
		if inst.components.eater:CanEat(item) then  

			local playedfriendsfx = false
			if inst.components.combat.target and inst.components.combat.target == giver then
				inst.components.combat:SetTarget(nil)
			elseif giver.components.leader then
				inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
				playedfriendsfx = true
				giver.components.leader:AddFollower(inst)
				local loyaltyTime = item.components.edible:GetHunger() * HOUND_LOYALTY_PER_HUNGER
				inst.components.follower:AddLoyaltyTime(loyaltyTime)
			end

		end
	end
    inst.components.trader.onaccept = onaccept_new
	
	local onrefuse_prev = inst.components.onrefuse
	local function onrefuse_new(inst, giver, item)
		if not giver:HasTag("houndtamer") then
			-- Do whatever function it was before
			if onrefuse_prev then
				return onrefuse_prev(inst, giver, item)
			end
			return
		end
		inst.sg:GoToState("taunt")
		if inst.components.sleeper:IsAsleep() then
			inst.components.sleeper:WakeUp()
		end
	end
    inst.components.trader.onrefuse = onrefuse_new
	
	
	-- Add loyalty in a way that will not conflict with other mods
	if not inst.components.follower then
        inst:AddComponent("follower")
	end
	
	local follower = inst.components.follower
	local AddLoyaltyTime_prev = follower.AddLoyaltyTime
	function follower:AddLoyaltyTime(time)
		if follower.leader and follower.leader:HasTag("houndtamer") then
			local currentTime = GLOBAL.GetTime()
			local timeLeft = self.targettime or 0
			timeLeft = math.max(0, timeLeft - currentTime)
			timeLeft = math.min(HOUND_LOYALTY_MAXTIME or 0, timeLeft + time)
			
			self.targettime = currentTime + timeLeft

			if self.task then
				self.task:Cancel()
				self.task = nil
			end
			self.task = self.inst:DoTaskInTime(timeLeft, stopfollow)
		else
			return AddLoyaltyTime_prev(self, time)
		end
	end
	
	if inst.components.combat then
		-- Prevent hounds from attacking other players
		local targetfn_orig = inst.components.combat.targetfn
		local targetfn_new = function(inst)
			local target = nil
			-- Choose target normally
			if targetfn_orig then target = targetfn_orig(inst) end
			-- Check if this hound has Tecolin as a leader
			if target ~= nil and inst.components.follower and inst.components.follower.leader and inst.components.follower.leader:HasTag("houndtamer") then
				-- Check if target should be kept
				if target:HasTag("player")
				or target:HasTag("companion")
				then
					target = nil
				end
			end
			
			return target
		end
		inst.components.combat.targetfn = targetfn_new
		
		local ShareTarget_prev = inst.components.combat.ShareTarget
		function inst.components.combat:ShareTarget(target, ...)
			-- Prevent Tecolin from being shared as a target
			if target:HasTag("houndtamer") then
				return
			end
			-- Prevent players and companions from being shared as a target
			if target:HasTag("player")
			or target:HasTag("companion")
			then
				local houndtamer = GLOBAL.FindEntity(inst, 20, function(guy)
					return guy:HasTag("houndtamer")
				end)
				if houndtamer ~= nil then return end
			end
			return ShareTarget_prev(self, target, ...)
		end
		
	end
end

AddHoundPostInit(makeHoundFriend)


