local LanternClinger = Class(function(self, inst)
    self.inst = inst
    self.time_to_lantern = 60
    self.time_interval = 10
    self.time_variance = 240
    self.sanity_threshold = nil
    self.time_to_fuel = 60
    self.enabled = nil
	self.fuelingpower = TUNING.MED_FUEL
    self:Enable()
end)

function LanternClinger:Enable(enable)
    if not self.enabled then
        self.enabled = true
        self.inst:StartUpdatingComponent(self)
    end
end

function LanternClinger:Disable()
    if self.enabled then
        self.enabled = false
        self.inst:StopUpdatingComponent(self)
    end
end

function LanternClinger:OnUpdate(dt)

	local isinlight = self.inst.LightWatcher:IsInLight()
	local canrefuel = false
	
	-- Check whether can refuel lanterns
	if self.time_to_fuel > dt then
        self.time_to_fuel = self.time_to_fuel - dt
	else
		canrefuel = true
	end
	
	-- Activates when either at low sanity or in dark
    if self.sanity_threshold ~= nil and self.inst.components.sanity:GetPercent() >= self.sanity_threshold and isinlight then
        return
    elseif self.time_to_lantern > dt then
		local rate = 1
		if not isinlight then
			rate = rate*20
		end
		if not self.inst.components.sanity.sane then
			rate = rate*3
		end
		if self.inst.nearspider then
			rate = rate*3
		end
        self.time_to_lantern = self.time_to_lantern - (dt*rate)
    else
		local lanternon = false
		local hasrefueled = false
		
		-- Pick up lantern
		local invlight = self.inst.components.inventory:FindItem(function(item)
			return item:HasTag("light")
				and item.components.equippable ~= nil
				and not (item.components.fueled
					and item.components.fueled:IsEmpty()
					and not canrefuel)
		end)
		if invlight ~= nil then
			local equipslot = invlight.components.equippable and invlight.components.equippable.equipslot
			local equippeditem = self.inst.components.inventory:GetEquippedItem(equipslot)
			if self.inst.components.inventory and (not equippeditem or not equippeditem:HasTag("light") or (equippeditem.components.fueled and equippeditem.components.fueled:IsEmpty())) then
				if invlight.components.fueled and invlight.components.fueled:IsEmpty() and canrefuel then
					invlight.components.fueled:DoDelta(self.fuelingpower)
					hasrefueled = true
					canrefuel = false
				end
				self.inst.components.inventory:Equip(invlight)
				lanternon = true
			end
		end
		-- Turn on nearby lanterns
		local x,y,z = self.inst.Transform:GetWorldPosition()	
		local delta = 0
		local max_rad = 10
		local ents = TheSim:FindEntities(x,y,z, max_rad, {"light"})
		for k,v in pairs(ents) do 
			if v.components.machine
			and not v.components.machine.ison
			and v.components.fueled
			and not (v.components.fueled:IsEmpty() and not canrefuel)
			then
				if v.components.fueled and v.components.fueled:IsEmpty() and canrefuel then
					v.components.fueled:DoDelta(self.fuelingpower)
					hasrefueled = true
					canrefuel = false
				end
				self.inst:DoTaskInTime(1*math.random(), function(inst)
					v.components.machine:TurnOn()
				end)
				lanternon = true
			end
		end
		
		if lanternon then
			self.inst.components.talker:Say(GetString(self.inst.prefab, "ANNOUNCE_TURNONLANTERN"))
		end
		
		if hasrefueled then
			self.time_to_fuel = 480
		end
       
        self.time_to_lantern = self.time_interval + self.time_variance * math.random()
    end
end


return LanternClinger