
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/hector.zip" ),
}

-- Custom starting items
local start_inv = {
	"lantern",
}

if IsDLCEnabled(CAPY_DLC) then
	-- Give bottle lantern instead in SW
	start_inv = {
		"bottlelantern",
	}
end

-- Make afraid of spiders
local function sanityfn(inst)
	inst.nearspider = false
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"spider"})
    for k,v in pairs(ents) do 
		if v.components.health and not v.components.health:IsDead() then
			local sz = -TUNING.SANITYAURA_MED
			local rad = 10
			sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
			inst.nearspider = true
    	end
    end
    
    return delta
end

-- Sanity loss on attacked by spider
local function onattacked(inst, data)
	if data.attacker and data.attacker:HasTag("spider") then
		inst.components.sanity:DoDelta(-3)
	end
end

local fn = function(inst)
	
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "hector.tex" )
	
	inst:AddTag("houndfriend")
	inst:AddTag("houndtamer")
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	
	-- Custom sanity function
	inst.components.sanity.custom_rate_fn = sanityfn
	
	inst:AddComponent("lanternclinger")
	inst.components.lanternclinger.sanity_threshold = 0.5
	inst.soundsname = "wolfgang"
	
	-- Give the eyebone
	if GetClock().numcycles == 0 then
		inst:DoTaskInTime(0, function()
			local eyebone = TheSim:FindFirstEntityWithTag("chester_eyebone")
			if eyebone and not inst.components.inventory:Has(eyebone.prefab, 1) then
				inst.components.inventory:GiveItem(eyebone)
			end
		end)
	end
	
	
	-- Listen for attack
	inst:ListenForEvent("attacked", onattacked)
end

return MakePlayerCharacter("hector", prefabs, assets, fn, start_inv)
