Assets =
{
	Asset("ANIM", "anim/butterfly_basic.zip"),

	Asset("IMAGE", "images/inventoryimages/butterfly.tex"),
    Asset("ATLAS", "images/inventoryimages/butterfly.xml"),
}

local env = env
GLOBAL.setfenv(1, GLOBAL)

local CONVERTION_DATA = require("img_override_data_butterflymod")

local function ConvertTexture(atlas, tex)
	if CONVERTION_DATA[atlas] and  CONVERTION_DATA[atlas][tex] then
		return unpack(CONVERTION_DATA[atlas][tex])
	end
	return atlas, tex
end

local Image = require("widgets/image")

local _SetTexture = Image.SetTexture
Image.SetTexture = function(self, atlas, tex, ...)
	atlas, tex = ConvertTexture(atlas, tex)
	return _SetTexture(self, atlas, tex, ...)
end
