--Author: yakuzadeso

--------------------------------------------------------------------------------
--Settings

--How often should Health increase. E.g. using 50 will increase Health every 50 points in your defense stat (50, 100, 150, 200, 250, 300, 350, 400, 450)
Step = 10 --Change "10" to whatever value you want. Accepted values 1 to 450

--Whether to clamp max Health or not.
Clamp = false --Setting this to false will allow Health to scale above the clamp value.

--Maximum value for Health.
ClampValue = 4000 --Change "4000" to whatever value you want. Accepted values 1 to infinity.

--How much should Health increase on every Step
HealthUp = 100 --Change 100 to whatever value you want. Accepted values 1 to infinity.

--Chosen base health for your character to spawn with and add health points to depending on your Defense Stat.
--"CurrentLevelHealth" uses your default health that is based on your level. E.g. at level 40 you have 4000 health.
--"CustomHealth" uses whatever value you've set to CustomHealth.
HealthToScale = "CurrentLevelHealth" -- Accepted values: "CustomHealth", "CurrentLevelHealth"

--Bypass the game's default health values if you're using "CustomHealth" in HealthToScale.
--Your characters base health will be the value of CustomHealth. E.g. if you've used 500 then your character's health will be 500.
CustomHealth = 500 -- Change 500 to whatever value you want. Accepted values 1 to infinity

--------------------------------------------------------------------------------

n = 0

function CalculateHealth()
    ExecuteInGameThread(function()
        DefenseStat = BipedPlayer:GetDefenseStat()
        array = {}

        for i = 1, DefenseStat do
            array[i] = i

            if i % Step == 0 then
                n = n + HealthUp
                if Clamp then
                    if n > ClampValue then
                        n = ClampValue
                    end
                end
                if DefenseStat == 0 then
                    n = 0
                end
            end
        end

        if HealthToScale == "CurrentLevelHealth" then
            BipedPlayer:GetObjectStateInfo():SetBaseHealth(CurrentLevelHealth + n)
        end
        if HealthToScale == "CustomHealth" then
            BipedPlayer:GetObjectStateInfo():SetBaseHealth(CustomHealth + n)
        end
        if Clamp then
            if BipedPlayer:GetHealth() > ClampValue then
                BipedPlayer:GetObjectStateInfo():SetBaseHealth(ClampValue)
            end
        end
        print("Setting Health to " .. BipedPlayer:GetHealth() .. "!")
    end)
    n = 0
end

RegisterHook("/Script/Phoenix.GearScreen:EquipGearItem", function()
    CalculateHealth()
end)

RegisterHook("/Script/Phoenix.GearScreen:UnequipGearItem", function()
    CalculateHealth()
end)

RegisterHook("/Script/Engine.PlayerController:ClientRestart", function(Context, NewPawn)
    BipedPlayer = Context:get().Pawn
end)

local shouldInitTheMod = false

NotifyOnNewObject("/Script/Phoenix.Loadingcreen", function(self)
    print("HealthScalesWithDefense is starting up!")
    shouldInitTheMod = true
end)

function LoadCurtainRaised()
    local Function = StaticFindObject(
        "/Game/UI/LoadingScreen/UI_BP_NewLoadingScreen.UI_BP_NewLoadingScreen_C:OnCurtainRaised")
    if not Function:IsValid() then
        ExecuteWithDelay(3000, LoadCurtainRaised)
        return
    end

    RegisterHook("/Game/UI/LoadingScreen/UI_BP_NewLoadingScreen.UI_BP_NewLoadingScreen_C:OnCurtainRaised", function()
        if shouldInitTheMod then
            shouldInitTheMod = false

            print("HealthScalesWithDefense hooked on load/reload succesfully!")
            CurrentLevelHealth = BipedPlayer:GetHealth()
            CalculateHealth()
        end
    end)
end

LoadCurtainRaised()
