PrefabFiles = {
	"raymond",
	"raymond_none",
	
}
Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/raymond.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/raymond.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/raymond.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/raymond.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/raymond_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/raymond_silho.xml" ),

    Asset( "IMAGE", "bigportraits/raymond.tex" ),
    Asset( "ATLAS", "bigportraits/raymond.xml" ),
	
	Asset( "IMAGE", "images/map_icons/raymond.tex" ),
	Asset( "ATLAS", "images/map_icons/raymond.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_raymond.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_raymond.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_raymond.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_raymond.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_raymond.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_raymond.xml" ),
	
	Asset( "IMAGE", "images/names_raymond.tex" ),
    Asset( "ATLAS", "images/names_raymond.xml" ),
	
    Asset( "IMAGE", "bigportraits/raymond_none.tex" ),
    Asset( "ATLAS", "bigportraits/raymond_none.xml" ),
	
	}
	
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.raymond = "The Black Fox"
STRINGS.CHARACTER_NAMES.raymond = "Raymond"
STRINGS.CHARACTER_DESCRIPTIONS.raymond = "*Night Fox\n*<3 Winter / </3 Summer\n*Arachnophobic"
STRINGS.CHARACTER_QUOTES.raymond = "\"We have met with a terrible fate, haven't we?\""

-- Custom speech strings
STRINGS.CHARACTERS.RAYMOND = require "speech_raymond"

-- The character's name as appears in-game 
STRINGS.NAMES.raymond = "Esc"

AddMinimapAtlas("images/map_icons/raymond.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("raymond", "MALE")

-- The character's name as appears in-game 
STRINGS.NAMES.RAYMOND = "Raymond"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RAYMOND = 
{
	GENERIC = "It's Raymond!",
	ATTACKER = "That Raymond looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Raymond, friend of ghosts.",
	GHOST = "Raymond could use a heart.",
}

AddPrefabPostInit("rabbit", function(inst)
	if GLOBAL.TheWorld.ismastersim then
		inst:AddComponent("rabbitcatchable")
	end
end)

AddComponentAction("SCENE", "rabbitcatchable", function(inst, doer, actions, right)
	if right and doer:HasTag("rabbithunter") then
		table.insert(actions, GLOBAL.ACTIONS.PICKUP)
	end
end)

local _fn1 = GLOBAL.ACTIONS.PICKUP.fn
GLOBAL.ACTIONS.PICKUP.fn = function(act)
	if act.doer and act.doer:HasTag("rabbithunter") and act.target and act.target.components.rabbitcatchable then
		local _canbepickedup = act.target.components.inventoryitem.canbepickedup
		act.target.components.inventoryitem.canbepickedup = true
		local ret = _fn1(act)
		act.target.components.inventoryitem.canbepickedup = _canbepickedup
		return ret
	end
	return _fn1(act)
end

