local MakePlayerCharacter = require "prefabs/player_common"
local assets = {
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/gnar.zip" ),}
local prefabs = {}
local start_inv = {
	"boomerang",}
local fn = function(inst)
        inst.components.talker.colour = Vector3(0.4, 0.5, 0.5, 0)
	inst.components.combat:SetAttackPeriod(0.25)
	inst.components.temperature.inherentinsulation = 150
	inst.soundsname = "wallace"
	inst.MiniMapEntity:SetIcon( "gnar.tex" )
	inst.Transform:SetScale(0.90,0.90,0.90)	
	inst.components.health:SetMaxHealth(180)
	inst.components.sanity.max = (140)
	inst.components.hunger.max = (100)
	inst.components.health.fire_damage_scale = 3
	inst.components.sanity.night_drain_mult = 1.15
	inst.components.sanity.neg_aura_mult = 0.75
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.15)
	inst.components.eater.ignoresspoilage = true
	inst.components.combat.damagemultiplier = 1
	inst.components.locomotor.runspeed = 7.5
	inst.components.locomotor.enablegroundspeedmultiplier = false
	inst.components.temperature.hurtrate = 0.85 * (TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME)
        inst.components.hunger:SetKillRate(TUNING.WILSON_HEALTH/TUNING.STARVE_KILL_TIME * 2)
end
return MakePlayerCharacter("gnar", prefabs, assets, fn, start_inv)
