class X2Item_DefaultUtilityItems extends X2Item config(GameCore);

var config int MEDIKIT_CHARGES, NANOMEDIKIT_CHARGES;
var config int MEDIKIT_RANGE_TILES;

var config int BATTLESCANNER_RANGE;
var config int BATTLESCANNER_RADIUS;
var config int MIMICBEACON_RANGE;

var name MedikitCat;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Items;

	Items.AddItem(CreateAlloyArmor());

	return Items;
}

static function X2DataTemplate CreateAlloyArmor()
{
	local X2EquipmentTemplate Template;
	
	`CREATE_X2TEMPLATE(class'X2EquipmentTemplate', Template, 'AlloyArmor');
	Template.ItemCat = 'defense';
	Template.InventorySlot = eInvSlot_Utility;
	Template.strImage = "img:///UILibrary_AlloyArmor.X2InventoryIcons.Inv_Armor_Alloy";
	Template.EquipSound = "StrategyUI_Vest_Equip";

	Template.Abilities.AddItem('AlloyArmorAbility');

	Template.CanBeBuilt = False;
	Template.TradingPostValue = 25;
	Template.PointsToComplete = 0;
	Template.Tier = 2;

	Template.RewardDecks.AddItem('ExperimentalArmorRewards');

	Template.SetUIStatMarkup(class'XLocalizedData'.default.ArmorLabel, eStat_ArmorMitigation, class'X2Ability_AlloyArmorAbilitySet'.default.ALLOY_ARMOR_MITIGATION_AMOUNT);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_AlloyArmorAbilitySet'.default.ALLOY_ARMOR_MOBILITY_BONUS);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.HealthLabel, eStat_HP, class'X2Ability_AlloyArmorAbilitySet'.default.ALLOY_ARMOR_HP_BONUS);

	return Template;
}
