/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.regex.Pattern;
import lain.mods.peacefulsurface.IEntitySpawnFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class JsonRule
implements IEntitySpawnFilter {
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private transient boolean valid = false;
    public boolean Disabled;
    public boolean Living;
    public boolean Mob;
    public boolean Animal;
    public boolean Tameable;
    public boolean Checking_LightLevel;
    public boolean Raining;
    public boolean Thundering;
    public boolean Day;
    public boolean Night;
    public boolean InvertedMobFilter;
    public boolean InvertedDimensionFilter;
    public boolean InvertedLightLevelChecking;
    public String mobFilter = "";
    public String dimensionFilter = "";
    public int LightLevel;
    private transient Pattern _mobFilter;
    private transient Pattern _dimensionFilter;

    @Override
    public boolean enabled() {
        return !this.Disabled;
    }

    @Override
    public boolean filterEntity(Entity entity, World world, float x, float y, float z) {
        this.validate();
        if (this.Living && !(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (this.Mob && !(entity instanceof IMob)) {
            return false;
        }
        if (this.Animal && !(entity instanceof IAnimals)) {
            return false;
        }
        if (this.Tameable && !(entity instanceof IEntityOwnable)) {
            return false;
        }
        String mobName = EntityList.func_75621_b((Entity)entity);
        if (mobName == null) {
            return false;
        }
        if (this.InvertedMobFilter ? !this._mobFilter.matcher(mobName).lookingAt() : this._mobFilter.matcher(mobName).lookingAt()) {
            return false;
        }
        String dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
        if (dimensionName != null && (this.InvertedDimensionFilter ? !this._dimensionFilter.matcher(dimensionName).lookingAt() : this._dimensionFilter.matcher(dimensionName).lookingAt())) {
            return false;
        }
        dimensionName = String.format("DIM%d", world.field_73011_w.getDimension());
        if (this.InvertedDimensionFilter ? !this._dimensionFilter.matcher(dimensionName).lookingAt() : this._dimensionFilter.matcher(dimensionName).lookingAt()) {
            return false;
        }
        if (this.Checking_LightLevel) {
            int n = world.func_175721_c(new BlockPos(MathHelper.func_76141_d((float)x), MathHelper.func_76141_d((float)y), MathHelper.func_76141_d((float)z)), false);
            if (this.InvertedLightLevelChecking ? n <= this.LightLevel : n > this.LightLevel) {
                return true;
            }
        }
        if (this.Raining && !world.func_72896_J()) {
            return true;
        }
        if (this.Thundering && !world.func_72911_I()) {
            return true;
        }
        if (this.Day && !world.func_72935_r()) {
            return true;
        }
        return this.Night && world.func_72935_r();
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        this._mobFilter = Pattern.compile(this.mobFilter);
        this._dimensionFilter = Pattern.compile(this.dimensionFilter);
        this.valid = true;
    }
}

