SKIPUNZIP=1
RIRU_PATH="/data/misc/riru"
RIRU_API="4"
RIRU_VERSION_CODE="29"
RIRU_VERSION_NAME="v19.7"

# check architecture
if [[ "$ARCH" != "arm" && "$ARCH" != "arm64" && "$ARCH" != "x86" && "$ARCH" != "x64" ]]; then
  abort "! Unsupported platform: $ARCH"
else
  ui_print "- 设备平台: $ARCH"
fi

###
unzip -o "$ZIPFILE" 'verify.sh' -d "$TMPDIR" >&2
if [ ! -f "$TMPDIR/verify.sh" ]; then
  ui_print "*********************************************************"
  ui_print "! Unable to extract verify.sh!"
  ui_print "! This zip may be corrupted, please try downloading again"
  abort    "*********************************************************"
fi
. $TMPDIR/verify.sh

###


ui_print "- 正在提取Magisk文件"

extract "$ZIPFILE" 'module.prop' "$MODPATH"
extract "$ZIPFILE" 'post-fs-data.sh' "$MODPATH"
extract "$ZIPFILE" 'uninstall.sh' "$MODPATH"

mkdir -p "$RIRU_PATH/modules"
mkdir -p "$RIRU_PATH/bin"

if [[ "$ARCH" == "x86" || "$ARCH" == "x64" ]]; then
  ui_print "- 提取x86库"
  extract "$ZIPFILE" 'system_x86/lib/libmemtrack.so' "$MODPATH"
  mv "$MODPATH/system_x86/lib" "$MODPATH/system/lib"

  if [[ "$IS64BIT" == "true" ]]; then
    ui_print "- 提取x64库"
    extract "$ZIPFILE" 'system_x86/lib64/libmemtrack.so' "$MODPATH"
    mv "$MODPATH/system_x86/lib64" "$MODPATH/system/lib64"
  fi
else
  ui_print "- 提取ARM库"
  extract "$ZIPFILE" 'system/lib/libmemtrack.so' "$MODPATH"

  if [[ "$IS64BIT" == "true" ]]; then
    ui_print "- 提取ARM64库"
    extract "$ZIPFILE" 'system/lib64/libmemtrack.so' "$MODPATH"
  fi
fi

ui_print "- 正在提取zygote_restart可执行文件"

###
mkdir -p "$RIRU_PATH/modules"
mkdir -p "$RIRU_PATH/bin"
set_perm "$RIRU_PATH" 0 0 0700
set_perm "$RIRU_PATH/modules" 0 0 0700
set_perm "$RIRU_PATH/bin" 0 0 0700
###


extract "$ZIPFILE" "zygote_restart/zygote_restart_$ARCH" "$RIRU_PATH/bin" "true"
mv "$RIRU_PATH/bin/zygote_restart_$ARCH" "$RIRU_PATH/bin/zygote_restart"
set_perm "$RIRU_PATH/bin/zygote_restart" 0 0 0700 u:object_r:system_file:s0

ui_print "- 编写Riru文件"
echo -n "$RIRU_API" > "$RIRU_PATH/api_version.new"
echo -n "$RIRU_VERSION_NAME" > "$RIRU_PATH/version_name.new"
echo -n "$RIRU_VERSION_CODE" > "$RIRU_PATH/version_code.new"
set_perm "$RIRU_PATH/api_version.new" 0 0 0600 u:object_r:system_file:s0
set_perm "$RIRU_PATH/version_name.new" 0 0 0600 u:object_r:system_file:s0
set_perm "$RIRU_PATH/version_code.new" 0 0 0600 u:object_r:system_file:s0

ui_print "- 设置权限"
set_perm_recursive "$MODPATH" 0 0 0755 0644


OLD_MAGISK=false
DETECTED_DEVICE=false
PROP_MODEL=$(getprop ro.product.model)
PROP_DEVICE=$(getprop ro.product.device)
PROP_PRODUCT=$(getprop ro.build.product)
PROP_BRAND=$(getprop ro.product.brand)
PROP_MANUFACTURER=$(getprop ro.product.manufacturer)
VERSION=$(grep_prop version "$TMPDIR/module.prop")
MODEL="
HD1900
HD1910
"
DEVICE="
OnePlus7T
OnePlus7TPro
"
PRODUCT="
OnePlus7T
OnePlus7TPro
"
BRAND="
HUAWEI
HONOR
"
MANUFACTURER="
HUAWEI
"

require_new_magisk() {
    ui_print "******************************"
    ui_print "! Special device detected"
    ui_print "! Magisk v20.2+ is required"
    ui_print "! You can update from 'Magisk Manager' or https://github.com/topjohnwu/Magisk/releases"
    abort    "******************************"
}

require_riru() {
    ui_print "******************************"
    ui_print "! Requirement module 'Riru - Core' is not installed"
    ui_print "! You can download from 'Magisk Manager' or https://github.com/RikkaApps/Riru/releases"
    abort    "******************************"
}

require_new_riru() {
    ui_print "******************************"
    ui_print "! Old Riru ${1} (below v19) detected"
    ui_print "! The latest version of 'Riru - Core' is required"
    ui_print "! You can download from 'Magisk Manager' or https://github.com/RikkaApps/Riru/releases"
    abort    "******************************"
}

require_yahfa() {
    ui_print "******************************"
    ui_print "! Architecture x86 or x86_64 detected"
    ui_print "! Only YAHFA variant supports x86 or x86_64 architecture devices"
    ui_print "! You can download from 'Magisk Manager' or 'EdXposed Manager'"
    abort    "******************************"
}

require_new_android() {
    ui_print "******************************"
    ui_print "! Old Android ${1} (below Oreo) detected"
    ui_print "! Only the original Xposed Framework can be used under Android 8.0"
    ui_print "! You can download from 'Xposed Installer' or 'Magisk Manager(Systemless-ly)'"
    ui_print "! Learn more: https://github.com/ElderDrivers/EdXposed/wiki/Available-Android-versions"
    abort    "******************************"
}

check_magisk_version() {
    for TARGET in ${MODEL}; do
        if [[ "${PROP_MODEL}" == ${TARGET} ]]; then
            DETECTED_DEVICE=true
        fi
    done
    for TARGET in ${DEVICE}; do
        if [[ "${PROP_DEVICE}" == ${TARGET} ]]; then
            DETECTED_DEVICE=true
        fi
    done
    for TARGET in ${PRODUCT}; do
        if [[ "${PROP_PRODUCT}" == ${TARGET} ]]; then
            DETECTED_DEVICE=true
        fi
    done
    for TARGET in ${BRAND}; do
        if [[ "${PROP_BRAND}" == ${TARGET} ]]; then
            DETECTED_DEVICE=true
        fi
    done
    for TARGET in ${MANUFACTURER}; do
        if [[ "${PROP_MANUFACTURER}" == ${TARGET} ]]; then
            DETECTED_DEVICE=true
        fi
    done
    if [[ "${DETECTED_DEVICE}" = true ]]; then
        ui_print "- Special device detected"
    fi
    ui_print "- Magisk版本是 ${MAGISK_VER_CODE}"
    [[ ${MAGISK_VER_CODE} -ge 20102 ]] || check_old_magisk_device ${MAGISK_VER_CODE}
}


check_architecture() {
    if [[ "${MODID}" == "edxposed-s" ]]; then
        VARIANTS="SandHook"
    else
        VARIANTS="YAHFA"
    fi
    ui_print "- EdXposed 变体: ${VARIANTS}"
    if [[ "${ARCH}" != "arm" && "${ARCH}" != "arm64" && "${ARCH}" != "x86" && "${ARCH}" != "x64" ]]; then
        abort "! Unsupported platform is ${ARCH}"
    else
        ui_print "- 设备平台是 ${ARCH}"
        if [[ "${ARCH}" == "x86" || "${ARCH}" == "x64" ]]; then
            if [[ "${VARIANTS}" == "SandHook" ]]; then
                require_yahfa
            fi
        fi
    fi
}

check_android_version() {
    [[ ${API} -ge 26 ]] || require_new_android ${API}
}

ui_print "- EdXposed版本 ${VERSION}"

check_magisk_version
check_riru_version
check_architecture

ui_print "- 提取模块文件"
unzip -o "${ZIPFILE}" module.prop post-fs-data.sh sepolicy.rule system.prop uninstall.sh 'system/*' -d "${MODPATH}" >&2

if [[ "${ARCH}" == "x86" || "${ARCH}" == "x64" ]]; then
    ui_print "- Replacing x86 and x86_64 libraries"
    unzip -o "${ZIPFILE}" 'system_x86/*' -d "${MODPATH}" >&2
    rm -rf "${MODPATH}/system/lib"
    rm -rf "${MODPATH}/system/lib64"
    mv "${MODPATH}/system_x86/lib" "${MODPATH}/system/lib"
    mv "${MODPATH}/system_x86/lib64" "${MODPATH}/system/lib64"
    rm -rf "${MODPATH}/system_x86"
fi

if [[ "${IS64BIT}" = false ]]; then
    ui_print "- Removing 64-bit libraries"
    rm -rf "${MODPATH}/system/lib64"
fi

if [[ "${OLD_MAGISK}" = true ]]; then
    ui_print "- Removing sepolicy rule for old Magisk"
    rm ${MODPATH}/sepolicy.rule
fi

ui_print "- 复制其余的文件"

TARGET="${RIRU_PATH}/modules/edxp"

[[ -d "${TARGET}" ]] || mkdir -p "${TARGET}" || abort "! Can't mkdir -p ${TARGET}"

rm "${TARGET}/module.prop"

cp "${MODPATH}/module.prop" "${TARGET}/module.prop" || abort "! Can't create ${TARGET}/module.prop"

set_perm_recursive "${MODPATH}" 0 0 0755 0644

ui_print "- 欢迎使用 EdXposed ${VERSION}!"