/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.init.MyBlocks;
import sidben.redstonejukebox.proxy.ClientProxy;
import sidben.redstonejukebox.tileentity.TileEntityRedstoneJukebox;

public class BlockRedstoneJukebox
extends BlockContainer {
    private final boolean isActive;
    private static boolean keepMyInventory = false;
    @SideOnly(value=Side.CLIENT)
    private IIcon discIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideOnIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideOffIcon;

    public BlockRedstoneJukebox(boolean active) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("redstone_jukebox");
        this.func_149672_a(Block.field_149780_i);
        this.func_149658_d("redstone_jukebox_off");
        this.isActive = active;
    }

    public TileEntity func_149915_a(World world, int damage) {
        return new TileEntityRedstoneJukebox();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public Item func_149650_a(int par1, Random par2, int par3) {
        return Item.func_150898_a((Block)MyBlocks.redstoneJukebox);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)MyBlocks.redstoneJukebox);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        switch (side) {
            case 0: {
                return this.bottomIcon;
            }
            case 1: {
                return this.topIcon;
            }
            case 7: {
                return this.discIcon;
            }
        }
        if (this.isActive) {
            return this.sideOnIcon;
        }
        return this.sideOffIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.discIcon = iconRegister.func_94245_a(ClientProxy.jukeboxDiscIcon);
        this.topIcon = iconRegister.func_94245_a(ClientProxy.jukeboxTopIcon);
        this.bottomIcon = iconRegister.func_94245_a(ClientProxy.jukeboxBottomIcon);
        this.sideOnIcon = iconRegister.func_94245_a(ClientProxy.jukeboxSideOnIcon);
        this.sideOffIcon = iconRegister.func_94245_a(ClientProxy.jukeboxSideOffIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ModRedstoneJukebox.redstoneJukeboxModelID;
    }

    public String func_149739_a() {
        return String.format("tile.%s:%s", "redstonejukebox".toLowerCase(), this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float a, float b, float c) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)ModRedstoneJukebox.instance, ModRedstoneJukebox.redstoneJukeboxGuiID, world, x, y, z);
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (stack.func_82837_s()) {
            ((TileEntityRedstoneJukebox)world.func_147438_o(x, y, z)).setInventoryName(stack.func_82833_r());
        }
    }

    public void func_149749_a(World par1World, int x, int y, int z, Block par5, int par6) {
        TileEntityRedstoneJukebox teJukebox;
        if (!keepMyInventory && (teJukebox = (TileEntityRedstoneJukebox)par1World.func_147438_o(x, y, z)) != null) {
            teJukebox.ejectAll(par1World, x, y, z);
            teJukebox.stopPlaying(false);
        }
        super.func_149749_a(par1World, x, y, z, par5, par6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            boolean haveEnergy = world.func_72864_z(x, y, z);
            if (this.isActive && !haveEnergy || !this.isActive && haveEnergy) {
                world.func_147464_a(x, y, z, (Block)this, 0);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            boolean haveEnergy = world.func_72864_z(x, y, z);
            TileEntityRedstoneJukebox teJukebox = (TileEntityRedstoneJukebox)world.func_147438_o(x, y, z);
            if (this.isActive && !haveEnergy || !this.isActive && haveEnergy) {
                BlockRedstoneJukebox.updateJukeboxBlockState(haveEnergy, world, x, y, z);
                teJukebox.updateJukeboxTileState(haveEnergy);
            }
            teJukebox.tickJukebox();
            if (haveEnergy) {
                world.func_147464_a(x, y, z, (Block)MyBlocks.redstoneJukeboxActive, this.func_149738_a(world));
            }
        }
    }

    public static void updateJukeboxBlockState(boolean active, World world, int x, int y, int z) {
        TileEntity teJukebox = world.func_147438_o(x, y, z);
        keepMyInventory = true;
        if (active) {
            world.func_147465_d(x, y, z, (Block)MyBlocks.redstoneJukeboxActive, 1, 3);
        } else {
            world.func_147465_d(x, y, z, (Block)MyBlocks.redstoneJukebox, 0, 3);
        }
        keepMyInventory = false;
        if (teJukebox != null) {
            teJukebox.func_145829_t();
            world.func_147455_a(x, y, z, teJukebox);
        }
    }

    public static int getAmplifierPower(World world, int x, int y, int z) {
        int amp = 0;
        for (int i = x - 2; i <= x + 2; ++i) {
            for (int k = z - 2; k <= z + 2; ++k) {
                for (int j = y - 1; j <= y + 1; ++j) {
                    if (i == 0 && k == 0 && j == 0 || world.func_147439_a(i, j, k) != Blocks.field_150323_B || (amp += 8) < 128) continue;
                    return 128;
                }
            }
        }
        return amp;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive) {
            this.showSparkles(world, x, y, z, rand);
        }
    }

    private void showSparkles(World world, int x, int y, int z, Random rand) {
        double distance = 0.0625;
        for (int i = 2; i < 6; ++i) {
            double particleX = (float)x + rand.nextFloat();
            double particleY = (float)y + rand.nextFloat();
            double particleZ = (float)z + rand.nextFloat();
            if (i == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                particleZ = (double)(z + 1) + 0.0625;
            }
            if (i == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                particleZ = (double)(z + 0) - 0.0625;
            }
            if (i == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                particleX = (double)(x + 1) + 0.0625;
            }
            if (i == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                particleX = (double)(x + 0) - 0.0625;
            }
            if (!(particleX < (double)x || particleX > (double)(x + 1) || particleY < 0.0 || particleY > (double)(y + 1) || particleZ < (double)z) && !(particleZ > (double)(z + 1))) continue;
            world.func_72869_a("reddust", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }

    private void showNoteAbove(World world, int x, int y, int z) {
        int color = world.field_73012_v.nextInt(16);
        world.func_72869_a("note", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, (double)color / 16.0, 0.0, 0.0);
    }

    public boolean func_149744_f() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int x, int y, int z, int par5) {
        TileEntityRedstoneJukebox teJukebox = (TileEntityRedstoneJukebox)par1World.func_147438_o(x, y, z);
        return teJukebox == null ? 0 : (teJukebox.isPlaying() ? teJukebox.getCurrentJukeboxPlaySlot() + 1 : 0);
    }
}

